/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.living;

import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.block.blockentity.AbyssalAltarBlockEntity;
import com.github.alexmodguy.alexscaves.server.entity.ai.SemiAquaticPathNavigator;
import com.github.alexmodguy.alexscaves.server.entity.ai.VerticalSwimmingMoveControl;
import com.github.alexmodguy.alexscaves.server.entity.item.InkBombEntity;
import com.github.alexmodguy.alexscaves.server.entity.util.DeepOneReaction;
import com.github.alexmodguy.alexscaves.server.level.storage.ACWorldData;
import com.github.alexmodguy.alexscaves.server.misc.ACAdvancementTriggerRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class DeepOneBaseEntity
extends Monster
implements IAnimatedEntity {
    protected boolean isLandNavigator;
    private boolean hasSwimmingSize = false;
    private float fishPitch = 0.0f;
    private float prevFishPitch = 0.0f;
    private Player corneringPlayer;
    private int tradingLockedTime = 0;
    private Animation currentAnimation;
    private int animationTick;
    private static final EntityDataAccessor<Boolean> SWIMMING = SynchedEntityData.m_135353_(DeepOneBaseEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<BlockPos>> ALTAR_POS = SynchedEntityData.m_135353_(DeepOneBaseEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Boolean> SUMMONED = SynchedEntityData.m_135353_(DeepOneBaseEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> SUMMON_TIME = SynchedEntityData.m_135353_(DeepOneBaseEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SOUNDS_ANGRY = SynchedEntityData.m_135353_(DeepOneBaseEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private UUID summonerUUID = null;
    private ItemStack swappedItem = ItemStack.f_41583_;
    private float summonedProgress = 0.0f;
    private float prevSummonedProgress = 0.0f;
    private boolean spawnedLootItem = false;

    protected DeepOneBaseEntity(EntityType entityType, Level level) {
        super(entityType, level);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
        this.switchNavigator(false);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SWIMMING, (Object)false);
        this.f_19804_.m_135372_(SUMMONED, (Object)false);
        this.f_19804_.m_135372_(SUMMON_TIME, (Object)0);
        this.f_19804_.m_135372_(SOUNDS_ANGRY, (Object)false);
        this.f_19804_.m_135372_(ALTAR_POS, Optional.empty());
    }

    public boolean m_6040_() {
        return true;
    }

    protected void switchNavigator(boolean onLand) {
        if (onLand) {
            this.f_21342_ = new MoveControl((Mob)this);
            this.f_21344_ = new GroundPathNavigation((Mob)this, this.m_9236_());
            this.isLandNavigator = true;
        } else {
            this.f_21342_ = new VerticalSwimmingMoveControl((Mob)this, 0.8f, 10.0f);
            this.f_21344_ = this.m_6037_(this.m_9236_());
            this.isLandNavigator = false;
        }
    }

    public static boolean checkDeepOneSpawnRules(EntityType entityType, ServerLevelAccessor level, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource randomSource) {
        if (!level.m_6425_(blockPos.m_7495_()).m_205070_(FluidTags.f_13131_)) {
            return false;
        }
        boolean flag = level.m_46791_() != Difficulty.PEACEFUL && DeepOneBaseEntity.m_219009_((ServerLevelAccessor)level, (BlockPos)blockPos, (RandomSource)randomSource) && (mobSpawnType == MobSpawnType.SPAWNER || level.m_6425_(blockPos).m_205070_(FluidTags.f_13131_));
        return randomSource.m_188503_(110) == 0 && blockPos.m_123342_() < level.m_5736_() - 80 && flag;
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new PathNavigator(worldIn);
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public boolean m_6914_(LevelReader levelReader) {
        return levelReader.m_45784_((Entity)this);
    }

    public void m_8119_() {
        BlockPos altarPos;
        float pitchTarget;
        super.m_8119_();
        this.prevFishPitch = this.fishPitch;
        this.prevSummonedProgress = this.summonedProgress;
        boolean water = this.m_20072_();
        if (water && this.isLandNavigator) {
            this.switchNavigator(false);
        }
        if (!water && !this.isLandNavigator) {
            this.switchNavigator(true);
        }
        if (this.isDeepOneSwimming()) {
            pitchTarget = (float)this.m_20184_().f_82480_ * this.getPitchScale();
            if (!this.m_9236_().f_46443_ && this.m_21573_().m_26571_() && this.m_20096_()) {
                this.setDeepOneSwimming(false);
            }
        } else {
            pitchTarget = 0.0f;
        }
        if (this.isSummoned()) {
            if (this.getSummonTime() > 0) {
                if (this.summonedProgress < 20.0f) {
                    if (this.summonedProgress == 0.0f) {
                        if (!this.m_9236_().f_46443_) {
                            this.m_9236_().m_7605_((Entity)this, (byte)61);
                        }
                        this.m_216990_((SoundEvent)ACSoundRegistry.MAGIC_CONCH_SUMMON.get());
                    }
                    this.summonedProgress += 1.0f;
                }
            } else if (this.summonedProgress > 0.0f) {
                this.summonedProgress -= 1.0f;
            }
            if (this.getSummonTime() > 0) {
                if (!this.m_9236_().f_46443_) {
                    this.setSummonTime(this.getSummonTime() - 1);
                }
                if (this.getSummonTime() == 0) {
                    if (!this.m_9236_().f_46443_) {
                        this.m_9236_().m_7605_((Entity)this, (byte)61);
                    }
                    this.m_216990_((SoundEvent)ACSoundRegistry.MAGIC_CONCH_SUMMON.get());
                }
            } else if (!this.m_9236_().f_46443_ && this.summonedProgress <= 0.0f) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
        if (!this.isSummoned() && this.summonedProgress > 0.0f) {
            this.summonedProgress -= 1.0f;
        }
        if (this.hasSwimmingBoundingBox()) {
            if (!this.hasSwimmingSize) {
                this.hasSwimmingSize = true;
                this.m_6210_();
            }
        } else if (this.hasSwimmingSize) {
            this.hasSwimmingSize = false;
            this.m_6210_();
        }
        if (this.tradingLockedTime > 0) {
            --this.tradingLockedTime;
        }
        if (!this.m_9236_().f_46443_ && this.getAnimation() == this.getTradingAnimation() && this.m_21205_().m_204117_(ACTagRegistry.DEEP_ONE_BARTERS) && (altarPos = this.getLastAltarPos()) != null) {
            Vec3 center = Vec3.m_82512_((Vec3i)altarPos);
            if (this.getAnimationTick() > this.getTradingAnimation().getDuration() - 10) {
                BlockEntity blockEntity = this.m_9236_().m_7702_(altarPos);
                if (blockEntity instanceof AbyssalAltarBlockEntity) {
                    AbyssalAltarBlockEntity altar = (AbyssalAltarBlockEntity)blockEntity;
                    if (!this.spawnedLootItem) {
                        ItemStack stack;
                        List<ItemStack> possibles = this.generateBarterLoot();
                        ItemStack itemStack = stack = possibles.isEmpty() ? ItemStack.f_41583_ : possibles.get(0);
                        if (altar.m_8020_(0).m_41619_()) {
                            altar.m_6836_(0, stack);
                            this.m_9236_().m_7605_((Entity)this, (byte)68);
                            altar.onEntityInteract((LivingEntity)this, false);
                        } else {
                            Vec3 vec3 = center.m_82520_(0.0, 0.5, 0.0);
                            ItemEntity itemEntity = new ItemEntity(this.m_9236_(), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, stack);
                            this.m_9236_().m_7967_((Entity)itemEntity);
                        }
                        double advancementRange = 20.0;
                        for (Player player : this.m_9236_().m_45955_(TargetingConditions.m_148353_().m_26883_(advancementRange), (LivingEntity)this, this.m_20191_().m_82400_(advancementRange))) {
                            if (!((double)player.m_20270_((Entity)this) < advancementRange)) continue;
                            ACAdvancementTriggerRegistry.DEEP_ONE_TRADE.triggerForEntity((Entity)player);
                        }
                        this.spawnedLootItem = true;
                    }
                }
                this.restoreSwappedItem();
            }
            this.m_7618_(EntityAnchorArgument.Anchor.EYES, center);
        }
        if (this.spawnedLootItem && this.getAnimation() != this.getTradingAnimation()) {
            this.spawnedLootItem = false;
        }
        this.fishPitch = Mth.m_14148_((float)this.fishPitch, (float)(Mth.m_14036_((float)pitchTarget, (float)-1.4f, (float)1.4f) * -57.295776f), (float)5.0f);
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    private List<ItemStack> generateBarterLoot() {
        LootTable loottable = this.m_9236_().m_7654_().m_278653_().m_278676_(this.getBarterLootTable());
        return loottable.m_287195_(new LootParams.Builder((ServerLevel)this.m_9236_()).m_287286_(LootContextParams.f_81455_, (Object)this).m_287235_(LootContextParamSets.f_81417_));
    }

    protected abstract ResourceLocation getBarterLootTable();

    protected boolean hasSwimmingBoundingBox() {
        return this.isDeepOneSwimming();
    }

    private float getPitchScale() {
        return 2.0f;
    }

    public float getFishPitch(float partialTick) {
        return this.prevFishPitch + (this.fishPitch - this.prevFishPitch) * partialTick;
    }

    public boolean isDeepOneSwimming() {
        return (Boolean)this.f_19804_.m_135370_(SWIMMING);
    }

    public void setDeepOneSwimming(boolean bool) {
        this.f_19804_.m_135381_(SWIMMING, (Object)bool);
    }

    public BlockPos getLastAltarPos() {
        return ((Optional)this.f_19804_.m_135370_(ALTAR_POS)).orElse(null);
    }

    public boolean isSummoned() {
        return (Boolean)this.f_19804_.m_135370_(SUMMONED);
    }

    public void setSummoned(boolean bool) {
        this.f_19804_.m_135381_(SUMMONED, (Object)bool);
    }

    private int getSummonTime() {
        return (Integer)this.f_19804_.m_135370_(SUMMON_TIME);
    }

    private void setSummonTime(int i) {
        this.f_19804_.m_135381_(SUMMON_TIME, (Object)i);
    }

    public void setLastAltarPos(BlockPos lastAltarPos) {
        this.f_19804_.m_135381_(ALTAR_POS, Optional.ofNullable(lastAltarPos));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        BlockPos lastAltarPos = this.getLastAltarPos();
        if (lastAltarPos != null) {
            compound.m_128405_("AltarX", lastAltarPos.m_123341_());
            compound.m_128405_("AltarY", lastAltarPos.m_123342_());
            compound.m_128405_("AltarZ", lastAltarPos.m_123343_());
        }
        if (!this.swappedItem.m_41619_()) {
            compound.m_128365_("SwappedItem", (Tag)this.swappedItem.m_41739_(new CompoundTag()));
        }
        compound.m_128379_("ConchSummoned", this.isSummoned());
        if (this.summonerUUID != null) {
            compound.m_128362_("ConchUUID", this.summonerUUID);
            compound.m_128405_("ConchTime", this.getSummonTime());
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("AltarX") && compound.m_128441_("AltarY") && compound.m_128441_("AltarZ")) {
            this.setLastAltarPos(new BlockPos(compound.m_128451_("AltarX"), compound.m_128451_("AltarY"), compound.m_128451_("AltarZ")));
        }
        if (compound.m_128441_("SwappedWeapon")) {
            this.swappedItem = ItemStack.m_41712_((CompoundTag)compound.m_128469_("SwappedWeapon"));
        }
        this.setSummoned(compound.m_128471_("ConchSummoned"));
        if (compound.m_128441_("ConchUUID")) {
            this.summonerUUID = compound.m_128342_("ConchUUID");
            this.setSummonTime(compound.m_128451_("ConchTime"));
        }
    }

    public void m_7822_(byte b) {
        if (b == 61) {
            this.m_9236_().m_7106_((ParticleOptions)ACParticleRegistry.BIG_SPLASH.get(), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), (double)(this.m_20205_() + 0.2f), 3.0, 0.0);
        } else if (b == 68) {
            BlockEntity blockEntity;
            BlockPos pos = this.getLastAltarPos();
            if (pos != null && (blockEntity = this.m_9236_().m_7702_(pos)) instanceof AbyssalAltarBlockEntity) {
                AbyssalAltarBlockEntity altarBlockEntity = (AbyssalAltarBlockEntity)blockEntity;
                altarBlockEntity.onEntityInteract((LivingEntity)this, false);
            }
        } else if (b == 69) {
            BlockEntity blockEntity;
            BlockPos pos = this.getLastAltarPos();
            if (pos != null && (blockEntity = this.m_9236_().m_7702_(pos)) instanceof AbyssalAltarBlockEntity) {
                AbyssalAltarBlockEntity altarBlockEntity = (AbyssalAltarBlockEntity)blockEntity;
                altarBlockEntity.onEntityInteract((LivingEntity)this, true);
                altarBlockEntity.m_6836_(0, ItemStack.f_41583_);
            }
        } else {
            super.m_7822_(b);
        }
    }

    public void setSummonedBy(LivingEntity player, int time) {
        this.setSummoned(true);
        this.summonerUUID = player.m_20148_();
        this.setSummonTime(time);
    }

    public boolean m_21515_() {
        return super.m_21515_() && (!this.isSummoned() || this.summonedProgress >= 20.0f);
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_21515_() && this.m_20072_()) {
            this.m_19920_(this.m_6113_(), travelVector);
            Vec3 delta = this.m_20184_();
            if (Double.isNaN(delta.f_82480_)) {
                delta = new Vec3(delta.f_82479_, 0.0, delta.f_82481_);
            }
            if (this.sinksWhenNotSwimming() && !this.isDeepOneSwimming()) {
                delta = delta.m_82490_(0.8);
                delta = this.f_20899_ || this.f_19862_ ? delta.m_82520_(0.0, (double)0.1f, 0.0) : delta.m_82520_(0.0, (double)-0.05f, 0.0);
            }
            this.m_6478_(MoverType.SELF, delta);
            this.m_20256_(delta.m_82490_(0.8));
        } else {
            super.m_7023_(travelVector);
        }
    }

    public boolean m_6067_() {
        return this.isDeepOneSwimming();
    }

    public boolean m_6063_() {
        return false;
    }

    public EntityDimensions m_6972_(Pose poseIn) {
        return this.isDeepOneSwimming() ? this.getSwimmingSize() : super.m_6972_(poseIn);
    }

    public DeepOneReaction getReactionTo(Player player) {
        if (this.isSummoned() && this.summonerUUID != null && this.summonerUUID.equals(player.m_20148_())) {
            return DeepOneReaction.HELPFUL;
        }
        return DeepOneReaction.fromReputation(this.getReputationOf(player.m_20148_()));
    }

    public int getReputationOf(UUID playerUUID) {
        if (!this.m_9236_().f_46443_) {
            ACWorldData worldData = ACWorldData.get(this.m_9236_());
            return worldData == null ? 0 : worldData.getDeepOneReputation(playerUUID);
        }
        return 0;
    }

    public void setReputationOf(UUID playerUUID, int amount) {
        ACWorldData worldData;
        if (!this.m_9236_().f_46443_ && (worldData = ACWorldData.get(this.m_9236_())) != null) {
            worldData.setDeepOneReputation(playerUUID, amount);
        }
    }

    public void addReputation(UUID playerUUID, int amount) {
        Player player;
        int prev = this.getReputationOf(playerUUID);
        DeepOneReaction newReaction = DeepOneReaction.fromReputation(amount + prev);
        this.setReputationOf(playerUUID, amount + prev);
        if (DeepOneReaction.fromReputation(prev) != newReaction && (player = this.m_9236_().m_46003_(playerUUID)) != null) {
            if (newReaction == DeepOneReaction.NEUTRAL) {
                ACAdvancementTriggerRegistry.DEEP_ONE_NEUTRAL.triggerForEntity((Entity)player);
            }
            if (newReaction == DeepOneReaction.HELPFUL) {
                ACAdvancementTriggerRegistry.DEEP_ONE_HELPFUL.triggerForEntity((Entity)player);
            }
            player.m_5661_((Component)Component.m_237115_((String)("entity.alexscaves.deep_one.reaction_" + newReaction.toString().toLowerCase(Locale.ROOT))), true);
        }
    }

    public void setTradingLockedTime(int i) {
        this.tradingLockedTime = Math.max(i, this.tradingLockedTime);
    }

    public boolean isTradingLocked() {
        return this.tradingLockedTime > 0;
    }

    public EntityDimensions getSwimmingSize() {
        return this.m_6095_().m_20680_().m_20388_(this.m_6134_());
    }

    protected boolean sinksWhenNotSwimming() {
        return true;
    }

    public void setCorneredBy(Player player) {
        this.corneringPlayer = player;
    }

    public Player getCorneringPlayer() {
        return this.corneringPlayer;
    }

    public void m_267651_(boolean flying) {
        if (this.isDeepOneSwimming()) {
            float f1 = (float)Mth.m_184648_((double)(this.m_20185_() - this.f_19854_), (double)(this.m_20186_() - this.f_19855_), (double)(this.m_20189_() - this.f_19856_));
            float f2 = Math.min(f1 * 6.0f, 1.0f);
            this.f_267362_.m_267566_(f2, 0.4f);
        } else {
            super.m_267651_(flying);
        }
    }

    public boolean m_6469_(DamageSource damageSource, float damageValue) {
        Entity entity;
        boolean sup = super.m_6469_(damageSource, damageValue);
        if (sup && (entity = damageSource.m_7639_()) instanceof Player) {
            Player player = (Player)entity;
            if (!this.m_9236_().f_46443_ && !damageSource.m_269533_(ACTagRegistry.DEEP_ONE_IGNORES)) {
                int decrease = -5;
                if (!this.m_6084_()) {
                    decrease = -15;
                }
                this.addReputation(player.m_20148_(), decrease);
            }
        }
        return sup;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public boolean startDisappearBehavior(Player player) {
        InkBombEntity inkBombEntity = new InkBombEntity(this.m_9236_(), (LivingEntity)this);
        Vec3 vec3 = player.m_20184_();
        double d0 = player.m_20185_() + vec3.f_82479_ - this.m_20185_();
        double d1 = player.m_20188_() + vec3.f_82480_ - this.m_20188_();
        double d2 = player.m_20189_() + vec3.f_82481_ - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
        inkBombEntity.m_6686_(d0, d1, d2, 0.5f + 0.2f * (float)d3, 12.0f);
        this.m_9236_().m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12553_, this.m_5720_(), 1.0f, 0.8f + this.m_217043_().m_188501_() * 0.4f);
        this.m_9236_().m_7967_((Entity)inkBombEntity);
        this.addReputation(player.m_20148_(), -1);
        return true;
    }

    public void startAttackBehavior(LivingEntity target) {
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    protected void checkAndDealMeleeDamage(LivingEntity target, float multiplier) {
        this.checkAndDealMeleeDamage(target, multiplier, 0.25f);
    }

    protected void checkAndDealMeleeDamage(LivingEntity target, float multiplier, float knockback) {
        if (this.m_142582_((Entity)target) && (double)this.m_20270_((Entity)target) < (double)(this.m_20205_() + target.m_20205_()) + 5.0) {
            float f = (float)this.m_21051_(Attributes.f_22281_).m_22135_() * multiplier;
            target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), f);
            target.m_147240_((double)(knockback * multiplier), this.m_20185_() - target.m_20185_(), this.m_20189_() - target.m_20189_());
            Entity entity = target.m_20202_();
            if (entity != null) {
                entity.m_20256_(target.m_20184_());
                entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), f);
            }
        }
    }

    public abstract Animation getTradingAnimation();

    public boolean soundsAngry() {
        return (Boolean)this.f_19804_.m_135370_(SOUNDS_ANGRY);
    }

    public void setSoundsAngry(boolean angrySounding) {
        this.f_19804_.m_135381_(SOUNDS_ANGRY, (Object)angrySounding);
    }

    public boolean m_7307_(Entity entityIn) {
        if (entityIn instanceof DeepOneBaseEntity) {
            return true;
        }
        if (entityIn instanceof Player) {
            return this.getReactionTo((Player)entityIn) == DeepOneReaction.HELPFUL || super.m_7307_(entityIn);
        }
        return super.m_7307_(entityIn);
    }

    public void swapItemsForAnimation(ItemStack item) {
        if (!this.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
            this.swappedItem = this.m_21120_(InteractionHand.MAIN_HAND).m_41777_();
        }
        this.m_21008_(InteractionHand.MAIN_HAND, item);
    }

    public void restoreSwappedItem() {
        this.m_21008_(InteractionHand.MAIN_HAND, this.swappedItem);
    }

    public float getSummonProgress(float partialTicks) {
        return (this.prevSummonedProgress + (this.summonedProgress - this.prevSummonedProgress) * partialTicks) / 20.0f;
    }

    public void copyTarget(LivingEntity player) {
        LivingEntity priorTarget = this.m_5448_();
        if (priorTarget == null || !priorTarget.m_6084_()) {
            LivingEntity target = null;
            if (player.m_21214_() != null) {
                target = player.m_21214_();
            } else if (player.m_21188_() != null) {
                target = player.m_21188_();
            }
            if (target != null && target.m_6084_() && !target.m_7307_((Entity)player) && !target.m_7307_((Entity)this) && !(target instanceof DeepOneBaseEntity)) {
                this.m_6710_(target);
            }
        }
    }

    public abstract SoundEvent getAdmireSound();

    private class PathNavigator
    extends SemiAquaticPathNavigator {
        public PathNavigator(Level worldIn) {
            super((Mob)DeepOneBaseEntity.this, worldIn);
        }

        protected Vec3 m_7475_() {
            return new Vec3(this.f_26494_.m_20185_(), this.f_26494_.m_20227_(0.5), this.f_26494_.m_20189_());
        }

        protected double m_183345_(Vec3 vec3) {
            if (DeepOneBaseEntity.this.isDeepOneSwimming() || !DeepOneBaseEntity.this.m_20072_()) {
                return super.m_183345_(vec3);
            }
            BlockPos blockpos = BlockPos.m_274446_((Position)vec3);
            return this.f_26495_.m_6425_(blockpos.m_7495_()).m_76178_() ? vec3.f_82480_ : WalkNodeEvaluator.m_77611_((BlockGetter)this.f_26495_, (BlockPos)blockpos);
        }
    }

    public class HurtByHostileTargetGoal
    extends HurtByTargetGoal {
        public HurtByHostileTargetGoal() {
            super((PathfinderMob)DeepOneBaseEntity.this, new Class[]{DeepOneBaseEntity.class});
            this.m_26044_(new Class[0]);
        }

        protected boolean m_26150_(@Nullable LivingEntity target, TargetingConditions conditions) {
            Player player;
            if (target instanceof Player && DeepOneBaseEntity.this.getReactionTo(player = (Player)target) == DeepOneReaction.HELPFUL) {
                return false;
            }
            return super.m_26150_(target, conditions);
        }

        protected void m_26047_() {
            double d0 = this.m_7623_();
            AABB aabb = AABB.m_82333_((Vec3)this.f_26135_.m_20182_()).m_82377_(d0, 10.0, d0);
            List list = this.f_26135_.m_9236_().m_6443_(DeepOneBaseEntity.class, aabb, EntitySelector.f_20408_);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Mob mob = (Mob)iterator.next();
                if (this.f_26135_ == mob || mob.m_5448_() != null || this.f_26135_ instanceof TamableAnimal && ((TamableAnimal)this.f_26135_).m_269323_() != ((TamableAnimal)mob).m_269323_() || mob.m_7307_((Entity)this.f_26135_.m_21188_())) continue;
                boolean flag = false;
                if (DeepOneBaseEntity.class.isAssignableFrom(mob.getClass())) {
                    flag = true;
                } else if (flag) continue;
                this.m_5766_(mob, this.f_26135_.m_21188_());
            }
            return;
        }
    }
}

