/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.ai;

import com.github.alexmodguy.alexscaves.server.entity.living.GrottoceratopsEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACSoundRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.EnumSet;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;

public class GrottoceratopsMeleeGoal
extends Goal {
    private GrottoceratopsEntity grottoceratops;
    private float startTailYaw = 0.0f;

    public GrottoceratopsMeleeGoal(GrottoceratopsEntity grottoceratops) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.grottoceratops = grottoceratops;
    }

    public boolean m_8036_() {
        return this.grottoceratops.m_5448_() != null && this.grottoceratops.m_5448_().m_6084_();
    }

    public void m_8041_() {
        this.startTailYaw = 0.0f;
    }

    public void m_8037_() {
        LivingEntity target = this.grottoceratops.m_5448_();
        if (target != null) {
            double dist = this.grottoceratops.m_20270_((Entity)target);
            if (dist < (double)(this.grottoceratops.m_20205_() + target.m_20205_()) + 3.0 && this.grottoceratops.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                if (this.grottoceratops.m_217043_().m_188499_()) {
                    this.tryAnimation(GrottoceratopsEntity.ANIMATION_MELEE_RAM);
                } else {
                    boolean left = this.grottoceratops.m_217043_().m_188499_();
                    this.startTailYaw = this.grottoceratops.m_146908_() + (float)(left ? 30 : -30);
                    this.tryAnimation(left ? GrottoceratopsEntity.ANIMATION_MELEE_TAIL_1 : GrottoceratopsEntity.ANIMATION_MELEE_TAIL_2);
                }
            }
            if (this.grottoceratops.getAnimation() == GrottoceratopsEntity.ANIMATION_MELEE_RAM && this.grottoceratops.getAnimationTick() > 10 && this.grottoceratops.getAnimationTick() <= 12) {
                this.checkAndDealDamage(target, 1.0f);
            }
            if (this.grottoceratops.getAnimation() == GrottoceratopsEntity.ANIMATION_MELEE_TAIL_1 || this.grottoceratops.getAnimation() == GrottoceratopsEntity.ANIMATION_MELEE_TAIL_2) {
                if (this.grottoceratops.getAnimationTick() > 10 && this.grottoceratops.getAnimationTick() <= 12) {
                    this.checkAndDealDamage(target, 1.5f);
                }
            } else {
                this.grottoceratops.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_());
                this.grottoceratops.m_21573_().m_5624_((Entity)target, 1.35);
            }
        }
    }

    private void checkAndDealDamage(LivingEntity target, float multiplier) {
        if (this.grottoceratops.m_142582_((Entity)target) && (double)this.grottoceratops.m_20270_((Entity)target) < (double)(this.grottoceratops.m_20205_() + target.m_20205_()) + 1.0) {
            this.grottoceratops.m_216990_((SoundEvent)ACSoundRegistry.GROTTOCERATOPS_ATTACK.get());
            target.m_6469_(target.m_269291_().m_269333_((LivingEntity)this.grottoceratops), (float)this.grottoceratops.m_21051_(Attributes.f_22281_).m_22135_() * multiplier);
            target.m_147240_(0.8 + 0.5 * (double)multiplier, this.grottoceratops.m_20185_() - target.m_20185_(), this.grottoceratops.m_20189_() - target.m_20189_());
        }
    }

    private boolean tryAnimation(Animation animation) {
        if (this.grottoceratops.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
            this.grottoceratops.setAnimation(animation);
            return true;
        }
        return false;
    }
}

