/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.ACSoundTypes;
import com.github.alexmodguy.alexscaves.server.block.fluid.ACFluidRegistry;
import com.github.alexmodguy.alexscaves.server.item.ACItemRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RebarBlock
extends Block
implements BucketPickup,
LiquidBlockContainer {
    public static final BooleanProperty CONNECT_X = BooleanProperty.m_61465_((String)"connect_x");
    public static final BooleanProperty CONNECT_Y = BooleanProperty.m_61465_((String)"connect_y");
    public static final BooleanProperty CONNECT_Z = BooleanProperty.m_61465_((String)"connect_z");
    public final Map<BlockState, VoxelShape> shapeMap = new HashMap<BlockState, VoxelShape>();
    public static final VoxelShape CENTER_SHAPE = Block.m_49796_((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)9.0, (double)9.0);
    public static final VoxelShape X_SHAPE = Block.m_49796_((double)0.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0);
    public static final VoxelShape Y_SHAPE = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    public static final VoxelShape Z_SHAPE = Block.m_49796_((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)16.0);
    public static final IntegerProperty LIQUID_LOGGED = IntegerProperty.m_61631_((String)"liquid_logged", (int)0, (int)2);

    public RebarBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60978_(2.0f).m_60918_(ACSoundTypes.SCRAP_METAL));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)CONNECT_X, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CONNECT_Y, (Comparable)Boolean.valueOf(true))).m_61124_((Property)CONNECT_Z, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIQUID_LOGGED, (Comparable)Integer.valueOf(0)));
    }

    protected VoxelShape getRebarShape(BlockState state) {
        if (this.shapeMap.containsKey(state)) {
            return this.shapeMap.get(state);
        }
        VoxelShape merge = CENTER_SHAPE;
        if (((Boolean)state.m_61143_((Property)CONNECT_X)).booleanValue()) {
            merge = Shapes.m_83113_((VoxelShape)merge, (VoxelShape)X_SHAPE, (BooleanOp)BooleanOp.f_82695_);
        }
        if (((Boolean)state.m_61143_((Property)CONNECT_Y)).booleanValue()) {
            merge = Shapes.m_83113_((VoxelShape)merge, (VoxelShape)Y_SHAPE, (BooleanOp)BooleanOp.f_82695_);
        }
        if (((Boolean)state.m_61143_((Property)CONNECT_Z)).booleanValue()) {
            merge = Shapes.m_83113_((VoxelShape)merge, (VoxelShape)Z_SHAPE, (BooleanOp)BooleanOp.f_82695_);
        }
        this.shapeMap.put(state, merge);
        return merge;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return this.getRebarShape(state);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        BlockState desired = this.getDesiredRebarState(state, context.m_43719_().m_122434_());
        return !context.m_7078_() && context.m_43722_().m_150930_(this.m_5456_()) && (state.m_61143_((Property)CONNECT_X) != desired.m_61143_((Property)CONNECT_X) || state.m_61143_((Property)CONNECT_Y) != desired.m_61143_((Property)CONNECT_Y) || state.m_61143_((Property)CONNECT_Z) != desired.m_61143_((Property)CONNECT_Z)) || super.m_6864_(state, context);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_());
        int fluid = this.getLiquidType(context.m_43725_().m_6425_(context.m_8083_()));
        return (BlockState)this.getDesiredRebarState(blockstate, context.m_43719_().m_122434_()).m_61124_((Property)LIQUID_LOGGED, (Comparable)Integer.valueOf(fluid));
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState blockState, boolean forced) {
        if (!level.f_46443_) {
            level.m_186460_(pos, (Block)this, 1);
        }
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState1, LevelAccessor levelAccessor, BlockPos pos, BlockPos pos1) {
        int liquidType = (Integer)blockState.m_61143_((Property)LIQUID_LOGGED);
        if (liquidType == 1) {
            levelAccessor.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        } else if (liquidType == 2) {
            levelAccessor.m_186469_(pos, (Fluid)ACFluidRegistry.ACID_FLUID_SOURCE.get(), ((FlowingFluid)ACFluidRegistry.ACID_FLUID_SOURCE.get()).m_6718_((LevelReader)levelAccessor));
        }
        if (!levelAccessor.m_5776_()) {
            levelAccessor.m_186460_(pos, (Block)this, 1);
        }
        return blockState;
    }

    public FluidState m_5888_(BlockState state) {
        int liquidType = (Integer)state.m_61143_((Property)LIQUID_LOGGED);
        return liquidType == 1 ? Fluids.f_76193_.m_76068_(false) : (liquidType == 2 ? ((FlowingFluid)ACFluidRegistry.ACID_FLUID_SOURCE.get()).m_76068_(false) : super.m_5888_(state));
    }

    public boolean m_6044_(BlockGetter getter, BlockPos blockPos, BlockState blockState, Fluid fluid) {
        return fluid == Fluids.f_76193_ || fluid.getFluidType() == ACFluidRegistry.ACID_FLUID_TYPE.get();
    }

    public boolean m_7361_(LevelAccessor levelAccessor, BlockPos pos, BlockState blockState, FluidState fluidState) {
        int liquidType = (Integer)blockState.m_61143_((Property)LIQUID_LOGGED);
        if (liquidType == 0) {
            if (!levelAccessor.m_5776_()) {
                if (fluidState.m_76152_() == Fluids.f_76193_) {
                    levelAccessor.m_7731_(pos, (BlockState)blockState.m_61124_((Property)LIQUID_LOGGED, (Comparable)Integer.valueOf(1)), 3);
                } else if (fluidState.getFluidType() == ACFluidRegistry.ACID_FLUID_TYPE.get()) {
                    BlockState state = blockState;
                    if (blockState.m_60734_() == ACBlockRegistry.METAL_REBAR.get()) {
                        levelAccessor.m_46796_(1501, pos, 0);
                        state = (BlockState)((BlockState)((BlockState)((Block)ACBlockRegistry.RUSTY_REBAR.get()).m_49966_().m_61124_((Property)CONNECT_X, (Comparable)((Boolean)blockState.m_61143_((Property)CONNECT_X)))).m_61124_((Property)CONNECT_Y, (Comparable)((Boolean)blockState.m_61143_((Property)CONNECT_Y)))).m_61124_((Property)CONNECT_Z, (Comparable)((Boolean)blockState.m_61143_((Property)CONNECT_Z)));
                    }
                    levelAccessor.m_7731_(pos, (BlockState)state.m_61124_((Property)LIQUID_LOGGED, (Comparable)Integer.valueOf(2)), 3);
                }
                levelAccessor.m_186469_(pos, fluidState.m_76152_(), fluidState.m_76152_().m_6718_((LevelReader)levelAccessor));
            }
            return true;
        }
        return false;
    }

    public ItemStack m_142598_(LevelAccessor levelAccessor, BlockPos blockPos, BlockState state) {
        int liquidType = (Integer)state.m_61143_((Property)LIQUID_LOGGED);
        levelAccessor.m_7731_(blockPos, (BlockState)state.m_61124_((Property)LIQUID_LOGGED, (Comparable)Integer.valueOf(0)), 3);
        if (liquidType > 0) {
            return new ItemStack((ItemLike)(liquidType == 1 ? Items.f_42447_ : (ItemLike)ACItemRegistry.ACID_BUCKET.get()));
        }
        return ItemStack.f_41583_;
    }

    public Optional<SoundEvent> m_142298_() {
        return Fluids.f_76193_.m_142520_();
    }

    private int getLiquidType(FluidState fluidState) {
        if (fluidState.m_76152_() == Fluids.f_76193_) {
            return 1;
        }
        if (fluidState.getFluidType() == ACFluidRegistry.ACID_FLUID_TYPE.get()) {
            return 2;
        }
        return 0;
    }

    public BlockState getDesiredRebarState(BlockState blockstate, Direction.Axis clickedAxis) {
        boolean xAxis = false;
        boolean yAxis = false;
        boolean zAxis = false;
        if (blockstate.m_60713_((Block)this)) {
            xAxis = (Boolean)blockstate.m_61143_((Property)CONNECT_X);
            yAxis = (Boolean)blockstate.m_61143_((Property)CONNECT_Y);
            zAxis = (Boolean)blockstate.m_61143_((Property)CONNECT_Z);
        }
        if (clickedAxis == Direction.Axis.X) {
            xAxis = true;
        } else if (clickedAxis == Direction.Axis.Y) {
            yAxis = true;
        } else if (clickedAxis == Direction.Axis.Z) {
            zAxis = true;
        }
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)CONNECT_X, (Comparable)Boolean.valueOf(xAxis))).m_61124_((Property)CONNECT_Y, (Comparable)Boolean.valueOf(yAxis))).m_61124_((Property)CONNECT_Z, (Comparable)Boolean.valueOf(zAxis));
    }

    public void m_6240_(Level level, Player player, BlockPos blockPos, BlockState blockState, @Nullable BlockEntity blockEntity, ItemStack stack) {
        super.m_6240_(level, player, blockPos, blockState, blockEntity, stack);
        Vec3 findDirOf = player.m_146892_().m_82546_(Vec3.m_82512_((Vec3i)blockPos));
        Direction.Axis axis = Direction.m_122366_((double)findDirOf.f_82479_, (double)findDirOf.f_82480_, (double)findDirOf.f_82481_).m_122434_();
        if (axis == Direction.Axis.X && ((Boolean)blockState.m_61143_((Property)CONNECT_X)).booleanValue()) {
            level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)CONNECT_X, (Comparable)Boolean.valueOf(false)), 2);
        } else if (axis == Direction.Axis.Y && ((Boolean)blockState.m_61143_((Property)CONNECT_Y)).booleanValue()) {
            level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)CONNECT_Y, (Comparable)Boolean.valueOf(false)), 2);
        } else if (axis == Direction.Axis.Z && ((Boolean)blockState.m_61143_((Property)CONNECT_Z)).booleanValue()) {
            level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)CONNECT_Z, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        BlockState def = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)CONNECT_X, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CONNECT_Z, (Comparable)Boolean.valueOf(false));
        if (rotation == Rotation.CLOCKWISE_90 || rotation == Rotation.COUNTERCLOCKWISE_90) {
            if (((Boolean)state.m_61143_((Property)CONNECT_X)).booleanValue()) {
                def = (BlockState)def.m_61124_((Property)CONNECT_Z, (Comparable)Boolean.valueOf(true));
            }
            if (((Boolean)state.m_61143_((Property)CONNECT_Z)).booleanValue()) {
                def = (BlockState)def.m_61124_((Property)CONNECT_X, (Comparable)Boolean.valueOf(true));
            }
        }
        return def;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{CONNECT_X, CONNECT_Y, CONNECT_Z, LIQUID_LOGGED});
    }
}

