/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.ACSoundTypes;
import com.github.alexmodguy.alexscaves.server.block.NuclearFurnaceBlock;
import com.github.alexmodguy.alexscaves.server.block.blockentity.NuclearFurnaceBlockEntity;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.github.alexmodguy.alexscaves.server.potion.ACEffectRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class NuclearFurnaceComponentBlock
extends Block
implements WorldlyContainerHolder {
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");
    private static final VoxelShape TOP_1_SHAPE = ACMath.buildShape(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)9.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0));
    private static final VoxelShape TOP_2_SHAPE = ACMath.buildShape(Block.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0));
    private static final VoxelShape TOP_3_SHAPE = ACMath.buildShape(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)9.0), Block.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    private static final VoxelShape TOP_4_SHAPE = ACMath.buildShape(Block.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));

    public NuclearFurnaceComponentBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_278166_(PushReaction.BLOCK).m_60913_(5.0f, 1001.0f).m_60918_(ACSoundTypes.NUCLEAR_BOMB).m_60955_().m_60977_());
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        BlockPos corner;
        if (((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue() && (corner = NuclearFurnaceComponentBlock.getCornerForFurnace(getter, pos, true)) != null && corner.m_123342_() == pos.m_123342_() - 1) {
            BlockPos sub = pos.m_121996_((Vec3i)corner);
            if (sub.m_123341_() == 0 && sub.m_123343_() == 0) {
                return TOP_1_SHAPE;
            }
            if (sub.m_123341_() == 0 && sub.m_123343_() == 1) {
                return TOP_2_SHAPE;
            }
            if (sub.m_123341_() == 1 && sub.m_123343_() == 0) {
                return TOP_3_SHAPE;
            }
            if (sub.m_123341_() == 1 && sub.m_123343_() == 1) {
                return TOP_4_SHAPE;
            }
        }
        return super.m_5940_(state, getter, pos, context);
    }

    public void m_7892_(BlockState state, Level level, BlockPos blockPos, Entity entity) {
        NuclearFurnaceBlockEntity furnace;
        BlockEntity blockEntity;
        BlockPos corner;
        if (((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue() && (corner = NuclearFurnaceComponentBlock.getCornerForFurnace((BlockGetter)level, blockPos, true)) != null && corner.m_123342_() == blockPos.m_123342_() - 1 && (blockEntity = level.m_7702_(corner)) instanceof NuclearFurnaceBlockEntity && (furnace = (NuclearFurnaceBlockEntity)blockEntity).isUndergoingFission() && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (!entity.m_6095_().m_204039_(ACTagRegistry.RESISTS_RADIATION)) {
                living.m_7292_(new MobEffectInstance((MobEffect)ACEffectRegistry.IRRADIATED.get(), 2000, 4));
            }
        }
    }

    public boolean m_7357_(BlockState state, BlockGetter getter, BlockPos blockPos, PathComputationType pathComputationType) {
        return false;
    }

    @Nullable
    public static BlockPos getCornerForFurnace(BlockGetter levelAccessor, BlockPos componentPos, boolean postConstruction) {
        int j;
        if (postConstruction) {
            for (BlockPos pos : BlockPos.m_121976_((int)(componentPos.m_123341_() - 1), (int)(componentPos.m_123342_() - 1), (int)(componentPos.m_123343_() - 1), (int)(componentPos.m_123341_() + 1), (int)(componentPos.m_123342_() + 1), (int)(componentPos.m_123343_() + 1))) {
                if (!levelAccessor.m_8055_(pos).m_60713_((Block)ACBlockRegistry.NUCLEAR_FURNACE.get())) continue;
                return pos;
            }
            return null;
        }
        BlockPos furthest = componentPos;
        int maxDist = 1;
        for (j = 0; NuclearFurnaceComponentBlock.canBecomeAComponent(levelAccessor, furthest.m_122024_(), false) && j < maxDist; ++j) {
            furthest = furthest.m_122024_();
        }
        for (j = -1; NuclearFurnaceComponentBlock.canBecomeAComponent(levelAccessor, furthest.m_7495_(), false) && j < maxDist; ++j) {
            furthest = furthest.m_7495_();
        }
        for (j = -1; NuclearFurnaceComponentBlock.canBecomeAComponent(levelAccessor, furthest.m_122012_(), false) && j < maxDist; ++j) {
            furthest = furthest.m_122012_();
        }
        return NuclearFurnaceComponentBlock.canBecomeAComponent(levelAccessor, furthest, false) ? furthest : null;
    }

    public static boolean isCornerForFurnace(LevelReader levelAccessor, BlockPos componentPos, boolean checkMiddle, boolean active) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int x = 0; x <= 1; ++x) {
            for (int y = 0; y <= 1; ++y) {
                for (int z = 0; z <= 1; ++z) {
                    BlockState state;
                    mutableBlockPos.m_122178_(componentPos.m_123341_() + x, componentPos.m_123342_() + y, componentPos.m_123343_() + z);
                    if (!checkMiddle && x == 0 && y == 0 && z == 0 || (state = levelAccessor.m_8055_((BlockPos)mutableBlockPos)).m_60713_((Block)ACBlockRegistry.NUCLEAR_FURNACE_COMPONENT.get()) && (Boolean)state.m_61143_((Property)ACTIVE) == active) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static void activateNeighbors(LevelAccessor levelAccessor, BlockPos cornerPos, boolean active) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int x = 0; x <= 1; ++x) {
            for (int y = 0; y <= 1; ++y) {
                for (int z = 0; z <= 1; ++z) {
                    mutableBlockPos.m_122178_(cornerPos.m_123341_() + x, cornerPos.m_123342_() + y, cornerPos.m_123343_() + z);
                    BlockState state = levelAccessor.m_8055_((BlockPos)mutableBlockPos);
                    if (!state.m_60713_((Block)ACBlockRegistry.NUCLEAR_FURNACE_COMPONENT.get())) continue;
                    levelAccessor.m_7731_((BlockPos)mutableBlockPos, (BlockState)((Block)ACBlockRegistry.NUCLEAR_FURNACE_COMPONENT.get()).m_49966_().m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(active)), 3);
                }
            }
        }
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState state, @Nullable LivingEntity living, ItemStack itemStack) {
        BlockPos corner = NuclearFurnaceComponentBlock.getCornerForFurnace((BlockGetter)level, blockPos, false);
        if (corner != null && NuclearFurnaceComponentBlock.isCornerForFurnace((LevelReader)level, corner, true, false)) {
            Direction facing = living == null ? Direction.NORTH : living.m_6350_().m_122424_();
            level.m_46597_(corner, (BlockState)((Block)ACBlockRegistry.NUCLEAR_FURNACE.get()).m_49966_().m_61124_((Property)NuclearFurnaceBlock.FACING, (Comparable)facing));
            NuclearFurnaceComponentBlock.activateNeighbors((LevelAccessor)level, corner, true);
        }
    }

    public static boolean canBecomeAComponent(BlockGetter levelAccessor, BlockPos componentPos, boolean postConstruction) {
        BlockState state = levelAccessor.m_8055_(componentPos);
        if (postConstruction) {
            return state.m_60713_((Block)ACBlockRegistry.NUCLEAR_FURNACE_COMPONENT.get()) || state.m_60713_((Block)ACBlockRegistry.NUCLEAR_FURNACE.get());
        }
        return state.m_60713_((Block)ACBlockRegistry.NUCLEAR_FURNACE_COMPONENT.get()) && (Boolean)state.m_61143_((Property)ACTIVE) == false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.m_61104_(new Property[]{ACTIVE});
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        if (((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue()) {
            BlockPos corner = NuclearFurnaceComponentBlock.getCornerForFurnace((BlockGetter)level, pos, true);
            return corner != null && level.m_8055_(corner).m_60713_((Block)ACBlockRegistry.NUCLEAR_FURNACE.get()) && NuclearFurnaceComponentBlock.isCornerForFurnace(level, corner, false, true);
        }
        return true;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState state1, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos1) {
        if (!state.m_60710_((LevelReader)levelAccessor, blockPos)) {
            this.checkCriticalityExplosion((LevelReader)levelAccessor, blockPos);
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, state1, levelAccessor, blockPos, blockPos1);
    }

    public void m_6240_(Level level, Player player, BlockPos blockPos, BlockState state, @Nullable BlockEntity entity, ItemStack itemStack) {
        this.checkCriticalityExplosion((LevelReader)level, blockPos);
        super.m_6240_(level, player, blockPos, state, entity, itemStack);
    }

    private void checkCriticalityExplosion(LevelReader level, BlockPos pos) {
        NuclearFurnaceBlockEntity nuclearFurnaceBlockEntity;
        BlockEntity blockEntity;
        BlockPos corner;
        BlockState state = level.m_8055_(pos);
        if (state.m_60713_((Block)this) && ((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue() && (corner = NuclearFurnaceComponentBlock.getCornerForFurnace((BlockGetter)level, pos, true)) != null && (blockEntity = level.m_7702_(corner)) instanceof NuclearFurnaceBlockEntity && (float)(nuclearFurnaceBlockEntity = (NuclearFurnaceBlockEntity)blockEntity).getCriticality() >= 2.0f) {
            nuclearFurnaceBlockEntity.destroyWhileCritical(false);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockEntity blockEntity;
        BlockPos corner;
        if (((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue() && !player.m_6144_() && (corner = NuclearFurnaceComponentBlock.getCornerForFurnace((BlockGetter)level, blockPos, true)) != null && level.m_8055_(corner).m_60713_((Block)ACBlockRegistry.NUCLEAR_FURNACE.get()) && NuclearFurnaceComponentBlock.isCornerForFurnace((LevelReader)level, corner, false, true) && (blockEntity = level.m_7702_(corner)) instanceof NuclearFurnaceBlockEntity) {
            NuclearFurnaceBlockEntity nuclearFurnaceBlockEntity = (NuclearFurnaceBlockEntity)blockEntity;
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            if (this.m_7898_(state, (LevelReader)level, blockPos)) {
                player.m_5893_((MenuProvider)nuclearFurnaceBlockEntity);
                nuclearFurnaceBlockEntity.onPlayerUse(player);
                player.m_36220_(Stats.f_12966_);
                return InteractionResult.CONSUME;
            }
        }
        return super.m_6227_(state, level, blockPos, player, hand, result);
    }

    public WorldlyContainer m_5840_(BlockState state, LevelAccessor levelAccessor, BlockPos blockPos) {
        BlockEntity blockEntity;
        BlockPos corner;
        if (((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue() && (corner = NuclearFurnaceComponentBlock.getCornerForFurnace((BlockGetter)levelAccessor, blockPos, true)) != null && (blockEntity = levelAccessor.m_7702_(corner)) instanceof NuclearFurnaceBlockEntity) {
            NuclearFurnaceBlockEntity nuclearFurnaceBlockEntity = (NuclearFurnaceBlockEntity)blockEntity;
            return nuclearFurnaceBlockEntity.getContainerFor(blockPos.m_121996_((Vec3i)corner));
        }
        return null;
    }
}

