/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.compat.jei;

import com.github.alexmodguy.alexscaves.compat.jei.AlexsCavesPlugin;
import com.github.alexmodguy.alexscaves.compat.jei.NuclearFurnaceDrawable;
import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

public class NuclearFurnaceRecipeCategory
implements IRecipeCategory<AbstractCookingRecipe> {
    private final IDrawable background = new NuclearFurnaceDrawable();
    private final IDrawable icon;

    public NuclearFurnaceRecipeCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)ACBlockRegistry.NUCLEAR_FURNACE_COMPONENT.get()));
    }

    public RecipeType<AbstractCookingRecipe> getRecipeType() {
        return AlexsCavesPlugin.NUCLEAR_FURNACE_RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"alexscaves.container.nuclear_furnace_blasting");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, AbstractCookingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 62, 38).addIngredients(Ingredient.m_204132_(ACTagRegistry.NUCLEAR_FURNACE_RODS));
        builder.addSlot(RecipeIngredientRole.INPUT, 32, 38).addIngredients(Ingredient.m_204132_(ACTagRegistry.NUCLEAR_FURNACE_BARRELS));
        builder.addSlot(RecipeIngredientRole.INPUT, 62, 2).addIngredients((Ingredient)recipe.m_7527_().get(0));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 32, 2).addItemStack(new ItemStack((ItemLike)ACBlockRegistry.WASTE_DRUM.get()));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 122, 20).addItemStack(NuclearFurnaceRecipeCategory.getResultItem(recipe));
    }

    public void draw(AbstractCookingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.drawExperience(recipe, guiGraphics, 0);
        this.drawCookTime(recipe, guiGraphics, 50);
    }

    protected void drawExperience(AbstractCookingRecipe recipe, GuiGraphics guiGraphics, int y) {
        float experience = recipe.m_43750_();
        if (experience > 0.0f) {
            MutableComponent experienceString = Component.m_237110_((String)"gui.jei.category.smelting.experience", (Object[])new Object[]{Float.valueOf(experience)});
            Minecraft minecraft = Minecraft.m_91087_();
            Font fontRenderer = minecraft.f_91062_;
            int stringWidth = fontRenderer.m_92852_((FormattedText)experienceString);
            guiGraphics.m_280614_(fontRenderer, (Component)experienceString, this.getWidth() - stringWidth, y, -8355712, false);
        }
    }

    protected void drawCookTime(AbstractCookingRecipe recipe, GuiGraphics guiGraphics, int y) {
        int cookTime = (int)Math.ceil((float)recipe.m_43753_() * 0.2f);
        if (cookTime > 0) {
            int cookTimeSeconds = cookTime / 20;
            MutableComponent timeString = Component.m_237110_((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds});
            Minecraft minecraft = Minecraft.m_91087_();
            Font fontRenderer = minecraft.f_91062_;
            int stringWidth = fontRenderer.m_92852_((FormattedText)timeString);
            guiGraphics.m_280614_(fontRenderer, (Component)timeString, this.getWidth() - stringWidth, y, -8355712, false);
        }
    }

    public boolean isHandled(AbstractCookingRecipe recipe) {
        return true;
    }

    public static ItemStack getResultItem(Recipe<?> recipe) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        if (level == null) {
            throw new NullPointerException("level must not be null.");
        }
        RegistryAccess registryAccess = level.m_9598_();
        return recipe.m_8043_(registryAccess);
    }
}

