/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.entity;

import com.github.alexmodguy.alexscaves.client.model.DeepOneMageModel;
import com.github.alexmodguy.alexscaves.client.render.ACRenderTypes;
import com.github.alexmodguy.alexscaves.client.render.entity.CustomBookEntityRenderer;
import com.github.alexmodguy.alexscaves.server.entity.living.DeepOneMageEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class DeepOneMageRenderer
extends MobRenderer<DeepOneMageEntity, DeepOneMageModel>
implements CustomBookEntityRenderer {
    private static final ResourceLocation TEXTURE = new ResourceLocation("alexscaves:textures/entity/deep_one/deep_one_mage.png");
    private static final ResourceLocation TEXTURE_GLOW = new ResourceLocation("alexscaves:textures/entity/deep_one/deep_one_mage_glow.png");
    private boolean sepia;

    public DeepOneMageRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new DeepOneMageModel(), 0.45f);
        this.m_115326_(new LayerGlow());
        this.m_115326_((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, renderManagerIn.m_234598_()));
    }

    protected void scale(DeepOneMageEntity mob, PoseStack matrixStackIn, float partialTicks) {
        if (mob.isSummoned()) {
            matrixStackIn.m_252880_(0.0f, (mob.m_20206_() + 1.0f) * (1.0f - mob.getSummonProgress(partialTicks)), 0.0f);
        }
    }

    public ResourceLocation getTextureLocation(DeepOneMageEntity entity) {
        return TEXTURE_GLOW;
    }

    @Nullable
    protected RenderType getRenderType(DeepOneMageEntity deepOneMageEntity, boolean normal, boolean translucent, boolean outline) {
        ResourceLocation resourcelocation = this.getTextureLocation(deepOneMageEntity);
        if (translucent) {
            return RenderType.m_110467_((ResourceLocation)resourcelocation);
        }
        if (normal) {
            return this.sepia ? ACRenderTypes.getBookWidget(resourcelocation, true) : ACRenderTypes.getTeslaBulb(resourcelocation);
        }
        return outline ? RenderType.m_110491_((ResourceLocation)resourcelocation) : null;
    }

    @Override
    public void setSepiaFlag(boolean sepiaFlag) {
        this.sepia = sepiaFlag;
    }

    class LayerGlow
    extends RenderLayer<DeepOneMageEntity, DeepOneMageModel> {
        public LayerGlow() {
            super((RenderLayerParent)DeepOneMageRenderer.this);
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, DeepOneMageEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (!entitylivingbaseIn.m_20145_()) {
                VertexConsumer ivertexbuilder = bufferIn.m_6299_(DeepOneMageRenderer.this.sepia ? ACRenderTypes.getBookWidget(TEXTURE, true) : ACRenderTypes.getGhostly(TEXTURE));
                float alpha = 1.0f;
                ((DeepOneMageModel)this.m_117386_()).m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)entitylivingbaseIn, (float)0.0f), 1.0f, 1.0f, 1.0f, alpha);
            }
        }
    }
}

