/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.particle;

import com.github.alexmodguy.alexscaves.client.particle.AbstractTrailParticle;
import com.github.alexmodguy.alexscaves.server.potion.ACEffectRegistry;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class StunStarParticle
extends AbstractTrailParticle {
    private static final ResourceLocation CENTER_TEXTURE = new ResourceLocation("alexscaves", "textures/particle/stun_star.png");
    private static final ResourceLocation TRAIL_TEXTURE = new ResourceLocation("alexscaves", "textures/particle/teletor_trail.png");
    private final int entityId;
    private final float offset;
    private boolean reverseOrbit;

    protected StunStarParticle(ClientLevel world, double x, double y, double z, int entityId, float offset) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.0;
        this.offset = offset;
        this.f_107217_ = 0.0;
        this.f_107230_ = 1.0f;
        this.entityId = entityId;
        this.f_107219_ = false;
        this.reverseOrbit = this.f_107223_.m_188499_();
        this.f_107225_ = 30 + this.f_107223_.m_188503_(5);
        Vec3 vec3 = this.getOrbitPos();
        this.m_107264_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
        this.f_107209_ = x;
        this.f_107210_ = y;
        this.f_107211_ = z;
    }

    public int m_6355_(float partialTicks) {
        return 240;
    }

    @Override
    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float partialTick) {
        Quaternionf quaternion;
        if (this.f_107224_ < 2) {
            return;
        }
        Vec3 vec3 = camera.m_90583_();
        float f = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float f1 = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
        float f2 = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        if (this.f_107231_ == 0.0f) {
            quaternion = camera.m_253121_();
        } else {
            quaternion = new Quaternionf((Quaternionfc)camera.m_253121_());
            float f3 = Mth.m_14179_((float)partialTick, (float)this.f_107204_, (float)this.f_107231_);
            quaternion.mul((Quaternionfc)Axis.f_252403_.m_252961_(f3));
        }
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)CENTER_TEXTURE);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
        Vector3f vector3f1 = new Vector3f(-1.0f, -1.0f, 0.0f);
        vector3f1.rotate((Quaternionfc)quaternion);
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f4 = 0.3f;
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.rotate((Quaternionfc)quaternion);
            vector3f.mul(f4);
            vector3f.add(f, f1, f2);
        }
        float f7 = 0.0f;
        float f8 = 1.0f;
        float f5 = 0.0f;
        float f6 = 1.0f;
        float alpha = 1.0f;
        int j = 240;
        bufferbuilder.m_5483_((double)avector3f[0].x(), (double)avector3f[0].y(), (double)avector3f[0].z()).m_7421_(f8, f6).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, alpha).m_85969_(j).m_5752_();
        bufferbuilder.m_5483_((double)avector3f[1].x(), (double)avector3f[1].y(), (double)avector3f[1].z()).m_7421_(f8, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, alpha).m_85969_(j).m_5752_();
        bufferbuilder.m_5483_((double)avector3f[2].x(), (double)avector3f[2].y(), (double)avector3f[2].z()).m_7421_(f7, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, alpha).m_85969_(j).m_5752_();
        bufferbuilder.m_5483_((double)avector3f[3].x(), (double)avector3f[3].y(), (double)avector3f[3].z()).m_7421_(f7, f6).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, alpha).m_85969_(j).m_5752_();
        tesselator.m_85914_();
        super.m_5744_(vertexConsumer, camera, partialTick);
    }

    @Override
    public void m_5989_() {
        this.f_107215_ *= 0.9;
        this.f_107216_ *= 0.9;
        this.f_107217_ *= 0.9;
        this.f_107204_ = this.f_107231_;
        this.f_107231_ = (float)(3.1415927410125732 * Math.sin((float)this.f_107224_ * 0.6f) * (double)0.3f);
        super.m_5989_();
        this.trailA = 0.2f * Mth.m_14036_((float)((float)this.f_107224_ / (float)this.f_107225_ * 32.0f), (float)0.0f, (float)1.0f);
        if (this.entityId != -1) {
            LivingEntity living;
            Vec3 orbit = this.getOrbitPos();
            this.m_107264_(orbit.f_82479_, orbit.f_82480_, orbit.f_82481_);
            Entity entity = this.f_107208_.m_6815_(this.entityId);
            if (entity instanceof LivingEntity && !(living = (LivingEntity)entity).m_21023_((MobEffect)ACEffectRegistry.STUNNED.get())) {
                this.m_107274_();
            }
        }
    }

    public Vec3 getOrbitPos() {
        Entity entity = this.f_107208_.m_6815_(this.entityId);
        if (entity != null) {
            float angle = (float)(this.f_107224_ * 10) + this.offset;
            Vec3 eyes = entity.m_146892_().m_82549_(entity.m_20252_(0.0f).m_82490_((double)(entity.m_20205_() * 0.85f))).m_82520_(0.0, 0.5 + 0.12 * (double)entity.m_20206_(), 0.0);
            Vec3 orbitOffset = new Vec3(0.0, 0.0, (double)(entity.m_20205_() * 0.5f + 0.2f)).m_82524_(angle * (float)(this.reverseOrbit ? -1 : 1) * ((float)Math.PI / 180));
            return eyes.m_82549_(orbitOffset);
        }
        return Vec3.f_82478_;
    }

    @Override
    public float getTrailHeight() {
        return 0.4f;
    }

    @Override
    public ResourceLocation getTrailTexture() {
        return TRAIL_TEXTURE;
    }

    @Override
    public int sampleCount() {
        return Math.min(10, this.f_107225_ - this.f_107224_);
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            StunStarParticle particle = new StunStarParticle(worldIn, x, y, z, (int)xSpeed, (float)ySpeed);
            particle.trailR = 1.0f;
            particle.trailG = 1.0f;
            particle.trailB = 1.0f;
            return particle;
        }
    }
}

