/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.particle;

import com.github.alexmodguy.alexscaves.client.particle.MagneticOrbitParticle;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ProtonParticle
extends MagneticOrbitParticle {
    private static final ResourceLocation CENTER_TEXTURE = new ResourceLocation("alexscaves", "textures/particle/proton_core.png");
    private static final ResourceLocation PROTON_TRAIL_TEXTURE = new ResourceLocation("alexscaves", "textures/particle/teletor_trail.png");

    protected ProtonParticle(ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        super(world, x, y, z, xSpeed, ySpeed, zSpeed);
        this.orbitAxis = this.f_107223_.m_188503_(3);
        this.f_107215_ = 0.0;
        this.f_107216_ = 0.0;
        this.f_107217_ = 0.0;
        this.orbitOffset = new Vec3(0.0, 0.0, 0.0);
        this.orbitDistance = 1.0;
        this.orbitSpeed = 4.0f;
        this.f_107230_ = 1.0f;
        this.f_107219_ = false;
        this.f_107225_ = 30 + this.f_107223_.m_188503_(20);
    }

    @Override
    public int m_6355_(float partialTicks) {
        return 240;
    }

    @Override
    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float partialTick) {
        Quaternionf quaternion;
        super.m_5744_(vertexConsumer, camera, partialTick);
        Vec3 vec3 = camera.m_90583_();
        float f = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float f1 = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
        float f2 = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        if (this.f_107231_ == 0.0f) {
            quaternion = camera.m_253121_();
        } else {
            quaternion = new Quaternionf((Quaternionfc)camera.m_253121_());
            float f3 = Mth.m_14179_((float)partialTick, (float)this.f_107204_, (float)this.f_107231_);
            quaternion.mul((Quaternionfc)Axis.f_252403_.m_252961_(f3));
        }
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)CENTER_TEXTURE);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85813_);
        Vector3f vector3f1 = new Vector3f(-1.0f, -1.0f, 0.0f);
        vector3f1.rotate((Quaternionfc)quaternion);
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f4 = 0.3f;
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.rotate((Quaternionfc)quaternion);
            vector3f.mul(f4);
            vector3f.add(f, f1, f2);
        }
        float f7 = 0.0f;
        float f8 = 1.0f;
        float f5 = 0.0f;
        float f6 = 1.0f;
        float alpha = Mth.m_14036_((float)(1.0f - (float)this.f_107224_ / (float)this.f_107225_), (float)0.0f, (float)1.0f);
        int j = 240;
        bufferbuilder.m_5483_((double)avector3f[0].x(), (double)avector3f[0].y(), (double)avector3f[0].z()).m_7421_(f8, f6).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, alpha).m_85969_(j).m_5752_();
        bufferbuilder.m_5483_((double)avector3f[1].x(), (double)avector3f[1].y(), (double)avector3f[1].z()).m_7421_(f8, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, alpha).m_85969_(j).m_5752_();
        bufferbuilder.m_5483_((double)avector3f[2].x(), (double)avector3f[2].y(), (double)avector3f[2].z()).m_7421_(f7, f5).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, alpha).m_85969_(j).m_5752_();
        bufferbuilder.m_5483_((double)avector3f[3].x(), (double)avector3f[3].y(), (double)avector3f[3].z()).m_7421_(f7, f6).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, alpha).m_85969_(j).m_5752_();
        tesselator.m_85914_();
    }

    @Override
    public void m_5989_() {
        this.f_107215_ *= 0.9;
        this.f_107216_ *= 0.9;
        this.f_107217_ *= 0.9;
        super.m_5989_();
        float fadeIn = 0.8f * Mth.m_14036_((float)((float)this.f_107224_ / (float)this.f_107225_ * 32.0f), (float)0.0f, (float)1.0f);
        float fadeOut = Mth.m_14036_((float)(1.0f - (float)this.f_107224_ / (float)this.f_107225_), (float)0.0f, (float)1.0f);
        this.trailA = fadeIn * fadeOut;
    }

    @Override
    public Vec3 getOrbitPosition(float angle) {
        Vec3 center = new Vec3(this.orbitX, this.orbitY, this.orbitZ);
        float f = this.reverseOrbit ? -1.0f : 1.0f;
        Vec3 add = Vec3.f_82478_;
        float rot = angle * 3.0f * this.orbitSpeed * ((float)Math.PI / 180);
        switch (this.orbitAxis) {
            case 0: {
                add = new Vec3(0.0, this.orbitDistance * 0.5, this.orbitDistance * 0.5).m_82496_(rot * f);
                break;
            }
            case 1: {
                add = new Vec3(this.orbitDistance * 0.5, 0.0, this.orbitDistance * 0.5).m_82524_(rot * f);
                break;
            }
            case 2: {
                add = new Vec3(this.orbitDistance * 0.5, this.orbitDistance * 0.5, 0.0).m_82535_(rot * f);
            }
        }
        return center.m_82549_(add);
    }

    @Override
    public float getTrailHeight() {
        return 0.2f;
    }

    @Override
    public ResourceLocation getTrailTexture() {
        return PROTON_TRAIL_TEXTURE;
    }

    @Override
    public int sampleCount() {
        return Math.min(10, this.f_107225_ - this.f_107224_);
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ProtonParticle particle = new ProtonParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed);
            particle.trailR = 0.0f;
            particle.trailG = 1.0f;
            particle.trailB = 0.0f;
            return particle;
        }
    }
}

