/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.model.layered;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;

public class HazmatArmorModel
extends HumanoidModel {
    public ModelPart mask;
    public ModelPart breather1;
    public ModelPart breather2;

    public HazmatArmorModel(ModelPart root) {
        super(root);
        this.mask = root.m_171324_("head").m_171324_("mask");
        this.breather1 = this.mask.m_171324_("breather1");
        this.breather2 = this.mask.m_171324_("breather2");
    }

    public static LayerDefinition createArmorLayer(CubeDeformation deformation) {
        MeshDefinition meshdefinition = HumanoidModel.m_170681_((CubeDeformation)deformation, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition head = partdefinition.m_171597_("head");
        PartDefinition body = partdefinition.m_171597_("body");
        PartDefinition leftLeg = partdefinition.m_171597_("left_leg");
        PartDefinition rightLeg = partdefinition.m_171597_("right_leg");
        PartDefinition leftArm = partdefinition.m_171597_("left_arm");
        PartDefinition rightArm = partdefinition.m_171597_("right_arm");
        CubeDeformation deformationHelmet = deformation.m_171469_(-0.1f);
        CubeDeformation deformationShoulder = deformation.m_171469_(0.1f);
        CubeDeformation deformationMain = deformation.m_171469_(0.25f);
        CubeDeformation deformationPants = deformation.m_171469_(0.1f);
        PartDefinition mask = head.m_171599_("mask", CubeListBuilder.m_171558_().m_171514_(116, 100).m_171488_(-2.0f, -1.5f, -2.0f, 4.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-1.5f, (float)-4.0f));
        mask.m_171599_("breather1", CubeListBuilder.m_171558_().m_171514_(78, 99).m_171480_().m_171488_(-1.5f, -1.0f, -4.0f, 3.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)2.5f, (float)1.0f, (float)1.0f, (float)0.3927f, (float)-0.7854f, (float)0.0f));
        mask.m_171599_("breather2", CubeListBuilder.m_171558_().m_171514_(78, 99).m_171488_(-1.5f, -1.0f, -4.0f, 3.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.5f, (float)1.0f, (float)1.0f, (float)0.3927f, (float)0.7854f, (float)0.0f));
        body.m_171599_("jacket", CubeListBuilder.m_171558_().m_171514_(16, 32).m_171488_(-4.0f, -24.0f, -2.0f, 8.0f, 12.0f, 4.0f, deformationMain), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        rightArm.m_171599_("right_sleeve", CubeListBuilder.m_171558_().m_171514_(40, 32).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, deformationMain), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        rightArm.m_171599_("right_shoulder_guard", CubeListBuilder.m_171558_().m_171514_(42, 116).m_171480_().m_171488_(-4.0f, -4.0f, -3.0f, 5.0f, 6.0f, 6.0f, deformationShoulder).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        leftArm.m_171599_("left_sleeve", CubeListBuilder.m_171558_().m_171514_(48, 49).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, deformationMain), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        leftArm.m_171599_("left_shoulder_guard", CubeListBuilder.m_171558_().m_171514_(42, 116).m_171488_(-1.0f, -4.0f, -3.0f, 5.0f, 6.0f, 6.0f, deformationShoulder), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        rightLeg.m_171599_("right_pants", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, deformationPants), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        leftLeg.m_171599_("left_pants", CubeListBuilder.m_171558_().m_171514_(0, 48).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, deformationPants), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public HazmatArmorModel withAnimations(LivingEntity entity) {
        float partialTick = Minecraft.m_91087_().m_91296_();
        float f = (float)entity.f_19797_ + partialTick;
        float fromRads = (float)Mth.m_14175_((double)Math.toDegrees(this.f_102808_.f_104204_ - this.f_102810_.f_104204_));
        this.mask.f_104204_ = (float)(-Math.toRadians(fromRads) * (double)0.3f);
        float breathScale1 = (float)(Math.sin(f * 0.05f) + 1.0) * 0.1f + 1.0f;
        float breathScale2 = (float)(Math.cos(f * 0.05f) + 1.0) * 0.25f + 0.75f;
        if (entity instanceof ArmorStand) {
            breathScale1 = 1.0f;
            breathScale2 = 1.0f;
        }
        this.breather1.f_233553_ = breathScale1;
        this.breather1.f_233554_ = breathScale1;
        this.breather1.f_233555_ = breathScale2;
        this.breather2.f_233553_ = breathScale1;
        this.breather2.f_233554_ = breathScale1;
        this.breather2.f_233555_ = breathScale2;
        return this;
    }
}

