/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.notenoughanimations.renderlayer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.tr7zw.notenoughanimations.NEAnimationsLoader;
import dev.tr7zw.notenoughanimations.access.PlayerData;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class SwordRenderLayer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private boolean lazyInit = true;
    private static Set<Item> items = new HashSet<Item>();
    private boolean disabled = false;

    public SwordRenderLayer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> renderLayerParent) {
        super(renderLayerParent);
    }

    public static void update(Player player) {
        PlayerData data = (PlayerData)player;
        if (items.contains(player.m_21205_().m_41720_())) {
            data.setSideSword(player.m_21205_());
        }
        if (items.contains(player.m_21206_().m_41720_())) {
            data.setSideSword(player.m_21206_());
        }
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int light, AbstractClientPlayer player, float paramFloat1, float paramFloat2, float paramFloat3, float paramFloat4, float paramFloat5, float paramFloat6) {
        boolean wearingArmor;
        if (this.disabled) {
            return;
        }
        if (this.lazyInit) {
            this.lazyInit = false;
            this.init();
        }
        if (!NEAnimationsLoader.config.showLastUsedSword) {
            return;
        }
        if (player.m_20145_() || player.m_5803_()) {
            return;
        }
        if (!(player instanceof PlayerData)) {
            return;
        }
        if (player.m_20159_()) {
            return;
        }
        PlayerData data = (PlayerData)player;
        ItemStack itemStack = data.getSideSword();
        if (itemStack.m_41619_()) {
            return;
        }
        if (player.m_21205_() == itemStack || player.m_21206_() == itemStack) {
            return;
        }
        poseStack.m_85836_();
        ((PlayerModel)this.m_117386_()).f_102810_.m_104299_(poseStack);
        boolean lefthanded = player.m_5737_() == HumanoidArm.LEFT;
        boolean bl = wearingArmor = !player.m_6844_(EquipmentSlot.LEGS).m_41619_();
        if (!player.m_6844_(EquipmentSlot.CHEST).m_41619_() && player.m_6844_(EquipmentSlot.CHEST).m_41720_() != Items.f_42741_) {
            wearingArmor = true;
        }
        double offsetX = wearingArmor ? 0.3 : 0.28;
        float swordRotation = -80.0f;
        if (lefthanded) {
            offsetX *= -1.0;
        }
        poseStack.m_85837_(offsetX, 0.85, 0.25);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(swordRotation));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        Minecraft.m_91087_().m_91290_().m_234586_().m_269530_((LivingEntity)player, itemStack, lefthanded ? ItemDisplayContext.THIRD_PERSON_RIGHT_HAND : ItemDisplayContext.THIRD_PERSON_LEFT_HAND, lefthanded, poseStack, multiBufferSource, light);
        poseStack.m_85849_();
    }

    private void init() {
        for (String itemKey : NEAnimationsLoader.config.sheathSwords) {
            Item item;
            if (!itemKey.contains(":") || (item = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(itemKey.split(":")[0], itemKey.split(":")[1]))) == Items.f_41852_) continue;
            items.add(item);
        }
        try {
            Class.forName("net.backslot.BackSlotMain");
            this.disabled = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

