/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.mixin;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.orcinus.galosphere.api.BannerAttachable;
import net.orcinus.galosphere.api.GoldenBreath;
import net.orcinus.galosphere.api.SpectreBoundSpyglass;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin
implements BannerAttachable,
GoldenBreath,
SpectreBoundSpyglass {
    private static final EntityDataAccessor<ItemStack> BANNER_STACK = SynchedEntityData.m_135353_(LivingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Float> GOLDEN_AIR_SUPPLY = SynchedEntityData.m_135353_(LivingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> USING_SPECTRE_BOUNDED_SPYGLASS = SynchedEntityData.m_135353_(LivingEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    @Inject(at={@At(value="HEAD")}, method={"defineSynchedData"})
    public void G$defineSynchedData(CallbackInfo ci) {
        SynchedEntityData data = ((LivingEntity)this).m_20088_();
        data.m_135372_(BANNER_STACK, (Object)ItemStack.f_41583_);
        data.m_135372_(GOLDEN_AIR_SUPPLY, (Object)Float.valueOf(0.0f));
        data.m_135372_(USING_SPECTRE_BOUNDED_SPYGLASS, (Object)false);
    }

    @Inject(at={@At(value="RETURN")}, method={"addAdditionalSaveData"})
    public void G$addAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        tag.m_128365_("BannerStack", (Tag)((ItemStack)((LivingEntity)this).m_20088_().m_135370_(BANNER_STACK)).m_41739_(new CompoundTag()));
        tag.m_128350_("GoldenAirSupply", this.getGoldenAirSupply());
        tag.m_128379_("UsingSpectreBoundedSpyglass", this.isUsingSpectreBoundedSpyglass());
    }

    @Inject(at={@At(value="RETURN")}, method={"readAdditionalSaveData"})
    public void G$readAdditionalSavaData(CompoundTag tag, CallbackInfo ci) {
        this.setBanner(ItemStack.m_41712_((CompoundTag)tag.m_128469_("BannerStack")));
        this.setGoldenAirSupply(tag.m_128457_("GoldenAirSupply"));
        this.setUsingSpectreBoundedSpyglass(tag.m_128471_("UsingSpectreBoundedSpyglass"));
    }

    @Inject(at={@At(value="HEAD")}, method={"decreaseAirSupply"}, cancellable=true)
    private void G$decreaseAirSupply(int i, CallbackInfoReturnable<Integer> cir) {
        if (this.getGoldenAirSupply() > 0.0f) {
            cir.setReturnValue((Object)i);
        }
    }

    @Override
    public void setBanner(ItemStack stack) {
        ((LivingEntity)this).m_20088_().m_135381_(BANNER_STACK, (Object)stack);
    }

    @Override
    public ItemStack getBanner() {
        return (ItemStack)((LivingEntity)this).m_20088_().m_135370_(BANNER_STACK);
    }

    @Override
    public void setGoldenAirSupply(float goldenAirSupply) {
        ((LivingEntity)this).m_20088_().m_135381_(GOLDEN_AIR_SUPPLY, (Object)Float.valueOf(goldenAirSupply));
    }

    @Override
    public float getGoldenAirSupply() {
        return ((Float)((LivingEntity)this).m_20088_().m_135370_(GOLDEN_AIR_SUPPLY)).floatValue();
    }

    @Override
    public boolean isUsingSpectreBoundedSpyglass() {
        return (Boolean)((LivingEntity)this).m_20088_().m_135370_(USING_SPECTRE_BOUNDED_SPYGLASS);
    }

    @Override
    public void setUsingSpectreBoundedSpyglass(boolean usingSpectreBoundedSpyglass) {
        ((LivingEntity)this).m_20088_().m_135381_(USING_SPECTRE_BOUNDED_SPYGLASS, (Object)usingSpectreBoundedSpyglass);
    }
}

