/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.init;

import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.Musics;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.orcinus.galosphere.init.GSoundEvents;

public class GBiomes {
    public static final ResourceKey<Biome> CRYSTAL_CANYONS = GBiomes.register("crystal_canyons");
    public static final ResourceKey<Biome> LICHEN_CAVES = GBiomes.register("lichen_caves");

    public static void bootstrap(BootstapContext<Biome> bootstapContext) {
        HolderGetter holdergetter = bootstapContext.m_255420_(Registries.f_256988_);
        HolderGetter holdergetter1 = bootstapContext.m_255420_(Registries.f_257003_);
        bootstapContext.m_255272_(CRYSTAL_CANYONS, (Object)GBiomes.crystalCanyons((HolderGetter<PlacedFeature>)holdergetter, holdergetter1));
        bootstapContext.m_255272_(LICHEN_CAVES, (Object)GBiomes.lichenCaves((HolderGetter<PlacedFeature>)holdergetter, holdergetter1));
    }

    public static Biome lichenCaves(HolderGetter<PlacedFeature> holderGetter, HolderGetter<ConfiguredWorldCarver<?>> holderGetter1) {
        MobSpawnSettings.Builder mobBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)mobBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(holderGetter, holderGetter1);
        BiomeDefaultFeatures.m_194720_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_176857_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126806_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126810_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126765_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126771_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126728_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        Music music = Musics.m_263184_((Holder)((Holder)GSoundEvents.MUSIC_LICHEN_CAVES.getHolder().get()));
        return GBiomes.biome(0.5f, 0.5f, mobBuilder, biomeBuilder, music, 4159204);
    }

    public static Biome crystalCanyons(HolderGetter<PlacedFeature> holderGetter, HolderGetter<ConfiguredWorldCarver<?>> holderGetter1) {
        MobSpawnSettings.Builder mobBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)mobBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder(holderGetter, holderGetter1);
        BiomeDefaultFeatures.m_194720_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_176857_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126806_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126810_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126765_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126771_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126728_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        Music music = Musics.m_263184_((Holder)((Holder)GSoundEvents.MUSIC_CRYSTAL_CANYONS.getHolder().get()));
        return GBiomes.biome(0.5f, 0.5f, mobBuilder, biomeBuilder, music, 4445678);
    }

    private static Biome biome(float temperature, float downFall, MobSpawnSettings.Builder mobBuilder, BiomeGenerationSettings.Builder generationBuilder, @Nullable Music music, int waterColor) {
        return GBiomes.biome(temperature, downFall, waterColor, 329011, mobBuilder, generationBuilder, music);
    }

    private static Biome biome(float temperature, float downFall, int waterColor, int p_194857_, MobSpawnSettings.Builder mobBuilder, BiomeGenerationSettings.Builder generationBuilder, @Nullable Music music) {
        return new Biome.BiomeBuilder().m_264558_(true).m_47609_(temperature).m_47611_(downFall).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(waterColor).m_48037_(p_194857_).m_48019_(12638463).m_48040_(GBiomes.calculateSkyColor(temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(music).m_48018_()).m_47605_(mobBuilder.m_48381_()).m_47601_(generationBuilder.m_255380_()).m_47592_();
    }

    protected static int calculateSkyColor(float temperature) {
        float value = temperature / 3.0f;
        value = Mth.m_14036_((float)value, (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - value * 0.05f), (float)(0.5f + value * 0.1f), (float)1.0f);
    }

    private static ResourceKey<Biome> register(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("galosphere", name));
    }
}

