/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.init;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;
import net.orcinus.galosphere.init.GBiomes;
import net.orcinus.galosphere.init.GEntityTypes;
import net.orcinus.galosphere.init.GPlacedFeatures;
import org.jetbrains.annotations.NotNull;

public class GBiomeModifiers {
    public static final ResourceKey<BiomeModifier> ADD_CRYSTAL_CANYONS_FEATURES = GBiomeModifiers.register("add_crystal_canyons_features");
    public static final ResourceKey<BiomeModifier> ADD_CRYSTAL_CANYONS_SPAWNS = GBiomeModifiers.register("add_crystal_canyons_spawns");
    public static final ResourceKey<BiomeModifier> ADD_LICHEN_CAVES_FEATURES = GBiomeModifiers.register("add_lichen_caves_spawns");
    public static final ResourceKey<BiomeModifier> ADD_LICHEN_CAVES_SPAWNS = GBiomeModifiers.register("add_lichen_caves_features");
    public static final ResourceKey<BiomeModifier> ADD_SILVER_ORES = GBiomeModifiers.register("add_silver_ores");
    public static final ResourceKey<BiomeModifier> ADD_LARGE_SILVER_ORES = GBiomeModifiers.register("add_large_silver_ores");

    public static void bootstrap(BootstapContext<BiomeModifier> bootstapContext) {
        bootstapContext.m_255272_(ADD_CRYSTAL_CANYONS_FEATURES, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(GBiomeModifiers.getBiome(bootstapContext, GBiomes.CRYSTAL_CANYONS), GBiomeModifiers.getPlacedFeature(bootstapContext, GPlacedFeatures.ALLURITE_CEILING_CRYSTALS, GPlacedFeatures.ALLURITE_FLOOR_CRYSTALS, GPlacedFeatures.LARGE_CEILING_ALLURITE_CRYSTALS, GPlacedFeatures.LARGE_FLOOR_ALLURITE_CRYSTALS, GPlacedFeatures.LUMIERE_FLOOR_CRYSTALS, GPlacedFeatures.LUMIERE_CEILING_CRYSTALS, GPlacedFeatures.LARGE_CEILING_LUMIERE_CRYSTALS, GPlacedFeatures.LARGE_FLOOR_LUMIERE_CRYSTALS), GenerationStep.Decoration.VEGETAL_DECORATION));
        bootstapContext.m_255272_(ADD_CRYSTAL_CANYONS_SPAWNS, (Object)new ForgeBiomeModifiers.AddSpawnsBiomeModifier(GBiomeModifiers.getBiome(bootstapContext, GBiomes.CRYSTAL_CANYONS), List.of(new MobSpawnSettings.SpawnerData((EntityType)GEntityTypes.SPARKLE.get(), 30, 4, 6), new MobSpawnSettings.SpawnerData(EntityType.f_147034_, 10, 4, 6))));
        bootstapContext.m_255272_(ADD_LICHEN_CAVES_FEATURES, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(GBiomeModifiers.getBiome(bootstapContext, GBiomes.LICHEN_CAVES), GBiomeModifiers.getPlacedFeature(bootstapContext, GPlacedFeatures.BOWL_LICHEN, GPlacedFeatures.LICHEN_VEGETATION, GPlacedFeatures.LICHEN_CORDYCEPS_COLUMN, GPlacedFeatures.GRAVEL_PATCH), GenerationStep.Decoration.VEGETAL_DECORATION));
        bootstapContext.m_255272_(ADD_LICHEN_CAVES_SPAWNS, (Object)new ForgeBiomeModifiers.AddSpawnsBiomeModifier(GBiomeModifiers.getBiome(bootstapContext, GBiomes.LICHEN_CAVES), List.of(new MobSpawnSettings.SpawnerData((EntityType)GEntityTypes.SPECTRE.get(), 20, 8, 8))));
        bootstapContext.m_255272_(ADD_SILVER_ORES, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(GBiomeModifiers.getBiome(bootstapContext, (TagKey<Biome>)BiomeTags.f_215817_), GBiomeModifiers.getPlacedFeature(bootstapContext, GPlacedFeatures.ORE_SILVER_SMALL), GenerationStep.Decoration.UNDERGROUND_ORES));
        bootstapContext.m_255272_(ADD_LARGE_SILVER_ORES, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(GBiomeModifiers.getBiome(bootstapContext, GBiomes.CRYSTAL_CANYONS), GBiomeModifiers.getPlacedFeature(bootstapContext, GPlacedFeatures.ORE_SILVER_LARGE), GenerationStep.Decoration.UNDERGROUND_ORES));
    }

    @NotNull
    private static HolderSet.Direct<Biome> getBiome(BootstapContext<BiomeModifier> bootstapContext, ResourceKey<Biome> biome) {
        return HolderSet.m_205809_((Holder[])new Holder[]{bootstapContext.m_255420_(Registries.f_256952_).m_255043_(biome)});
    }

    private static HolderSet.Named<Biome> getBiome(BootstapContext<BiomeModifier> bootstapContext, TagKey<Biome> biome) {
        return bootstapContext.m_255420_(Registries.f_256952_).m_254956_(biome);
    }

    @SafeVarargs
    @NotNull
    private static HolderSet.Direct<PlacedFeature> getPlacedFeature(BootstapContext<BiomeModifier> context, ResourceKey<PlacedFeature> ... placedFeature) {
        return HolderSet.m_205800_(Stream.of(placedFeature).map(resourceKey -> context.m_255420_(Registries.f_256988_).m_255043_(resourceKey)).collect(Collectors.toList()));
    }

    @NotNull
    private static HolderSet.Direct<PlacedFeature> getPlacedFeature(BootstapContext<BiomeModifier> context, ResourceKey<PlacedFeature> placedFeature) {
        return HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256988_).m_255043_(placedFeature)});
    }

    @NotNull
    private static ResourceKey<BiomeModifier> register(String name) {
        return ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)new ResourceLocation("galosphere", name));
    }
}

