/*
 * Decompiled with CFR 0.152.
 */
package net.orcinus.galosphere.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidType;
import net.orcinus.galosphere.api.GoldenBreath;

@OnlyIn(value=Dist.CLIENT)
public class GoldenBreathOverlay {
    private static final ResourceLocation GALOSPHERE_ICONS = new ResourceLocation("galosphere", "textures/gui/galosphere_icons.png");

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPostRender(RenderGuiOverlayEvent.Post event) {
        if (event.isCanceled()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        GuiGraphics guiGraphics = event.getGuiGraphics();
        if (player == null) {
            return;
        }
        if (event.getOverlay().id().equals((Object)VanillaGuiOverlay.PLAYER_HEALTH.id()) && !Minecraft.m_91087_().f_91066_.f_92062_ && Minecraft.m_91087_().f_91072_.m_105205_() && Minecraft.m_91087_().m_91288_() instanceof Player) {
            RenderSystem.enableBlend();
            this.renderGoldenAirSupply(guiGraphics, (Player)mc.f_91074_, mc.m_91268_().m_85445_(), mc.m_91268_().m_85446_());
            RenderSystem.disableBlend();
        }
    }

    private void renderGoldenAirSupply(GuiGraphics guiGraphics, Player player, int width, int height) {
        if (player == null) {
            return;
        }
        int n = width / 2 + 91;
        int o = height - 39;
        int t = o - 20;
        float y = ((GoldenBreath)player).getMaxGoldenAirSupply();
        float z = Math.min(((GoldenBreath)player).getGoldenAirSupply(), y);
        if (z < y && player.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get())) {
            int ab = Mth.m_14165_((double)((double)(z - 2.0f) * 4.0 / (double)y));
            int ac = Mth.m_14165_((double)((double)z * 4.0 / (double)y)) - ab;
            for (int ad = 0; ad < ab + ac; ++ad) {
                if (ad < ab) {
                    guiGraphics.m_280218_(GALOSPHERE_ICONS, n - ad * 8 - 9, t, 16, 18, 9, 9);
                    continue;
                }
                guiGraphics.m_280218_(GALOSPHERE_ICONS, n - ad * 8 - 9, t, 25, 18, 9, 9);
            }
        }
    }
}

