/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.world.item.forge;

import com.talhanation.smallships.world.item.BriggItem;
import com.talhanation.smallships.world.item.CannonBallItem;
import com.talhanation.smallships.world.item.CannonItem;
import com.talhanation.smallships.world.item.CogItem;
import com.talhanation.smallships.world.item.GalleyItem;
import com.talhanation.smallships.world.item.ModItems;
import com.talhanation.smallships.world.item.SailItem;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModItemsImpl {
    private static final Map<String, RegistryObject<Item>> entries = new HashMap<String, RegistryObject<Item>>();
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"smallships");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"smallships");
    public static final RegistryObject<CreativeModeTab> customCreativeModeTab = CREATIVE_MODE_TABS.register(new ResourceLocation("smallships", "creative_mode_tab").toString().replace(":", "."), () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)new ResourceLocation("smallships", "creative_mode_tab").toString().replace(":", "."))).m_257737_(() -> new ItemStack((ItemLike)ModItems.CANNON)).m_257652_());

    public static Item getItem(String id) {
        return (Item)entries.get(id).get();
    }

    private static void register(String id, Supplier<Item> itemSupplier) {
        entries.put(id, (RegistryObject<Item>)ITEMS.register(id, itemSupplier));
    }

    static {
        ModItemsImpl.register("sail", () -> new SailItem(new Item.Properties().m_41487_(16)));
        ModItemsImpl.register("cannon", () -> new CannonItem(new Item.Properties().m_41487_(1)));
        ModItemsImpl.register("cannon_ball", () -> new CannonBallItem(new Item.Properties().m_41487_(16)));
        for (Boat.Type type : Boat.Type.values()) {
            ModItemsImpl.register(new ResourceLocation(type.m_38429_()).m_135815_() + "_cog", () -> new CogItem(type, new Item.Properties().m_41487_(1)));
            ModItemsImpl.register(new ResourceLocation(type.m_38429_()).m_135815_() + "_brigg", () -> new BriggItem(type, new Item.Properties().m_41487_(1)));
            ModItemsImpl.register(new ResourceLocation(type.m_38429_()).m_135815_() + "_galley", () -> new GalleyItem(type, new Item.Properties().m_41487_(1)));
        }
    }
}

