/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.world.entity.ship;

import com.talhanation.smallships.config.SmallShipsConfig;
import com.talhanation.smallships.mixin.container.SimpleContainerAccessor;
import com.talhanation.smallships.world.entity.ship.Ship;
import com.talhanation.smallships.world.inventory.ContainerUtility;
import com.talhanation.smallships.world.inventory.ShipContainerMenu;
import java.util.Arrays;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ContainerShip
extends Ship
implements HasCustomInventoryScreen,
ContainerEntity {
    public static final EntityDataAccessor<Integer> CONTAINER_SIZE = SynchedEntityData.m_135353_(ContainerShip.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Byte> ROWS = SynchedEntityData.m_135353_(ContainerShip.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public static final EntityDataAccessor<Byte> PAGES = SynchedEntityData.m_135353_(ContainerShip.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public static final EntityDataAccessor<Byte> PAGE_INDEX = SynchedEntityData.m_135353_(ContainerShip.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public static final EntityDataAccessor<Byte> CONTAINER_FILL_STATE = SynchedEntityData.m_135353_(ContainerShip.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private final int originalContainerSize;
    NonNullList<ItemStack> itemStacks;
    @Nullable
    private ResourceLocation lootTable;
    private long lootTableSeed;
    public final ContainerData containerData = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> ContainerShip.this.getData(ROWS).byteValue();
                case 1 -> ContainerShip.this.getData(PAGES).byteValue();
                case 2 -> ContainerShip.this.getData(PAGE_INDEX).byteValue();
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    ContainerShip.this.setData(ROWS, (byte)value);
                    break;
                }
                case 1: {
                    ContainerShip.this.setData(PAGES, (byte)value);
                    break;
                }
                case 2: {
                    ContainerShip.this.setData(PAGE_INDEX, (byte)value);
                }
            }
        }

        public int m_6499_() {
            return 3;
        }
    };

    public ContainerShip(EntityType<? extends Boat> entityType, Level level, int containerSize) {
        super(entityType, level);
        this.originalContainerSize = containerSize;
        this.updatePaging(this.originalContainerSize);
        this.setData(CONTAINER_SIZE, this.originalContainerSize);
        this.itemStacks = NonNullList.m_122780_((int)this.originalContainerSize, (Object)ItemStack.f_41583_);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(CONTAINER_SIZE, (Object)this.originalContainerSize);
        this.m_20088_().m_135372_(ROWS, (Object)6);
        this.m_20088_().m_135372_(PAGES, (Object)1);
        this.m_20088_().m_135372_(PAGE_INDEX, (Object)0);
        this.m_20088_().m_135372_(CONTAINER_FILL_STATE, (Object)-128);
    }

    @Override
    protected void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.readContainerSizeSaveData(tag);
        this.m_219934_(tag);
        this.setContainerFillState(tag.m_128445_("ContainerFillState"));
    }

    @Override
    protected void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        this.addContainerSizeSaveData(tag);
        this.m_219943_(tag);
        tag.m_128344_("ContainerFillState", this.getContainerFillState());
    }

    public void m_213560_(@NotNull DamageSource damageSource) {
        super.m_213560_(damageSource);
        this.m_219927_(damageSource, this.m_9236_(), (Entity)this);
    }

    public void m_142687_(@NotNull Entity.RemovalReason removalReason) {
        if (!this.m_9236_().m_5776_() && removalReason.m_146965_()) {
            Containers.m_18998_((Level)this.m_9236_(), (Entity)this, (Container)this);
        }
        super.m_142687_(removalReason);
    }

    @Override
    @NotNull
    public InteractionResult m_6096_(@NotNull Player player, @NotNull InteractionHand interactionHand) {
        if (this.m_7310_((Entity)player) && !player.m_36341_()) {
            return super.m_6096_(player, interactionHand);
        }
        InteractionResult interactionResult = this.m_268996_(player);
        if (interactionResult.m_19077_()) {
            this.m_146852_(GameEvent.f_157803_, (Entity)player);
            PiglinAi.m_34873_((Player)player, (boolean)true);
        } else {
            this.m_20153_();
        }
        return interactionResult;
    }

    public void m_213583_(@NotNull Player player) {
        ContainerUtility.openShipMenu(player, this);
        if (!player.m_9236_().m_5776_()) {
            this.m_146852_(GameEvent.f_157803_, (Entity)player);
            PiglinAi.m_34873_((Player)player, (boolean)true);
        }
    }

    @Nullable
    public ResourceLocation m_214142_() {
        return this.lootTable;
    }

    public void m_214199_(@Nullable ResourceLocation resourceLocation) {
        this.lootTable = resourceLocation;
    }

    public long m_213803_() {
        return this.lootTableSeed;
    }

    public void m_214065_(long l) {
        this.lootTableSeed = l;
    }

    @NotNull
    public NonNullList<ItemStack> m_213659_() {
        return this.itemStacks;
    }

    public void m_213775_() {
        this.itemStacks.clear();
    }

    public int m_6643_() {
        return this.getData(CONTAINER_SIZE);
    }

    @NotNull
    public ItemStack m_8020_(int i) {
        return this.m_219947_(i);
    }

    @NotNull
    public ItemStack m_7407_(int i, int j) {
        return this.m_219936_(i, j);
    }

    @NotNull
    public ItemStack m_8016_(int i) {
        return this.m_219945_(i);
    }

    public void m_6836_(int i, @NotNull ItemStack itemStack) {
        this.m_219940_(i, itemStack);
        this.updateContainerFillState();
    }

    @NotNull
    public SlotAccess m_141942_(int n) {
        return this.m_219951_(n);
    }

    public void m_6596_() {
    }

    public boolean m_6542_(@NotNull Player player) {
        return this.m_219954_(player);
    }

    public void m_6211_() {
        this.m_219953_();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, @NotNull Inventory inventory, @NotNull Player player) {
        if (this.lootTable == null || !player.m_5833_()) {
            this.m_219949_(inventory.f_35978_);
            this.m_213583_(player);
        }
        return null;
    }

    public void m_219934_(@NotNull CompoundTag compoundTag) {
        this.m_213775_();
        if (compoundTag.m_128425_("LootTable", 8)) {
            this.m_214199_(new ResourceLocation(compoundTag.m_128461_("LootTable")));
            this.m_214065_(compoundTag.m_128454_("LootTableSeed"));
        } else {
            ContainerUtility.loadAllItems(compoundTag, this.m_213659_());
            this.resizeContainer(this.m_6643_());
        }
    }

    public void m_219943_(@NotNull CompoundTag compoundTag) {
        if (this.m_214142_() != null) {
            compoundTag.m_128359_("LootTable", this.m_214142_().toString());
            if (this.m_213803_() != 0L) {
                compoundTag.m_128356_("LootTableSeed", this.m_213803_());
            }
        } else {
            ContainerUtility.saveAllItems(compoundTag, this.m_213659_());
        }
    }

    public void readContainerSizeSaveData(CompoundTag tag) {
        int containerSize;
        if (!tag.m_128425_("ContainerSize", 3)) {
            tag.m_128405_("ContainerSize", this.originalContainerSize);
        }
        if ((containerSize = tag.m_128451_("ContainerSize")) == 0) {
            containerSize = this.originalContainerSize;
        }
        this.updatePaging(containerSize);
        this.setData(CONTAINER_SIZE, containerSize);
        if (!this.m_9236_().m_5776_()) {
            this.m_9236_().m_6907_().stream().filter(player -> {
                ShipContainerMenu shipContainerMenu;
                AbstractContainerMenu patt10268$temp = player.f_36096_;
                return patt10268$temp instanceof ShipContainerMenu && (shipContainerMenu = (ShipContainerMenu)patt10268$temp).getContainerShip().equals((Object)this);
            }).map(player -> (ServerPlayer)player).forEach(ServerPlayer::m_6915_);
        }
    }

    public void addContainerSizeSaveData(CompoundTag tag) {
        tag.m_128405_("ContainerSize", this.getData(CONTAINER_SIZE).intValue());
    }

    private void updatePaging(int containerSize) {
        int pages;
        int rowsPerPage;
        block4: {
            if (containerSize % 9 != 0) {
                throw new IllegalArgumentException("ShipContainerMenu can not be created with size " + containerSize + ". Make sure to use a container size that is divisible by 9.");
            }
            int allRows = containerSize / 9;
            rowsPerPage = 6;
            pages = 1;
            while (true) {
                if (pages * rowsPerPage >= allRows) {
                    if (pages * rowsPerPage != allRows) {
                        --rowsPerPage;
                        pages = 1;
                        continue;
                    }
                    break block4;
                }
                if (++pages > 127) break;
            }
            throw new IllegalArgumentException("ShipContainerMenu can not be created with size " + containerSize + ". Make sure to use a container size that requires less or equal to 128 pages. Current amount of required pages: " + pages);
        }
        this.setData(ROWS, (byte)rowsPerPage);
        this.setData(PAGES, (byte)pages);
        this.setData(PAGE_INDEX, (byte)0);
    }

    protected void updateContainerFillState() {
        double invFillStateInPercent = this.m_213659_().stream().map(i -> !i.m_41619_() ? (double)i.m_41613_() / (double)i.m_41741_() : 0.0).reduce(0.0, Double::sum) / (double)this.m_213659_().size();
        int u_byteMaxValue = 255;
        byte invFillState = (byte)(invFillStateInPercent * (double)u_byteMaxValue - 128.0);
        this.setContainerFillState(invFillState);
    }

    public void resizeContainer(int containerSize) {
        this.itemStacks = ContainerShip.resizeItemStacks(this, containerSize);
    }

    private static NonNullList<ItemStack> resizeItemStacks(ContainerEntity containerEntity, int containerSize) {
        SimpleContainer newContainer;
        ItemStack[] oldItemStacks = (ItemStack[])containerEntity.m_213659_().toArray(ItemStack[]::new);
        if (containerSize < oldItemStacks.length) {
            newContainer = new SimpleContainer(Arrays.copyOfRange(oldItemStacks, 0, containerSize));
            oldItemStacks = (ItemStack[])Arrays.stream(Arrays.copyOfRange(oldItemStacks, containerSize, oldItemStacks.length)).filter(stack -> !stack.m_41619_()).toArray(ItemStack[]::new);
            SimpleContainer leftoverContainer = new SimpleContainer(oldItemStacks.length);
            for (ItemStack oldItemStack : oldItemStacks) {
                leftoverContainer.m_19173_(newContainer.m_19173_(oldItemStack));
            }
            if (!leftoverContainer.m_7983_()) {
                Containers.m_18998_((Level)containerEntity.m_9236_(), (Entity)((Entity)containerEntity), (Container)leftoverContainer);
            }
        } else {
            newContainer = new SimpleContainer(containerSize);
            for (int i = 0; i < containerSize; ++i) {
                if (i >= oldItemStacks.length) continue;
                newContainer.m_6836_(i, oldItemStacks[i]);
            }
        }
        return ((SimpleContainerAccessor)newContainer).getItems();
    }

    public byte getContainerFillState() {
        return (Byte)this.f_19804_.m_135370_(CONTAINER_FILL_STATE);
    }

    public void setContainerFillState(byte b) {
        this.f_19804_.m_135381_(CONTAINER_FILL_STATE, (Object)b);
    }

    @Override
    public float getContainerModifier() {
        return ((Double)SmallShipsConfig.Common.shipGeneralContainerModifier.get()).floatValue() * (float)(this.getContainerFillState() - -128) / 255.0f;
    }
}

