/*
 * Decompiled with CFR 0.152.
 */
package hu.xannosz.betterminecarts.screen;

import hu.xannosz.betterminecarts.entity.ElectricLocomotive;
import hu.xannosz.betterminecarts.screen.ModMenus;
import hu.xannosz.betterminecarts.utils.ButtonId;
import hu.xannosz.betterminecarts.utils.MinecartHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ElectricLocomotiveMenu
extends AbstractContainerMenu {
    private final ElectricLocomotive entity;
    private final Level level;
    private final ContainerData data;

    public ElectricLocomotiveMenu(int containerId, Inventory inv, FriendlyByteBuf extraData) {
        this(containerId, inv, null, (ContainerData)new SimpleContainerData(5));
    }

    public ElectricLocomotiveMenu(int containerId, Inventory inv, Entity entity, ContainerData data) {
        super((MenuType)ModMenus.ELECTRIC_LOCOMOTIVE_MENU.get(), containerId);
        ElectricLocomotiveMenu.m_38869_((Container)inv, (int)0);
        this.entity = (ElectricLocomotive)entity;
        this.level = inv.f_35978_.m_9236_();
        this.data = data;
        this.m_38884_(data);
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player playerIn, int index) {
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(@NotNull Player player) {
        ContainerLevelAccess containerLevelAccess = ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.entity.m_20097_());
        return (Boolean)containerLevelAccess.m_39299_((level, blockPos) -> player.m_20275_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5) <= 64.0, (Object)true);
    }

    public int getElectricLocomotiveId() {
        return MinecartHelper.shortsToInt(new short[]{(short)this.data.m_6413_(0), (short)this.data.m_6413_(1)});
    }

    public ElectricLocomotive getEntity() {
        return (ElectricLocomotive)this.level.m_6815_(this.getElectricLocomotiveId());
    }

    public int getPower() {
        return this.data.m_6413_(4);
    }

    public ButtonId getActiveButton() {
        return ButtonId.getButtonFromId(this.data.m_6413_(2));
    }

    public boolean isSignalActive() {
        return MinecartHelper.convertIntToBitArray(this.data.m_6413_(3), 2)[0];
    }

    public boolean isLampOn() {
        return MinecartHelper.convertIntToBitArray(this.data.m_6413_(3), 2)[1];
    }
}

