/*
 * Decompiled with CFR 0.152.
 */
package hu.xannosz.betterminecarts.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import hu.xannosz.betterminecarts.screen.ButtonConfig;
import hu.xannosz.betterminecarts.screen.DieselLocomotiveMenu;
import hu.xannosz.betterminecarts.screen.Gauge;
import hu.xannosz.betterminecarts.screen.GraphicalButton;
import hu.xannosz.betterminecarts.utils.ButtonId;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.ScreenUtils;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class DieselLocomotiveScreen
extends AbstractContainerScreen<DieselLocomotiveMenu> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("betterminecarts", "textures/gui/diesel_locomotive.png");
    private int x;
    private int y;
    private GraphicalButton back;
    private GraphicalButton stop;
    private GraphicalButton forward;
    private GraphicalButton fForward;
    private GraphicalButton ffForward;
    private GraphicalButton lamp;
    private GraphicalButton whistle;
    private GraphicalButton redstone;
    private Gauge fuel;

    public DieselLocomotiveScreen(DieselLocomotiveMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.f_97727_ = 178;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.x = (this.f_96543_ - this.f_97726_) / 2;
        this.y = (this.f_96544_ - this.f_97727_) / 2;
        this.back = new GraphicalButton(this.generateConfig(65, 0, 7, ButtonId.BACK));
        this.stop = new GraphicalButton(this.generateConfig(73, 7, 7, ButtonId.STOP));
        this.forward = new GraphicalButton(this.generateConfig(81, 14, 7, ButtonId.FORWARD));
        this.fForward = new GraphicalButton(this.generateConfig(89, 21, 10, ButtonId.F_FORWARD));
        this.ffForward = new GraphicalButton(this.generateConfig(100, 31, 13, ButtonId.FF_FORWARD));
        this.lamp = new GraphicalButton(ButtonConfig.builder().buttonId(ButtonId.LAMP).hitBoxX(this.x + 155).hitBoxY(this.y + 46).hitBoxW(10).hitBoxH(11).hoveredX(177).hoveredY(84).build());
        this.whistle = new GraphicalButton(ButtonConfig.builder().buttonId(ButtonId.WHISTLE).hitBoxX(this.x + 155).hitBoxY(this.y + 62).hitBoxW(10).hitBoxH(11).hoveredX(177).hoveredY(96).build());
        this.redstone = new GraphicalButton(ButtonConfig.builder().buttonId(ButtonId.REDSTONE).hitBoxX(this.x + 155).hitBoxY(this.y + 78).hitBoxW(10).hitBoxH(11).hoveredX(177).hoveredY(108).build());
        this.fuel = new Gauge(this.x + 11, this.y + 9, 197, 2, 15, 79);
        this.m_142416_((GuiEventListener)this.back);
        this.m_142416_((GuiEventListener)this.stop);
        this.m_142416_((GuiEventListener)this.forward);
        this.m_142416_((GuiEventListener)this.fForward);
        this.m_142416_((GuiEventListener)this.ffForward);
        this.m_142416_((GuiEventListener)this.lamp);
        this.m_142416_((GuiEventListener)this.whistle);
        this.m_142416_((GuiEventListener)this.redstone);
    }

    protected void m_7286_(@NotNull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        RenderSystem.enableBlend();
        guiGraphics.m_280218_(TEXTURE, this.x, this.y, 0, 0, this.f_97726_, this.f_97727_);
        ((DieselLocomotiveMenu)this.f_97732_).createSlots();
        this.back.setEntityId(((DieselLocomotiveMenu)this.f_97732_).getDieselLocomotiveId());
        this.stop.setEntityId(((DieselLocomotiveMenu)this.f_97732_).getDieselLocomotiveId());
        this.forward.setEntityId(((DieselLocomotiveMenu)this.f_97732_).getDieselLocomotiveId());
        this.fForward.setEntityId(((DieselLocomotiveMenu)this.f_97732_).getDieselLocomotiveId());
        this.ffForward.setEntityId(((DieselLocomotiveMenu)this.f_97732_).getDieselLocomotiveId());
        this.lamp.setEntityId(((DieselLocomotiveMenu)this.f_97732_).getDieselLocomotiveId());
        this.whistle.setEntityId(((DieselLocomotiveMenu)this.f_97732_).getDieselLocomotiveId());
        this.redstone.setEntityId(((DieselLocomotiveMenu)this.f_97732_).getDieselLocomotiveId());
        this.back.setSelected(false);
        this.stop.setSelected(false);
        this.forward.setSelected(false);
        this.fForward.setSelected(false);
        this.ffForward.setSelected(false);
        switch (((DieselLocomotiveMenu)this.f_97732_).getActiveButton()) {
            case BACK: {
                this.back.setSelected(true);
                break;
            }
            case STOP: {
                this.stop.setSelected(true);
                break;
            }
            case FORWARD: {
                this.forward.setSelected(true);
                break;
            }
            case F_FORWARD: {
                this.fForward.setSelected(true);
                break;
            }
            case FF_FORWARD: {
                this.ffForward.setSelected(true);
            }
        }
        this.lamp.setSelected(((DieselLocomotiveMenu)this.f_97732_).isLampOn());
        this.redstone.setSelected(((DieselLocomotiveMenu)this.f_97732_).isSignalActive());
        int color = ((DieselLocomotiveMenu)this.f_97732_).getFuelColor();
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)((color & 0xFF0000) >> 16) / 255.0f;
        float g = (float)((color & 0xFF00) >> 8) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)a, (float)r, (float)g, (float)b);
        this.fuel.render(guiGraphics, ((DieselLocomotiveMenu)this.f_97732_).getFuelAmount(), 2000, partialTick);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ScreenUtils.drawTexturedModalRect((GuiGraphics)guiGraphics, (int)(this.x + 11), (int)(this.y + 9), (int)178, (int)2, (int)15, (int)79, (float)partialTick);
        int power = ((DieselLocomotiveMenu)this.f_97732_).getPower();
        if (power > 50) {
            power = 50;
        }
        int t = power * 59 / 50;
        ScreenUtils.drawTexturedModalRect((GuiGraphics)guiGraphics, (int)(this.x + 45), (int)(this.y + 37), (int)112, (int)178, (int)t, (int)2, (float)partialTick);
        int v = 178 + ((DieselLocomotiveMenu)this.f_97732_).getClock() / 6 * 8;
        ScreenUtils.drawTexturedModalRect((GuiGraphics)guiGraphics, (int)(this.x + 42), (int)(this.y + 28), (int)45, (int)v, (int)65, (int)8, (float)partialTick);
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_280003_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    private ButtonConfig generateConfig(int buttonX, int hoverX, int w, ButtonId buttonId) {
        return ButtonConfig.builder().buttonId(buttonId).hitBoxX(this.x + buttonX).hitBoxY(this.y + 80).hitBoxW(w).hitBoxH(9).hoveredX(hoverX).hoveredY(178).build();
    }
}

