/*
 * Decompiled with CFR 0.152.
 */
package hu.xannosz.betterminecarts.screen;

import hu.xannosz.betterminecarts.utils.ButtonId;

public class ButtonConfig {
    private ButtonId buttonId;
    private int hoveredX;
    private int hoveredY;
    private int hitBoxX;
    private int hitBoxY;
    private int hitBoxW;
    private int hitBoxH;

    ButtonConfig(ButtonId buttonId, int hoveredX, int hoveredY, int hitBoxX, int hitBoxY, int hitBoxW, int hitBoxH) {
        this.buttonId = buttonId;
        this.hoveredX = hoveredX;
        this.hoveredY = hoveredY;
        this.hitBoxX = hitBoxX;
        this.hitBoxY = hitBoxY;
        this.hitBoxW = hitBoxW;
        this.hitBoxH = hitBoxH;
    }

    public static ButtonConfigBuilder builder() {
        return new ButtonConfigBuilder();
    }

    public ButtonId getButtonId() {
        return this.buttonId;
    }

    public int getHoveredX() {
        return this.hoveredX;
    }

    public int getHoveredY() {
        return this.hoveredY;
    }

    public int getHitBoxX() {
        return this.hitBoxX;
    }

    public int getHitBoxY() {
        return this.hitBoxY;
    }

    public int getHitBoxW() {
        return this.hitBoxW;
    }

    public int getHitBoxH() {
        return this.hitBoxH;
    }

    public static class ButtonConfigBuilder {
        private ButtonId buttonId;
        private int hoveredX;
        private int hoveredY;
        private int hitBoxX;
        private int hitBoxY;
        private int hitBoxW;
        private int hitBoxH;

        ButtonConfigBuilder() {
        }

        public ButtonConfigBuilder buttonId(ButtonId buttonId) {
            this.buttonId = buttonId;
            return this;
        }

        public ButtonConfigBuilder hoveredX(int hoveredX) {
            this.hoveredX = hoveredX;
            return this;
        }

        public ButtonConfigBuilder hoveredY(int hoveredY) {
            this.hoveredY = hoveredY;
            return this;
        }

        public ButtonConfigBuilder hitBoxX(int hitBoxX) {
            this.hitBoxX = hitBoxX;
            return this;
        }

        public ButtonConfigBuilder hitBoxY(int hitBoxY) {
            this.hitBoxY = hitBoxY;
            return this;
        }

        public ButtonConfigBuilder hitBoxW(int hitBoxW) {
            this.hitBoxW = hitBoxW;
            return this;
        }

        public ButtonConfigBuilder hitBoxH(int hitBoxH) {
            this.hitBoxH = hitBoxH;
            return this;
        }

        public ButtonConfig build() {
            return new ButtonConfig(this.buttonId, this.hoveredX, this.hoveredY, this.hitBoxX, this.hitBoxY, this.hitBoxW, this.hitBoxH);
        }

        public String toString() {
            return "ButtonConfig.ButtonConfigBuilder(buttonId=" + this.buttonId + ", hoveredX=" + this.hoveredX + ", hoveredY=" + this.hoveredY + ", hitBoxX=" + this.hitBoxX + ", hitBoxY=" + this.hitBoxY + ", hitBoxW=" + this.hitBoxW + ", hitBoxH=" + this.hitBoxH + ")";
        }
    }
}

