/*
 * Decompiled with CFR 0.152.
 */
package hu.xannosz.betterminecarts.network;

import hu.xannosz.betterminecarts.config.BetterMinecartsConfig;
import hu.xannosz.betterminecarts.utils.KeyId;
import hu.xannosz.betterminecarts.utils.KeyUser;
import hu.xannosz.betterminecarts.utils.Linkable;
import hu.xannosz.betterminecarts.utils.TrainUtil;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class KeyPressedPacket {
    private final KeyId keyId;
    private final int entityId;

    public KeyPressedPacket(KeyId keyId, int entityId) {
        this.keyId = keyId;
        this.entityId = entityId;
    }

    public KeyPressedPacket(FriendlyByteBuf buf) {
        this.keyId = (KeyId)buf.m_130066_(KeyId.class);
        this.entityId = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.keyId);
        buf.writeInt(this.entityId);
    }

    public void handler(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            Entity entity = Objects.requireNonNull(context.getSender()).m_9236_().m_6815_(this.entityId);
            if (entity instanceof Linkable) {
                Linkable linkable = (Linkable)entity;
                Linkable head = (Boolean)BetterMinecartsConfig.KEY_CONTROL_FROM_THE_WHOLE_TRAIN.get() != false ? TrainUtil.getHeadOfTrain(linkable) : (linkable.getLinkedParent() == null ? linkable : (Linkable)linkable.getLinkedParent());
                if (head instanceof KeyUser) {
                    ((KeyUser)((Object)head)).executeKeyPress(this.keyId, (Player)context.getSender());
                }
            }
        });
    }
}

