/*
 * Decompiled with CFR 0.152.
 */
package hu.xannosz.betterminecarts.network;

import hu.xannosz.betterminecarts.utils.ButtonId;
import hu.xannosz.betterminecarts.utils.ButtonUser;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class ButtonClickedPacket {
    private final ButtonId buttonId;
    private final int entityId;

    public ButtonClickedPacket(ButtonId buttonId, int entityId) {
        this.buttonId = buttonId;
        this.entityId = entityId;
    }

    public ButtonClickedPacket(FriendlyByteBuf buf) {
        this.buttonId = (ButtonId)buf.m_130066_(ButtonId.class);
        this.entityId = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.buttonId);
        buf.writeInt(this.entityId);
    }

    public void handler(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            Entity entity = Objects.requireNonNull(context.getSender()).m_9236_().m_6815_(this.entityId);
            if (entity instanceof ButtonUser) {
                ((ButtonUser)entity).executeButtonClick(this.buttonId);
            }
        });
    }
}

