/*
 * Decompiled with CFR 0.152.
 */
package hu.xannosz.betterminecarts.entity;

import hu.xannosz.betterminecarts.entity.AbstractLocomotive;
import hu.xannosz.betterminecarts.entity.LocomotiveType;
import hu.xannosz.betterminecarts.entity.ModEntities;
import hu.xannosz.betterminecarts.item.ModItems;
import hu.xannosz.betterminecarts.screen.DieselLocomotiveMenu;
import hu.xannosz.betterminecarts.utils.ButtonId;
import hu.xannosz.betterminecarts.utils.FuelHolder;
import hu.xannosz.betterminecarts.utils.MinecartColor;
import hu.xannosz.betterminecarts.utils.MinecartHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DieselLocomotive
extends AbstractLocomotive
implements Container {
    public static final int FUEL_AMOUNT_KEY = 4;
    public static final int FUEL_COLOR_KEY_1 = 5;
    public static final int FUEL_COLOR_KEY_2 = 6;
    public static final int POWER_KEY = 7;
    public static final int CLOCK_KEY = 8;
    public static final int MAX_FUEL = 2000;
    public static final int MAX_POWER = 50;
    public static final int DATA_SIZE = 9;
    private int power = 0;
    private Map<CompoundTag, Integer> fuels = new HashMap<CompoundTag, Integer>();
    private int clock = 0;
    private final ItemStackHandler itemHandler = new ItemStackHandler(4){

        protected void onContentsChanged(int slot) {
            DieselLocomotive.this.m_6596_();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 1, 2, 3 -> FuelHolder.getINSTANCE().isFuel(stack);
                case 0 -> false;
                default -> super.isItemValid(slot, stack);
            };
        }
    };
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();

    public DieselLocomotive(EntityType<?> entityType, Level level) {
        super(entityType, level, LocomotiveType.DIESEL, LocomotiveType.DIESEL.getTopColor(), LocomotiveType.DIESEL.getBottomColor(), 9);
    }

    public DieselLocomotive(Level level, double x, double y, double z, MinecartColor topFilter, MinecartColor bottomFilter) {
        super((EntityType)ModEntities.DIESEL_LOCOMOTIVE.get(), x, y, z, level, LocomotiveType.DIESEL, topFilter, bottomFilter, 9);
    }

    @NotNull
    protected Item m_213728_() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots() + 1);
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        ItemStack locomotive = new ItemStack((ItemLike)ModItems.DIESEL_LOCOMOTIVE.get());
        locomotive.m_41784_().m_128359_("topColor", this.getTopFilter().getLabel());
        locomotive.m_41784_().m_128359_("bottomColor", this.getBottomFilter().getLabel());
        if (this.m_8077_()) {
            locomotive.m_41714_(this.m_7770_());
        }
        inventory.m_6836_(this.itemHandler.getSlots(), locomotive);
        Containers.m_19002_((Level)this.m_9236_(), (BlockPos)this.m_20183_(), (Container)inventory);
        return Items.f_41852_;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory inventory, @NotNull Player player) {
        this.updateData();
        return new DieselLocomotiveMenu(id, inventory, (Entity)this, this.data);
    }

    @Override
    protected boolean canPush() {
        return this.power > 0;
    }

    @Override
    protected List<Component> getEngineData() {
        return Arrays.asList(Component.m_237115_((String)"text.betterminecarts.data.fuel").m_7220_((Component)Component.m_237113_((String)(this.getFuelAmount() + "/2000")).m_130940_(ChatFormatting.GOLD)), Component.m_237115_((String)"text.betterminecarts.data.power").m_7220_((Component)Component.m_237113_((String)(this.power + "/50")).m_130940_(ChatFormatting.GRAY)), Component.m_237115_((String)"text.betterminecarts.data.fuel").m_7220_((Component)Component.m_237113_((String)("" + (this.itemHandler.getStackInSlot(1).m_41613_() + this.itemHandler.getStackInSlot(2).m_41613_() + this.itemHandler.getStackInSlot(3).m_41613_()))).m_130940_(ChatFormatting.BOLD)));
    }

    @Override
    public void updateData() {
        this.data.m_8050_(4, this.getFuelAmount());
        short[] colors = MinecartHelper.intToShorts(this.getFuelColor());
        this.data.m_8050_(5, (int)colors[0]);
        this.data.m_8050_(6, (int)colors[1]);
        this.data.m_8050_(7, this.power);
        this.data.m_8050_(8, this.clock);
        super.updateData();
        if (this.m_9236_().m_5776_()) {
            return;
        }
        this.f_19804_.m_135381_(MinecartHelper.IS_BURN, (Object)(this.activeButton != ButtonId.STOP ? 1 : 0));
    }

    @Override
    protected void m_7380_(@NotNull CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("Power", this.power);
        ListTag nbtTagList = new ListTag();
        for (Map.Entry<CompoundTag, Integer> entry : this.fuels.entrySet()) {
            CompoundTag com = entry.getKey().m_6426_();
            com.m_128405_("Amount", entry.getValue().intValue());
            nbtTagList.add((Object)com);
        }
        compoundTag.m_128365_("FuelItems", (Tag)nbtTagList);
        compoundTag.m_128365_("Inventory", (Tag)this.itemHandler.serializeNBT());
    }

    @Override
    protected void m_7378_(@NotNull CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.power = compoundTag.m_128451_("Power");
        this.fuels = new HashMap<CompoundTag, Integer>();
        ListTag tagList = compoundTag.m_128437_("FuelItems", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTag = tagList.m_128728_(i);
            int amount = itemTag.m_128451_("Amount");
            itemTag.m_128405_("Amount", 1);
            itemTag.m_128344_("Count", (byte)1);
            this.fuels.put(itemTag, amount);
        }
        this.itemHandler.deserializeNBT(compoundTag.m_128469_("Inventory"));
        this.updateData();
    }

    @Override
    public void m_8119_() {
        ArrayList<CompoundTag> keys;
        super.m_8119_();
        if (((Boolean)this.f_19804_.m_135370_(MinecartHelper.IS_BURN)).booleanValue()) {
            Vec3 smokeCoordinates = this.getSmokeCoordinates();
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123777_, smokeCoordinates.m_7096_() + ((double)this.f_19796_.m_188501_() - 0.5) * 0.1, smokeCoordinates.m_7098_(), smokeCoordinates.m_7094_() + ((double)this.f_19796_.m_188501_() - 0.5) * 0.1, 0.0, 0.2, 0.0);
        }
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (this.activeButton != ButtonId.STOP) {
            ++this.clock;
            if (this.activeButton == ButtonId.F_FORWARD) {
                ++this.clock;
            }
            if (this.activeButton == ButtonId.FF_FORWARD) {
                this.clock += 2;
            }
            if (this.clock >= 24) {
                this.clock = 0;
            }
        }
        if (this.activeButton != ButtonId.STOP) {
            --this.power;
            if (this.activeButton == ButtonId.F_FORWARD) {
                --this.power;
            }
            if (this.activeButton == ButtonId.FF_FORWARD) {
                this.power -= 2;
            }
        }
        if (this.power < 0) {
            this.power = 0;
        }
        if (this.power == 0) {
            this.xPush = 0.0;
            this.zPush = 0.0;
            this.activeButton = ButtonId.STOP;
        }
        if ((keys = new ArrayList<CompoundTag>(this.fuels.keySet())).size() > 0) {
            int energy;
            CompoundTag key = (CompoundTag)keys.get(new Random().nextInt(keys.size()));
            while (this.power + (energy = FuelHolder.getINSTANCE().getFuelPower(ItemStack.m_41712_((CompoundTag)key))) <= 50) {
                this.power += energy;
                this.fuels.put(key, this.getFromFuels(key) - 1);
                if (this.getFromFuels(key) > 0) continue;
                this.fuels.remove(key);
                break;
            }
        }
        int fuelAmount = FuelHolder.getINSTANCE().getFuelAmount(this.itemHandler.getStackInSlot(1));
        Item leftover = FuelHolder.getINSTANCE().getLeftover(this.itemHandler.getStackInSlot(1));
        if (this.getFuelAmount() + fuelAmount <= 2000 && this.fuels.size() < 11 && (this.itemHandler.getStackInSlot(0).m_41619_() || this.itemHandler.getStackInSlot(0).m_41720_().equals(leftover) && this.itemHandler.getStackInSlot(0).m_41613_() < this.itemHandler.getStackInSlot(0).m_41741_())) {
            if (!this.fuels.containsKey(this.getFuelKey(this.itemHandler.getStackInSlot(1)))) {
                this.fuels.put(this.getFuelKey(this.itemHandler.getStackInSlot(1)), 0);
            }
            this.fuels.put(this.getFuelKey(this.itemHandler.getStackInSlot(1)), this.getFromFuels(this.getFuelKey(this.itemHandler.getStackInSlot(1))) + fuelAmount);
            this.itemHandler.getStackInSlot(1).m_41774_(1);
            if (this.itemHandler.getStackInSlot(0).m_41619_()) {
                this.itemHandler.setStackInSlot(0, new ItemStack((ItemLike)leftover, 1));
            } else {
                this.itemHandler.getStackInSlot(0).m_41769_(1);
            }
        }
        this.moveStack(2, 1);
        this.moveStack(3, 2);
        this.updateData();
    }

    private Vec3 getSmokeCoordinates() {
        switch (this.m_6374_()) {
            case NORTH: {
                return new Vec3(this.m_20185_(), this.m_20186_() + 1.2, this.m_20189_() + 0.1);
            }
            case SOUTH: {
                return new Vec3(this.m_20185_(), this.m_20186_() + 1.2, this.m_20189_() - 0.1);
            }
            case WEST: {
                return new Vec3(this.m_20185_() + 0.1, this.m_20186_() + 1.2, this.m_20189_());
            }
            case EAST: {
                return new Vec3(this.m_20185_() - 0.1, this.m_20186_() + 1.2, this.m_20189_());
            }
        }
        return new Vec3(this.m_20185_(), this.m_20186_() + 1.2, this.m_20189_());
    }

    private void moveStack(int s, int t) {
        if (this.itemHandler.getStackInSlot(s).m_41619_()) {
            return;
        }
        if (this.itemHandler.getStackInSlot(t).m_41619_()) {
            this.itemHandler.setStackInSlot(t, new ItemStack((ItemLike)this.itemHandler.getStackInSlot(s).m_41720_(), 1));
        } else if (this.itemHandler.getStackInSlot(t).m_41613_() < this.itemHandler.getStackInSlot(t).m_41741_() && this.itemHandler.getStackInSlot(s).m_41720_().equals(this.itemHandler.getStackInSlot(t).m_41720_())) {
            this.itemHandler.getStackInSlot(t).m_41769_(1);
        } else {
            return;
        }
        this.itemHandler.getStackInSlot(s).m_41774_(1);
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MinecartHelper.IS_BURN, (Object)false);
    }

    private int getFuelAmount() {
        int result = 0;
        if (this.fuels != null) {
            for (int f : this.fuels.values()) {
                result += f;
            }
        }
        return result;
    }

    private int getFuelColor() {
        if (this.fuels == null) {
            return -1;
        }
        double maxFuel = this.getFuelAmount();
        double a = 0.0;
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        for (CompoundTag stack : this.fuels.keySet()) {
            int color = FuelHolder.getINSTANCE().getFuelColor(ItemStack.m_41712_((CompoundTag)stack));
            a += (double)((color >> 24 & 0xFF) * this.getFromFuels(stack)) / maxFuel;
            r += (double)(((color & 0xFF0000) >> 16) * this.getFromFuels(stack)) / maxFuel;
            g += (double)(((color & 0xFF00) >> 8) * this.getFromFuels(stack)) / maxFuel;
            b += (double)((color & 0xFF) * this.getFromFuels(stack)) / maxFuel;
        }
        return (int)a << 24 | (int)r << 16 | (int)g << 8 | (int)b;
    }

    public int m_6643_() {
        return 4;
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack itemstack = this.itemHandler.getStackInSlot(i);
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack m_8020_(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }

    @NotNull
    public ItemStack m_7407_(int slot, int count) {
        if (slot == 0) {
            return count > 0 ? this.itemHandler.getStackInSlot(slot).m_41620_(count) : ItemStack.f_41583_;
        }
        return new ItemStack((ItemLike)Blocks.f_50016_, 0);
    }

    @NotNull
    public ItemStack m_8016_(int slot) {
        return this.m_8020_(slot);
    }

    public void m_6836_(int slot, @NotNull ItemStack itemStack) {
        this.itemHandler.setStackInSlot(slot, itemStack);
    }

    public void m_6596_() {
    }

    public boolean m_6542_(@NotNull Player player) {
        return false;
    }

    public void m_6211_() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, new ItemStack((ItemLike)Blocks.f_50016_, 0));
        }
    }

    public boolean m_7013_(int slot, @NotNull ItemStack itemStack) {
        return this.itemHandler.isItemValid(slot, itemStack);
    }

    private CompoundTag getFuelKey(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        CompoundTag itemTag = new CompoundTag();
        itemStack.m_41739_(itemTag);
        itemTag.m_128344_("Count", (byte)1);
        itemTag.m_128405_("Amount", 1);
        return itemTag;
    }

    private int getFromFuels(CompoundTag tag) {
        Integer num = this.fuels.get(tag);
        if (num == null) {
            return 0;
        }
        return num;
    }

    public int getClock() {
        return this.clock;
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public LazyOptional<IItemHandler> getLazyItemHandler() {
        return this.lazyItemHandler;
    }
}

