/*
 * Decompiled with CFR 0.152.
 */
package hu.xannosz.betterminecarts.entity;

import hu.xannosz.betterminecarts.BetterMinecarts;
import hu.xannosz.betterminecarts.blockentity.GlowingRailBlockEntity;
import hu.xannosz.betterminecarts.blocks.ModBlocks;
import hu.xannosz.betterminecarts.config.BetterMinecartsConfig;
import hu.xannosz.betterminecarts.entity.LocomotiveType;
import hu.xannosz.betterminecarts.entity.SteamLocomotive;
import hu.xannosz.betterminecarts.item.ModItems;
import hu.xannosz.betterminecarts.network.ModMessages;
import hu.xannosz.betterminecarts.network.PlaySoundPacket;
import hu.xannosz.betterminecarts.utils.ButtonId;
import hu.xannosz.betterminecarts.utils.ButtonUser;
import hu.xannosz.betterminecarts.utils.KeyId;
import hu.xannosz.betterminecarts.utils.KeyUser;
import hu.xannosz.betterminecarts.utils.Linkable;
import hu.xannosz.betterminecarts.utils.MinecartColor;
import hu.xannosz.betterminecarts.utils.MinecartHelper;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractLocomotive
extends AbstractMinecart
implements ButtonUser,
MenuProvider,
KeyUser {
    public static final int ID_KEY_1 = 0;
    public static final int ID_KEY_2 = 1;
    public static final int ACTIVE_BUTTON_KEY = 2;
    public static final int ACTIVE_FUNCTION_KEY = 3;
    protected ButtonId activeButton = ButtonId.STOP;
    protected double xPush = 0.0;
    protected double zPush = 0.0;
    protected final ContainerData data;
    protected int speed = 0;
    private boolean sendSignal = false;
    private boolean lampOn = false;
    private MinecartColor topFilter;
    private MinecartColor bottomFilter;
    private ChunkPos prevChunkPos;
    private final LocomotiveType locomotiveType;

    protected AbstractLocomotive(EntityType<?> entityType, Level level, LocomotiveType locomotiveType, MinecartColor topFilter, MinecartColor bottomFilter, int dataSize) {
        super(entityType, level);
        this.locomotiveType = locomotiveType;
        this.topFilter = topFilter;
        this.bottomFilter = bottomFilter;
        this.data = new SimpleContainerData(dataSize);
        this.prevChunkPos = this.m_146902_();
        this.updateData();
    }

    protected AbstractLocomotive(EntityType<?> entityType, double x, double y, double z, Level level, LocomotiveType locomotiveType, MinecartColor topFilter, MinecartColor bottomFilter, int dataSize) {
        super(entityType, level, x, y, z);
        this.locomotiveType = locomotiveType;
        this.topFilter = topFilter;
        this.bottomFilter = bottomFilter;
        this.data = new SimpleContainerData(dataSize);
        this.prevChunkPos = this.m_146902_();
        this.updateData();
    }

    protected abstract boolean canPush();

    public void setStartDirection(Direction direction) {
        switch (direction) {
            case NORTH: {
                this.m_146922_(90.0f);
                break;
            }
            case EAST: {
                this.m_146922_(180.0f);
                break;
            }
            case SOUTH: {
                this.m_146922_(-90.0f);
            }
        }
        this.updateData();
    }

    public float normalizeRotation(float yRotation) {
        float expectedAngle = 0.0f;
        switch (this.m_6374_()) {
            case NORTH: {
                expectedAngle = 90.0f;
                break;
            }
            case SOUTH: {
                expectedAngle = 270.0f;
                break;
            }
            case WEST: {
                expectedAngle = 0.0f;
                break;
            }
            case EAST: {
                expectedAngle = 180.0f;
            }
        }
        if (!this.isInRange(yRotation, expectedAngle)) {
            yRotation += 180.0f;
        }
        return yRotation;
    }

    private boolean isInRange(float yRotation, float expectedAngle) {
        float plusYRotation;
        int border = 80;
        float f = plusYRotation = yRotation < 0.0f ? yRotation + 360.0f : yRotation;
        if (expectedAngle == 0.0f) {
            return expectedAngle - 80.0f < plusYRotation && (plusYRotation < expectedAngle + 80.0f || 280.0f < plusYRotation);
        }
        return expectedAngle - 80.0f < plusYRotation && plusYRotation < expectedAngle + 80.0f;
    }

    public float normalizePitch(float pitch) {
        switch (this.m_6374_()) {
            case NORTH: 
            case WEST: {
                return -1.0f * pitch;
            }
        }
        return pitch;
    }

    public boolean popSignal() {
        if (this.sendSignal) {
            this.sendSignal = false;
            return true;
        }
        return false;
    }

    @Override
    public void executeButtonClick(ButtonId buttonId) {
        switch (buttonId) {
            case BACK: {
                this.setPush(this.m_6350_().m_122428_());
                this.speed = 1;
                this.activeButton = buttonId;
                break;
            }
            case STOP: 
            case PAUSE: {
                this.xPush = 0.0;
                this.zPush = 0.0;
                this.speed = 1;
                this.activeButton = buttonId;
                break;
            }
            case FORWARD: {
                this.setPush(this.m_6350_().m_122427_());
                this.speed = 1;
                this.activeButton = buttonId;
                break;
            }
            case F_FORWARD: {
                this.setPush(this.m_6350_().m_122427_());
                this.speed = 2;
                this.activeButton = buttonId;
                break;
            }
            case FF_FORWARD: {
                this.setPush(this.m_6350_().m_122427_());
                this.speed = 4;
                this.activeButton = buttonId;
                break;
            }
            case LAMP: {
                this.lampOn = !this.lampOn;
                break;
            }
            case WHISTLE: {
                this.whistle();
                break;
            }
            case REDSTONE: {
                this.sendSignal = !this.sendSignal;
            }
        }
        this.updateData();
    }

    @Override
    public void executeKeyPress(KeyId keyId, Player player) {
        switch (keyId) {
            case LAMP: {
                this.executeButtonClick(ButtonId.LAMP);
                player.m_5661_((Component)Component.m_237115_((String)("text.betterminecarts.keyPress.lamp." + this.lampOn)).m_130940_(ChatFormatting.AQUA), true);
                break;
            }
            case WHISTLE: {
                this.executeButtonClick(ButtonId.WHISTLE);
                break;
            }
            case REDSTONE: {
                this.executeButtonClick(ButtonId.REDSTONE);
                player.m_5661_((Component)Component.m_237115_((String)("text.betterminecarts.keyPress.redstone." + this.sendSignal)).m_130940_(ChatFormatting.AQUA), true);
                break;
            }
            case DATA: {
                this.getEngineData().forEach(arg_0 -> ((Player)player).m_213846_(arg_0));
                player.m_213846_((Component)Component.m_237115_((String)"text.betterminecarts.data.lamp").m_7220_((Component)Component.m_237115_((String)("text.betterminecarts.keyPress.lamp." + this.lampOn)).m_130940_(this.lampOn ? ChatFormatting.YELLOW : ChatFormatting.GOLD)));
                player.m_213846_((Component)Component.m_237115_((String)"text.betterminecarts.data.redstone").m_7220_((Component)Component.m_237115_((String)("text.betterminecarts.keyPress.redstone." + this.sendSignal)).m_130940_(this.sendSignal ? ChatFormatting.RED : ChatFormatting.DARK_RED)));
                player.m_213846_((Component)Component.m_237115_((String)"text.betterminecarts.data.speed").m_7220_((Component)Component.m_237115_((String)("text.betterminecarts.keyPress.speed." + this.activeButton)).m_130940_(ChatFormatting.DARK_GRAY)));
                break;
            }
            case INCREASE: {
                switch (this.activeButton) {
                    case BACK: {
                        this.executeButtonClick(ButtonId.STOP);
                        break;
                    }
                    case PAUSE: {
                        this.executeButtonClick(ButtonId.FORWARD);
                        break;
                    }
                    case STOP: {
                        if (this instanceof SteamLocomotive) {
                            this.executeButtonClick(ButtonId.PAUSE);
                            break;
                        }
                        this.executeButtonClick(ButtonId.FORWARD);
                        break;
                    }
                    case FORWARD: {
                        this.executeButtonClick(ButtonId.F_FORWARD);
                        break;
                    }
                    case F_FORWARD: {
                        this.executeButtonClick(ButtonId.FF_FORWARD);
                    }
                }
                player.m_5661_((Component)Component.m_237115_((String)("text.betterminecarts.keyPress.speed." + this.activeButton)).m_130940_(ChatFormatting.AQUA), true);
                break;
            }
            case DECREASE: {
                switch (this.activeButton) {
                    case PAUSE: {
                        this.executeButtonClick(ButtonId.STOP);
                        break;
                    }
                    case STOP: {
                        this.executeButtonClick(ButtonId.BACK);
                        break;
                    }
                    case FORWARD: {
                        if (this instanceof SteamLocomotive) {
                            this.executeButtonClick(ButtonId.PAUSE);
                            break;
                        }
                        this.executeButtonClick(ButtonId.STOP);
                        break;
                    }
                    case F_FORWARD: {
                        this.executeButtonClick(ButtonId.FORWARD);
                        break;
                    }
                    case FF_FORWARD: {
                        this.executeButtonClick(ButtonId.F_FORWARD);
                    }
                }
                player.m_5661_((Component)Component.m_237115_((String)("text.betterminecarts.keyPress.speed." + this.activeButton)).m_130940_(ChatFormatting.AQUA), true);
            }
        }
    }

    protected abstract List<Component> getEngineData();

    private void setPush(Direction direction) {
        if (!this.canPush()) {
            return;
        }
        switch (direction) {
            case NORTH: {
                this.xPush = 0.0;
                this.zPush = -1.0;
                break;
            }
            case SOUTH: {
                this.xPush = 0.0;
                this.zPush = 1.0;
                break;
            }
            case WEST: {
                this.xPush = -1.0;
                this.zPush = 0.0;
                break;
            }
            case EAST: {
                this.xPush = 1.0;
                this.zPush = 0.0;
            }
        }
    }

    private double getNormalizedSpeed(double speed) {
        return Math.max(Math.min(speed, this.m_7097_()), -this.m_7097_());
    }

    public void updateData() {
        short[] ids = MinecartHelper.intToShorts(this.m_19879_());
        this.data.m_8050_(0, (int)ids[0]);
        this.data.m_8050_(1, (int)ids[1]);
        this.data.m_8050_(2, this.activeButton.getId());
        this.data.m_8050_(3, MinecartHelper.convertBitArrayToInt(new boolean[]{this.sendSignal, this.lampOn}));
        if (this.m_9236_().m_5776_()) {
            return;
        }
        this.f_19804_.m_135381_(MinecartHelper.TOP_FILTER, (Object)this.topFilter.getLabel());
        this.f_19804_.m_135381_(MinecartHelper.BOTTOM_FILTER, (Object)this.bottomFilter.getLabel());
        this.f_19804_.m_135381_(MinecartHelper.IS_LAMP_ON, (Object)this.lampOn);
    }

    private void whistle() {
        try {
            SteamLocomotive steamLocomotive;
            AbstractLocomotive abstractLocomotive;
            if (((Boolean)BetterMinecartsConfig.WHISTLE_USE_STEAM_ON_STEAM_LOCOMOTIVE.get()).booleanValue() && (abstractLocomotive = this) instanceof SteamLocomotive && !(steamLocomotive = (SteamLocomotive)abstractLocomotive).canWhistle()) {
                return;
            }
            this.m_9236_().m_6907_().forEach(player -> {
                if (player.m_20280_((Entity)this) < 7000.0) {
                    ModMessages.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new PlaySoundPacket(this.m_20183_(), this.locomotiveType));
                }
            });
            if (((Boolean)BetterMinecartsConfig.MOBS_PANIC_AFTER_WHISTLE.get()).booleanValue()) {
                this.m_9236_().m_45933_((Entity)this, new AABB(this.m_20097_().m_7918_(-((Integer)BetterMinecartsConfig.MOBS_PANIC_AFTER_WHISTLE_RANGE.get()).intValue(), -10, -((Integer)BetterMinecartsConfig.MOBS_PANIC_AFTER_WHISTLE_RANGE.get()).intValue()), this.m_20097_().m_7918_(((Integer)BetterMinecartsConfig.MOBS_PANIC_AFTER_WHISTLE_RANGE.get()).intValue(), 25, ((Integer)BetterMinecartsConfig.MOBS_PANIC_AFTER_WHISTLE_RANGE.get()).intValue()))).forEach(entity -> {
                    if (entity instanceof Mob) {
                        Mob cow = (Mob)entity;
                        cow.f_21345_.m_148105_().forEach(wrappedGoal -> {
                            if (wrappedGoal.m_26015_() instanceof PanicGoal) {
                                wrappedGoal.m_8041_();
                                wrappedGoal.m_8056_();
                            }
                        });
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void m_8119_() {
        super.m_8119_();
        this.loadChunk();
        this.checkRedstoneUnderLocomotive();
        this.setLamp();
    }

    private void setLamp() {
        if (this.lampOn && !this.m_9236_().m_5776_()) {
            HashSet<BlockPos> positions = new HashSet<BlockPos>();
            positions.add(this.m_20097_());
            positions.add(this.m_20097_().m_7918_(1, 0, 1));
            positions.add(this.m_20097_().m_7918_(1, 0, 0));
            positions.add(this.m_20097_().m_7918_(1, 0, -1));
            positions.add(this.m_20097_().m_7918_(0, 0, -1));
            positions.add(this.m_20097_().m_7918_(-1, 0, -1));
            positions.add(this.m_20097_().m_7918_(-1, 0, 0));
            positions.add(this.m_20097_().m_7918_(-1, 0, 1));
            positions.add(this.m_20097_().m_7918_(0, 0, 1));
            for (BlockPos position : positions) {
                this.setLampOnPosition(position);
            }
        }
    }

    private void setLampOnPosition(BlockPos position) {
        BlockEntity blockEntity;
        BlockState state = this.m_9236_().m_8055_(position);
        if (state.m_60734_().equals(ModBlocks.GLOWING_RAIL.get()) && (blockEntity = this.m_9236_().m_7702_(position)) instanceof GlowingRailBlockEntity) {
            GlowingRailBlockEntity glowingRailBlockEntity = (GlowingRailBlockEntity)blockEntity;
            glowingRailBlockEntity.setCount(0);
        }
        if (state.m_60734_().equals(Blocks.f_50156_)) {
            this.m_9236_().m_6933_(position, (BlockState)((BlockState)((Block)ModBlocks.GLOWING_RAIL.get()).m_49966_().m_61124_((Property)RailBlock.f_55392_, (Comparable)((RailShape)state.m_61143_((Property)RailBlock.f_55392_)))).m_61124_((Property)BaseRailBlock.f_152149_, (Comparable)((Boolean)state.m_61143_((Property)BaseRailBlock.f_152149_))), 2, 0);
        }
    }

    private void checkRedstoneUnderLocomotive() {
        if (this.activeButton != ButtonId.STOP && (this.m_9236_().m_8055_(this.m_20097_()).m_60734_().equals(Blocks.f_50156_) || this.m_9236_().m_8055_(this.m_20097_()).m_60734_().equals(ModBlocks.GLOWING_RAIL.get())) && this.m_9236_().m_8055_(this.m_20097_().m_7495_()).m_60734_().equals(Blocks.f_50330_)) {
            this.whistle();
        }
    }

    private void loadChunk() {
        Level level;
        if (((Boolean)BetterMinecartsConfig.FURNACE_MINECARTS_LOAD_CHUNKS.get()).booleanValue() && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            ChunkPos currentChunkPos = SectionPos.m_235861_((EntityAccess)this).m_123251_();
            if (!this.activeButton.equals((Object)ButtonId.STOP) && !this.activeButton.equals((Object)ButtonId.PAUSE)) {
                server.m_7726_().m_8387_(TicketType.f_9444_, currentChunkPos, 3, (Object)this.m_146902_());
            }
            if (!currentChunkPos.equals((Object)this.prevChunkPos) || this.activeButton.equals((Object)ButtonId.STOP) || this.activeButton.equals((Object)ButtonId.PAUSE)) {
                server.m_7726_().m_8438_(TicketType.f_9444_, this.prevChunkPos, 3, (Object)this.m_146902_());
            }
            this.prevChunkPos = currentChunkPos;
        }
    }

    @NotNull
    public InteractionResult m_6096_(Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_150930_((Item)ModItems.CROWBAR.get())) {
            return super.m_6096_(player, hand);
        }
        if (MinecartColor.getFromItem(stack.m_41720_()) != null) {
            if (player.m_6144_()) {
                this.bottomFilter = MinecartColor.getFromItem(stack.m_41720_());
            } else {
                this.topFilter = MinecartColor.getFromItem(stack.m_41720_());
            }
            stack.m_41774_(1);
            this.updateData();
            return InteractionResult.SUCCESS;
        }
        if (player.m_6144_()) {
            return InteractionResult.PASS;
        }
        player.m_5893_((MenuProvider)this);
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public AbstractMinecart.Type m_6064_() {
        return AbstractMinecart.Type.FURNACE;
    }

    public ItemStack m_142340_() {
        ItemStack result = null;
        switch (this.locomotiveType) {
            case ELECTRIC: {
                result = new ItemStack((ItemLike)ModItems.ELECTRIC_LOCOMOTIVE.get(), 1);
                break;
            }
            case STEAM: {
                result = new ItemStack((ItemLike)ModItems.STEAM_LOCOMOTIVE.get(), 1);
                break;
            }
            case DIESEL: {
                result = new ItemStack((ItemLike)ModItems.DIESEL_LOCOMOTIVE.get(), 1);
            }
        }
        result.m_41784_().m_128359_("topColor", this.getTopFilter().getLabel());
        result.m_41784_().m_128359_("bottomColor", this.getBottomFilter().getLabel());
        if (this.m_8077_()) {
            result.m_41714_(this.m_7770_());
        }
        return result;
    }

    public boolean m_142535_(float height, float p_146829_, @NotNull DamageSource damageSource) {
        if (height > 2.0f && height < 6.0f) {
            this.explode(2.0f);
            return true;
        }
        if (height >= 6.0f) {
            this.explode(8.0f);
            return true;
        }
        return false;
    }

    protected void explode(float power) {
        if (!this.m_9236_().f_46443_ && ((Boolean)BetterMinecartsConfig.LOCOMOTIVE_EXPLODE_AFTER_FALL_DAMAGE.get()).booleanValue()) {
            this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), power, Level.ExplosionInteraction.BLOCK);
            this.m_146870_();
        }
    }

    protected void m_6401_(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        double d0 = 1.0E-4;
        double d1 = 0.001;
        try {
            super.m_6401_(blockPos, blockState);
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        Vec3 vec3 = this.m_20184_();
        double d2 = vec3.m_165925_();
        double d3 = this.xPush * this.xPush + this.zPush * this.zPush;
        if (d3 > d0 && d2 > d1) {
            double d4 = Math.sqrt(d2);
            double d5 = Math.sqrt(d3);
            this.xPush = vec3.f_82479_ / d4 * d5;
            this.zPush = vec3.f_82481_ / d4 * d5;
        }
        this.updateData();
    }

    protected double m_7097_() {
        return (this.m_20069_() ? 1.5 : 2.0) * (double)this.speed / 20.0;
    }

    public float getMaxCartSpeedOnRail() {
        return 6.0f;
    }

    protected void m_7114_() {
        double d0 = this.xPush * this.xPush + this.zPush * this.zPush;
        if (d0 > 1.0E-7) {
            d0 = Math.sqrt(d0);
            this.xPush /= d0;
            this.zPush /= d0;
            Vec3 vec3 = this.m_20184_().m_82542_(0.8, 0.0, 0.8).m_82520_(this.xPush, 0.0, this.zPush);
            if (this.m_20069_()) {
                vec3 = vec3.m_82490_(0.1);
            }
            this.m_20256_(vec3);
        } else {
            this.m_20256_(this.m_20184_().m_82542_(0.6, 0.0, 0.6));
        }
        Vec3 dMovement = this.m_20184_();
        this.m_20334_(this.getNormalizedSpeed(dMovement.f_82479_), dMovement.f_82480_, this.getNormalizedSpeed(dMovement.f_82481_));
        super.m_7114_();
    }

    public void m_6025_(int p_38659_, int p_38660_, int p_38661_, boolean p_38662_) {
        if (p_38662_) {
            this.whistle();
        }
    }

    public boolean m_7337_(@NotNull Entity other) {
        LivingEntity living;
        float damage;
        Linkable self = (Linkable)((Object)this);
        if (other instanceof AbstractMinecart) {
            AbstractMinecart minecart = (AbstractMinecart)other;
            if (self.getLinkedParent() != null && !self.getLinkedParent().equals((Object)minecart) || self.getLinkedParent() == null) {
                minecart.m_20256_(this.m_20184_());
            }
        }
        if ((damage = ((Double)BetterMinecartsConfig.MINECART_DAMAGE.get()).floatValue()) > 0.0f && !this.m_9236_().m_5776_() && other instanceof LivingEntity && (living = (LivingEntity)other).m_6084_() && !living.m_20159_() && this.speed > 1) {
            living.m_6469_(new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(BetterMinecarts.MINECART_DAMAGE), (Entity)this), damage);
            Vec3 knockBack = living.m_20184_().m_82520_(this.m_20184_().m_7096_() * (double)this.speed, this.m_20184_().m_82553_() * 0.5 * (double)this.speed, this.m_20184_().m_7094_() * (double)this.speed);
            living.m_20256_(knockBack);
            living.f_19812_ = true;
            return false;
        }
        return Boat.m_38323_((Entity)this, (Entity)other);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MinecartHelper.TOP_FILTER, (Object)MinecartColor.MAGENTA.getLabel());
        this.f_19804_.m_135372_(MinecartHelper.BOTTOM_FILTER, (Object)MinecartColor.BLACK.getLabel());
        this.f_19804_.m_135372_(MinecartHelper.IS_LAMP_ON, (Object)false);
    }

    public MinecartColor getTopFilter() {
        return MinecartColor.getFromLabel((String)this.f_19804_.m_135370_(MinecartHelper.TOP_FILTER));
    }

    public MinecartColor getBottomFilter() {
        return MinecartColor.getFromLabel((String)this.f_19804_.m_135370_(MinecartHelper.BOTTOM_FILTER));
    }

    public boolean isLampOn() {
        return (Boolean)this.f_19804_.m_135370_(MinecartHelper.IS_LAMP_ON);
    }

    protected void m_7380_(@NotNull CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128347_("PushX", this.xPush);
        compoundTag.m_128347_("PushZ", this.zPush);
        compoundTag.m_128405_("ActiveButton", this.activeButton.getId());
        compoundTag.m_128405_("Speed", this.speed);
        compoundTag.m_128379_("SendSignal", this.sendSignal);
        compoundTag.m_128379_("LampOn", this.lampOn);
        compoundTag.m_128359_("TopFilter", this.topFilter.getLabel());
        compoundTag.m_128359_("BottomFilter", this.bottomFilter.getLabel());
        compoundTag.m_128356_("PrevChunkPos", this.prevChunkPos.m_45588_());
    }

    protected void m_7378_(@NotNull CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.xPush = compoundTag.m_128459_("PushX");
        this.zPush = compoundTag.m_128459_("PushZ");
        this.activeButton = ButtonId.getButtonFromId(compoundTag.m_128451_("ActiveButton"));
        this.speed = compoundTag.m_128451_("Speed");
        this.sendSignal = compoundTag.m_128471_("SendSignal");
        this.lampOn = compoundTag.m_128471_("LampOn");
        this.topFilter = MinecartColor.getFromLabel(compoundTag.m_128461_("TopFilter"));
        this.bottomFilter = MinecartColor.getFromLabel(compoundTag.m_128461_("BottomFilter"));
        this.prevChunkPos = new ChunkPos(compoundTag.m_128454_("PrevChunkPos"));
        this.updateData();
    }
}

