/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.mixin;

import com.faboslav.friendsandfoes.entity.PlayerIllusionEntity;
import com.faboslav.friendsandfoes.init.FriendsAndFoesEntityTypes;
import com.faboslav.friendsandfoes.init.FriendsAndFoesItems;
import com.faboslav.friendsandfoes.init.FriendsAndFoesSoundEvents;
import com.faboslav.friendsandfoes.platform.TotemHelper;
import com.faboslav.friendsandfoes.tag.FriendsAndFoesTags;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin
extends LivingEntity {
    private static final int MAX_ILLUSIONS_COUNT = 9;
    private static final int ILLUSION_LIFETIME_TICKS = 600;
    private static final int NEGATIVE_EFFECT_TICKS = 400;
    private static final int POSITIVE_EFFECT_TICKS = 200;
    private static final Predicate<LivingEntity> FREEZE_FILTER = entity -> !(entity instanceof Player) || !((Player)entity).m_7500_();
    private static final TargetingConditions FREEZE_TARGET_PREDICATE = TargetingConditions.m_148353_().m_26893_().m_148355_().m_26888_(FREEZE_FILTER);
    private static final TargetingConditions ATTACK_TARGET_PREDICATE = TargetingConditions.m_148353_().m_26893_().m_148355_();
    @Shadow
    public double f_36102_;
    @Shadow
    public double f_36104_;
    @Shadow
    public double f_36103_;
    @Shadow
    public double f_36105_;
    @Shadow
    public double f_36106_;
    @Shadow
    public double f_36075_;
    @Shadow
    public float f_36099_;
    @Shadow
    public float f_36100_;

    protected PlayerEntityMixin(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Shadow
    public abstract ItemStack m_6844_(EquipmentSlot var1);

    @Shadow
    public abstract Iterable<ItemStack> m_6168_();

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void friendsandfoes_addToTick(CallbackInfo ci) {
        this.friendsandfoes_updateWildfireCrown();
    }

    private void friendsandfoes_updateWildfireCrown() {
        ItemStack itemStack = this.m_6844_(EquipmentSlot.HEAD);
        if (itemStack.m_150930_(FriendsAndFoesItems.WILDFIRE_CROWN.get()) && !this.m_204029_(FluidTags.f_13132_)) {
            this.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 300, 0, false, false, true));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"damage"}, cancellable=true)
    public void friendsandfoes_tryUseTotems(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (this.m_21223_() <= this.m_21233_() / 2.0f) {
            PlayerEntityMixin entity = this;
            ItemStack offhandItemStack = entity.m_21120_(InteractionHand.OFF_HAND);
            ItemStack mainhandItemStack = entity.m_21120_(InteractionHand.MAIN_HAND);
            ItemStack moddedSlotItemStack = TotemHelper.getTotemFromModdedSlots((Player)entity, PlayerEntityMixin::isTotem);
            ItemStack totemItemStack = null;
            if (PlayerEntityMixin.isTotem(mainhandItemStack)) {
                totemItemStack = mainhandItemStack;
            } else if (PlayerEntityMixin.isTotem(offhandItemStack)) {
                totemItemStack = offhandItemStack;
            } else if (moddedSlotItemStack != null) {
                totemItemStack = moddedSlotItemStack;
            }
            if (totemItemStack != null) {
                if (this instanceof ServerPlayer) {
                    ServerPlayer serverPlayerEntity = (ServerPlayer)this;
                    if (totemItemStack.m_41720_() == FriendsAndFoesItems.TOTEM_OF_FREEZING.get()) {
                        serverPlayerEntity.m_36246_(Stats.f_12982_.m_12902_((Object)FriendsAndFoesItems.TOTEM_OF_FREEZING.get()));
                    } else if (totemItemStack.m_41720_() == FriendsAndFoesItems.TOTEM_OF_ILLUSION.get()) {
                        serverPlayerEntity.m_36246_(Stats.f_12982_.m_12902_((Object)FriendsAndFoesItems.TOTEM_OF_ILLUSION.get()));
                    }
                    CriteriaTriggers.f_10551_.m_74431_(serverPlayerEntity, totemItemStack);
                }
                this.m_21219_();
                if (totemItemStack.m_41720_() == FriendsAndFoesItems.TOTEM_OF_FREEZING.get()) {
                    this.friendsandfoes_freezeEntities();
                    this.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 200, 1));
                } else if (totemItemStack.m_41720_() == FriendsAndFoesItems.TOTEM_OF_ILLUSION.get()) {
                    this.friendsandfoes_createIllusions();
                }
                TotemHelper.sendTotemEffectPacket(totemItemStack, this);
                totemItemStack.m_41774_(1);
                cir.setReturnValue((Object)true);
            }
        }
    }

    private static boolean isTotem(ItemStack itemStack) {
        return itemStack.m_204117_(FriendsAndFoesTags.TOTEMS);
    }

    private void friendsandfoes_freezeEntities() {
        List nearbyEntities = this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(9.0), livingEntity -> FREEZE_TARGET_PREDICATE.m_26885_((LivingEntity)this, livingEntity));
        nearbyEntities.forEach(nearbyEntity -> {
            nearbyEntity.m_146917_(400);
            nearbyEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 400, 1));
        });
    }

    private void friendsandfoes_createIllusions() {
        this.m_5496_(FriendsAndFoesSoundEvents.ENTITY_PLAYER_MIRROR_MOVE.get(), this.m_6121_(), this.m_6100_());
        Vec3 illusionerPosition = this.m_20182_();
        float slice = 0.69813174f;
        int radius = 9;
        int randomPoint = this.m_217043_().m_216332_(0, 8);
        ArrayList<PlayerIllusionEntity> createdPlayerIllusions = new ArrayList<PlayerIllusionEntity>();
        for (int point = 0; point < 9; ++point) {
            float angle = slice * (float)point;
            int x = (int)(illusionerPosition.m_7096_() + (double)((float)radius * Mth.m_14089_((float)angle)));
            int y = (int)illusionerPosition.m_7098_();
            int z = (int)(illusionerPosition.m_7094_() + (double)((float)radius * Mth.m_14031_((float)angle)));
            if (randomPoint == point) {
                boolean teleportResult = this.friendsandfoes_tryToTeleport(x, y, z);
                if (!teleportResult) continue;
                this.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 200));
                this.friendsandfoes_spawnCloudParticles();
                continue;
            }
            PlayerIllusionEntity createdPlayerIllusion = this.friendsandfoes_createIllusion(x, y, z);
            if (createdPlayerIllusion == null) continue;
            createdPlayerIllusions.add(createdPlayerIllusion);
        }
        List nearbyEntities = this.m_9236_().m_6443_(Mob.class, this.m_20191_().m_82400_(18.0), mobEntity -> ATTACK_TARGET_PREDICATE.m_26885_((LivingEntity)this, (LivingEntity)mobEntity));
        nearbyEntities.forEach(nearbyEntity -> {
            if (nearbyEntity.m_5448_() == this) {
                nearbyEntity.m_6710_((LivingEntity)createdPlayerIllusions.get(this.m_217043_().m_188503_(createdPlayerIllusions.size())));
                nearbyEntity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 400, 1));
            }
        });
    }

    @Nullable
    private PlayerIllusionEntity friendsandfoes_createIllusion(int x, int y, int z) {
        float randomYaw;
        PlayerIllusionEntity playerIllusion = (PlayerIllusionEntity)FriendsAndFoesEntityTypes.PLAYER_ILLUSION.get().m_20615_(this.m_9236_());
        if (playerIllusion == null) {
            return null;
        }
        playerIllusion.prevCapeX = this.f_36102_;
        playerIllusion.prevCapeY = this.f_36103_;
        playerIllusion.prevCapeZ = this.f_36104_;
        playerIllusion.capeX = this.f_36105_;
        playerIllusion.capeY = this.f_36106_;
        playerIllusion.capeZ = this.f_36075_;
        playerIllusion.prevStrideDistance = this.f_36099_;
        playerIllusion.strideDistance = this.f_36100_;
        playerIllusion.m_8061_(EquipmentSlot.MAINHAND, this.m_21205_());
        playerIllusion.m_8061_(EquipmentSlot.OFFHAND, this.m_21206_());
        this.m_6168_().forEach(arg_0 -> ((PlayerIllusionEntity)playerIllusion).m_255207_(arg_0));
        playerIllusion.m_21153_(this.m_21233_());
        playerIllusion.m_20359_((Entity)this);
        playerIllusion.f_19859_ = randomYaw = 360.0f * this.m_217043_().m_188501_();
        playerIllusion.m_146922_(randomYaw);
        playerIllusion.f_20884_ = randomYaw;
        playerIllusion.m_5618_(randomYaw);
        playerIllusion.f_20886_ = randomYaw;
        playerIllusion.m_5616_(randomYaw);
        playerIllusion.setPlayerUuid(this.m_20148_());
        playerIllusion.setPlayer((Player)this);
        playerIllusion.setTicksUntilDespawn(600);
        boolean teleportResult = playerIllusion.tryToTeleport(x, y, z);
        if (teleportResult) {
            this.m_9236_().m_7967_((Entity)playerIllusion);
            playerIllusion.spawnCloudParticles();
        }
        return playerIllusion;
    }

    private boolean friendsandfoes_tryToTeleport(int x, int y, int z) {
        double bottomY = Math.max(y -= 8, this.m_9236_().m_141937_());
        double topY = Math.min(bottomY + 16.0, (double)(((ServerLevel)this.m_9236_()).m_143344_() - 1));
        for (int i = 0; i < 16; ++i) {
            boolean teleportResult = this.m_20984_(x, y = (int)Mth.m_14008_((double)(y + 1), (double)bottomY, (double)topY), z, false);
            if (!teleportResult) continue;
            return true;
        }
        return false;
    }

    private void friendsandfoes_spawnCloudParticles() {
        this.friendsandfoes_spawnParticles(ParticleTypes.f_123796_, 16);
    }

    private void friendsandfoes_spawnParticles(SimpleParticleType particleType, int amount) {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        for (int i = 0; i < amount; ++i) {
            ((ServerLevel)this.m_20193_()).m_8767_((ParticleOptions)particleType, this.m_20208_(0.5), this.m_20187_() + 0.5, this.m_20262_(0.5), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

