/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.mixin;

import com.faboslav.friendsandfoes.FriendsAndFoes;
import com.faboslav.friendsandfoes.entity.IllusionerEntityAccess;
import com.faboslav.friendsandfoes.mixin.BlindTargetGoalFactory;
import com.faboslav.friendsandfoes.mixin.IllusionerSpellcastingIllagerEntityMixin;
import com.llamalad7.mixinextras.injector.WrapWithCondition;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Illusioner;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Illusioner.class})
public abstract class IllusionerEntityMixin
extends IllusionerSpellcastingIllagerEntityMixin
implements RangedAttackMob,
IllusionerEntityAccess {
    private static final int MAX_ILLUSIONS_COUNT = 9;
    private static final int ILLUSION_LIFETIME_TICKS = 600;
    private static final int INVISIBILITY_TICKS = 60;
    private static final String IS_ILLUSION_NBT_NAME = "IsIllusion";
    private static final String WAS_ATTACKED_NBT_NAME = "WasAttacked";
    private static final String TICKS_UNTIL_DESPAWN_NBT_NAME = "TicksUntilDespawn";
    private static final String TICKS_UNTIL_CAN_CREATE_ILLUSIONS_NBT_NAME = "TicksUntilCanCreateIllusions";
    private static final EntityDataAccessor<Boolean> IS_ILLUSION = SynchedEntityData.m_135353_(IllusionerEntityMixin.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> WAS_ATTACKED = SynchedEntityData.m_135353_(IllusionerEntityMixin.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> TICKS_UNTIL_DESPAWN = SynchedEntityData.m_135353_(IllusionerEntityMixin.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TICKS_UNTIL_CAN_CREATE_ILLUSIONS = SynchedEntityData.m_135353_(IllusionerEntityMixin.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private Illusioner friendsandfoes_illusioner = null;

    protected IllusionerEntityMixin(EntityType<? extends SpellcasterIllager> entityType, Level world) {
        super((EntityType<? extends AbstractIllager>)entityType, world);
    }

    @Inject(method={"initDataTracker"}, at={@At(value="TAIL")})
    public void friendsandfoes_initDataTracker(CallbackInfo ci) {
        if (FriendsAndFoes.getConfig().enableIllusioner) {
            this.f_19804_.m_135372_(IS_ILLUSION, (Object)false);
            this.f_19804_.m_135372_(WAS_ATTACKED, (Object)false);
            this.f_19804_.m_135372_(TICKS_UNTIL_DESPAWN, (Object)0);
            this.f_19804_.m_135372_(TICKS_UNTIL_CAN_CREATE_ILLUSIONS, (Object)0);
        }
    }

    @Override
    public void friendsandfoes_writeCustomDataToNbt(CompoundTag nbt, CallbackInfo ci) {
        if (FriendsAndFoes.getConfig().enableIllusioner) {
            nbt.m_128379_(IS_ILLUSION_NBT_NAME, this.friendsandfoes_isIllusion());
            nbt.m_128379_(WAS_ATTACKED_NBT_NAME, this.friendsandfoes_wasAttacked());
            nbt.m_128405_(TICKS_UNTIL_DESPAWN_NBT_NAME, this.friendsandfoes_getTicksUntilDespawn());
            nbt.m_128405_(TICKS_UNTIL_CAN_CREATE_ILLUSIONS_NBT_NAME, this.friendsandfoes_getTicksUntilCanCreateIllusions());
        }
    }

    @Override
    public void friendsandfoes_readCustomDataFromNbt(CompoundTag nbt, CallbackInfo ci) {
        if (FriendsAndFoes.getConfig().enableIllusioner) {
            this.friendsandfoes_setIsIllusion(nbt.m_128471_(IS_ILLUSION_NBT_NAME));
            this.friendsandfoes_setWasAttacked(nbt.m_128471_(WAS_ATTACKED_NBT_NAME));
            this.friendsandfoes_setTicksUntilDespawn(nbt.m_128451_(TICKS_UNTIL_DESPAWN_NBT_NAME));
            this.friendsandfoes_setTicksUntilCanCreateIllusions(nbt.m_128451_(TICKS_UNTIL_CAN_CREATE_ILLUSIONS_NBT_NAME));
        }
    }

    @ModifyArg(method={"initGoals"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/ai/goal/GoalSelector;add(ILnet/minecraft/entity/ai/goal/Goal;)V", ordinal=1), slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/entity/mob/IllusionerEntity$GiveInvisibilityGoal;<init>(Lnet/minecraft/entity/mob/IllusionerEntity;)V")), index=1)
    private Goal replaceBlindTargetGoal(Goal original) {
        return BlindTargetGoalFactory.newBlindTargetGoal((Illusioner)this);
    }

    @WrapWithCondition(method={"initGoals"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/ai/goal/GoalSelector;add(ILnet/minecraft/entity/ai/goal/Goal;)V", ordinal=1)}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/entity/mob/IllusionerEntity$GiveInvisibilityGoal;<init>(Lnet/minecraft/entity/mob/IllusionerEntity;)V"))})
    private boolean shouldReplaceBlindTargetGoal(GoalSelector instance, int priority, Goal goal) {
        return !FriendsAndFoes.getConfig().enableIllusioner || !this.friendsandfoes_isIllusion();
    }

    @ModifyArg(method={"initGoals"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/ai/goal/GoalSelector;add(ILnet/minecraft/entity/ai/goal/Goal;)V", ordinal=2), slice=@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/entity/ai/goal/SwimGoal;<init>(Lnet/minecraft/entity/mob/MobEntity;)V")), index=1)
    private Goal replaceWithFleeGoal(Goal original) {
        return new AvoidEntityGoal((PathfinderMob)((Illusioner)this), IronGolem.class, 8.0f, 0.6, 1.0);
    }

    @Inject(at={@At(value="TAIL")}, method={"tickMovement"})
    public void tickMovement(CallbackInfo ci) {
        boolean isIllusionerNonExistingOrDead;
        if (!FriendsAndFoes.getConfig().enableIllusioner) {
            return;
        }
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (this.friendsandfoes_getTicksUntilCanCreateIllusions() > 0) {
            this.friendsandfoes_setTicksUntilCanCreateIllusions(this.friendsandfoes_getTicksUntilCanCreateIllusions() - 1);
        }
        if ((this.m_5448_() instanceof Player || this.m_5448_() instanceof IronGolem) && this.friendsandfoes_wasAttacked() && this.friendsandfoes_getTicksUntilCanCreateIllusions() == 0) {
            this.friendsandfoes_createIllusions();
        }
        if (this.friendsandfoes_wasAttacked() && this.m_5448_() == null && this.friendsandfoes_getTicksUntilCanCreateIllusions() < 200) {
            this.friendsandfoes_setWasAttacked(false);
            this.friendsandfoes_setTicksUntilCanCreateIllusions(0);
        }
        if (!this.friendsandfoes_isIllusion()) {
            return;
        }
        if (this.friendsandfoes_getTicksUntilDespawn() > 0) {
            this.friendsandfoes_setTicksUntilDespawn(this.friendsandfoes_getTicksUntilDespawn() - 1);
        }
        boolean bl = isIllusionerNonExistingOrDead = this.friendsandfoes_getIllusioner() != null && !this.friendsandfoes_getIllusioner().m_6084_();
        if (this.friendsandfoes_getTicksUntilDespawn() == 0 || isIllusionerNonExistingOrDead) {
            this.friendsandfoes_discardIllusion();
        }
    }

    @Override
    protected void friendsandfoes_shouldDropXp(CallbackInfoReturnable<Boolean> cir) {
        if (FriendsAndFoes.getConfig().enableIllusioner) {
            cir.setReturnValue((Object)(!this.friendsandfoes_isIllusion() ? 1 : 0));
        }
    }

    @Override
    protected void friendsandfoes_shouldDropLoot(CallbackInfoReturnable<Boolean> cir) {
        if (FriendsAndFoes.getConfig().enableIllusioner) {
            cir.setReturnValue((Object)(!this.friendsandfoes_isIllusion() ? 1 : 0));
        }
    }

    @Override
    public void friendsandfoes_damage(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (FriendsAndFoes.getConfig().enableIllusioner) {
            Entity attacker = source.m_7639_();
            if (attacker instanceof Illusioner || this.friendsandfoes_isIllusion() && !(attacker instanceof LivingEntity)) {
                cir.setReturnValue((Object)false);
                return;
            }
            if (!(this.m_9236_().m_5776_() || attacker instanceof Player && this.friendsandfoes_isIllusion() && ((Player)attacker).m_150110_().f_35937_)) {
                if (this.friendsandfoes_isIllusion()) {
                    this.friendsandfoes_discardIllusion();
                    cir.setReturnValue((Object)false);
                    return;
                }
                if ((attacker instanceof Player || attacker instanceof IronGolem) && this.friendsandfoes_getTicksUntilCanCreateIllusions() == 0) {
                    this.friendsandfoes_createIllusions();
                }
            }
        }
    }

    private void friendsandfoes_discardIllusion() {
        this.friendsandfoes_playMirrorSound();
        this.friendsandfoes_spawnCloudParticles();
        this.m_146870_();
    }

    private void friendsandfoes_createIllusions() {
        this.friendsandfoes_setWasAttacked(true);
        this.friendsandfoes_setTicksUntilCanCreateIllusions(600);
        this.friendsandfoes_playMirrorSound();
        Vec3 illusionerPosition = this.m_20182_();
        float slice = 0.69813174f;
        int radius = 9;
        int randomPoint = this.m_217043_().m_216332_(0, 8);
        for (int point = 0; point < 9; ++point) {
            float angle = slice * (float)point;
            int x = (int)(illusionerPosition.m_7096_() + (double)((float)radius * Mth.m_14089_((float)angle)));
            int y = (int)illusionerPosition.m_7098_();
            int z = (int)(illusionerPosition.m_7094_() + (double)((float)radius * Mth.m_14031_((float)angle)));
            if (randomPoint == point) {
                boolean teleportResult = this.friendsandfoes_tryToTeleport(x, y, z);
                if (!teleportResult) continue;
                this.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 60));
                this.friendsandfoes_spawnCloudParticles();
                continue;
            }
            this.friendsandfoes_createIllusion(x, y, z);
        }
    }

    private void friendsandfoes_createIllusion(int x, int y, int z) {
        Illusioner illusioner = (Illusioner)this;
        Illusioner illusion = (Illusioner)EntityType.f_20459_.m_20615_(this.m_9236_());
        illusion.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
        IllusionerEntityAccess illusionerAccess = (IllusionerEntityAccess)illusion;
        illusionerAccess.friendsandfoes_setIsIllusion(true);
        illusionerAccess.friendsandfoes_setIllusioner(illusioner);
        illusionerAccess.friendsandfoes_setTicksUntilDespawn(600);
        illusion.m_21153_(this.m_21233_());
        illusion.m_20359_((Entity)illusioner);
        illusion.m_6710_(illusioner.m_5448_());
        boolean teleportResult = illusionerAccess.friendsandfoes_tryToTeleport(x, y, z);
        if (teleportResult) {
            this.m_20193_().m_7967_((Entity)illusion);
            illusionerAccess.friendsandfoes_spawnCloudParticles();
        }
    }

    @Override
    public boolean friendsandfoes_tryToTeleport(int x, int y, int z) {
        double bottomY = Math.max(y -= 8, this.m_9236_().m_141937_());
        double topY = Math.min(bottomY + 16.0, (double)(((ServerLevel)this.m_9236_()).m_143344_() - 1));
        for (int i = 0; i < 16; ++i) {
            boolean teleportResult = this.m_20984_(x, y = (int)Mth.m_14008_((double)(y + 1), (double)bottomY, (double)topY), z, false);
            if (!teleportResult) continue;
            return true;
        }
        return false;
    }

    private void friendsandfoes_playMirrorSound() {
        this.m_5496_(SoundEvents.f_12052_, this.m_6121_(), this.m_6100_());
    }

    @Override
    public void friendsandfoes_spawnCloudParticles() {
        this.friendsandfoes_spawnParticles(ParticleTypes.f_123796_, 16);
    }

    private void friendsandfoes_spawnParticles(SimpleParticleType particleType, int amount) {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        for (int i = 0; i < amount; ++i) {
            ((ServerLevel)this.m_20193_()).m_8767_((ParticleOptions)particleType, this.m_20208_(0.5), this.m_20187_() + 0.5, this.m_20262_(0.5), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public boolean friendsandfoes_isIllusion() {
        return (Boolean)this.f_19804_.m_135370_(IS_ILLUSION);
    }

    @Override
    public void friendsandfoes_setIsIllusion(boolean isIllusion) {
        this.f_19804_.m_135381_(IS_ILLUSION, (Object)isIllusion);
    }

    public boolean friendsandfoes_wasAttacked() {
        return (Boolean)this.f_19804_.m_135370_(WAS_ATTACKED);
    }

    public void friendsandfoes_setWasAttacked(boolean wasAttacked) {
        this.f_19804_.m_135381_(WAS_ATTACKED, (Object)wasAttacked);
    }

    @Nullable
    public Illusioner friendsandfoes_getIllusioner() {
        return this.friendsandfoes_illusioner;
    }

    @Override
    public void friendsandfoes_setIllusioner(Illusioner illusioner) {
        this.friendsandfoes_illusioner = illusioner;
    }

    public int friendsandfoes_getTicksUntilDespawn() {
        return (Integer)this.f_19804_.m_135370_(TICKS_UNTIL_DESPAWN);
    }

    @Override
    public void friendsandfoes_setTicksUntilDespawn(int ticksUntilDespawn) {
        this.f_19804_.m_135381_(TICKS_UNTIL_DESPAWN, (Object)ticksUntilDespawn);
    }

    public int friendsandfoes_getTicksUntilCanCreateIllusions() {
        return (Integer)this.f_19804_.m_135370_(TICKS_UNTIL_CAN_CREATE_ILLUSIONS);
    }

    public void friendsandfoes_setTicksUntilCanCreateIllusions(int ticksUntilCanCreateIllusions) {
        this.f_19804_.m_135381_(TICKS_UNTIL_CAN_CREATE_ILLUSIONS, (Object)ticksUntilCanCreateIllusions);
    }
}

