/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.forge;

import com.faboslav.friendsandfoes.FriendsAndFoes;
import com.faboslav.friendsandfoes.FriendsAndFoesClient;
import com.faboslav.friendsandfoes.init.FriendsAndFoesEntityTypes;
import com.faboslav.friendsandfoes.init.FriendsAndFoesStructurePoolElements;
import com.faboslav.friendsandfoes.network.PacketHandler;
import com.faboslav.friendsandfoes.platform.forge.RegistryHelperImpl;
import com.faboslav.friendsandfoes.util.CustomRaidMember;
import com.faboslav.friendsandfoes.util.ServerWorldSpawnersUtil;
import com.faboslav.friendsandfoes.util.UpdateChecker;
import com.faboslav.friendsandfoes.world.spawner.IceologerSpawner;
import com.faboslav.friendsandfoes.world.spawner.IllusionerSpawner;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;

@Mod(value="friendsandfoes")
public final class FriendsAndFoesForge {
    public FriendsAndFoesForge() {
        UpdateChecker.checkForNewUpdates();
        FriendsAndFoes.init();
        PacketHandler.registerMessages();
        if (FMLEnvironment.dist == Dist.CLIENT) {
            FriendsAndFoesClient.init();
        }
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        RegistryHelperImpl.ACTIVITIES.register(bus);
        RegistryHelperImpl.BLOCKS.register(bus);
        FriendsAndFoesEntityTypes.previousUseChoiceTypeRegistrations = SharedConstants.f_136182_;
        SharedConstants.f_136182_ = false;
        RegistryHelperImpl.ENTITY_TYPES.register(bus);
        SharedConstants.f_136182_ = FriendsAndFoesEntityTypes.previousUseChoiceTypeRegistrations;
        RegistryHelperImpl.ITEMS.register(bus);
        RegistryHelperImpl.MEMORY_MODULE_TYPES.register(bus);
        RegistryHelperImpl.PARTICLE_TYPES.register(bus);
        RegistryHelperImpl.POINT_OF_INTEREST_TYPES.register(bus);
        RegistryHelperImpl.SOUND_EVENTS.register(bus);
        RegistryHelperImpl.STRUCTURE_TYPES.register(bus);
        RegistryHelperImpl.STRUCTURE_PROCESSOR_TYPES.register(bus);
        RegistryHelperImpl.VILLAGER_PROFESSIONS.register(bus);
        bus.addListener(FriendsAndFoesForge::init);
        bus.addListener(FriendsAndFoesForge::registerEntityAttributes);
        bus.addListener(FriendsAndFoesForge::addItemsToTabs);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(FriendsAndFoesForge::initSpawners);
        forgeBus.addListener(FriendsAndFoesForge::initTickDeltaCounter);
        forgeBus.addListener(FriendsAndFoesForge::onServerAboutToStartEvent);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            FriendsAndFoes.postInit();
            if (FriendsAndFoes.getConfig().enableIceologer && FriendsAndFoes.getConfig().enableIceologerInRaids) {
                Raid.RaiderType.create((String)"ICEOLOGER", FriendsAndFoesEntityTypes.ICEOLOGER.get(), (int[])CustomRaidMember.ICEOLOGER_COUNT_IN_WAVE);
            }
            if (FriendsAndFoes.getConfig().enableIllusioner && FriendsAndFoes.getConfig().enableIllusionerInRaids) {
                Raid.RaiderType.create((String)"ILLUSIONER", (EntityType)EntityType.f_20459_, (int[])CustomRaidMember.ILLUSIONER_COUNT_IN_WAVE);
            }
        });
    }

    private static void registerEntityAttributes(EntityAttributeCreationEvent event) {
        for (Map.Entry<Supplier<? extends EntityType<? extends LivingEntity>>, Supplier<AttributeSupplier.Builder>> entry : RegistryHelperImpl.ENTITY_ATTRIBUTES.entrySet()) {
            event.put(entry.getKey().get(), entry.getValue().get().m_22265_());
        }
    }

    private static void addItemsToTabs(BuildCreativeModeTabContentsEvent event) {
        RegistryHelperImpl.ITEMS_TO_ADD_BEFORE.forEach((itemGroup, itemPairs) -> {
            if (event.getTabKey() == itemGroup) {
                itemPairs.forEach((item, before) -> event.getEntries().putBefore((Object)before.m_7968_(), (Object)item.m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS));
            }
        });
        RegistryHelperImpl.ITEMS_TO_ADD_AFTER.forEach((itemGroup, itemPairs) -> {
            if (event.getTabKey() == itemGroup) {
                itemPairs.forEach((item, after) -> event.getEntries().putAfter((Object)after.m_7968_(), (Object)item.m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS));
            }
        });
    }

    private static void initSpawners(LevelEvent.Load event) {
        if (event.getLevel().m_5776_() || ((ServerLevel)event.getLevel()).m_220362_() != BuiltinDimensionTypes.f_223538_) {
            return;
        }
        MinecraftServer server = event.getLevel().m_7654_();
        if (server == null) {
            return;
        }
        ServerLevel world = server.m_129783_();
        if (world == null) {
            return;
        }
        ServerWorldSpawnersUtil.register(world, new IceologerSpawner());
        ServerWorldSpawnersUtil.register(world, new IllusionerSpawner());
    }

    private static void initTickDeltaCounter(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        FriendsAndFoes.serverTickDeltaCounter.beginRenderTick(Util.m_137550_());
    }

    public static void onServerAboutToStartEvent(ServerAboutToStartEvent event) {
        FriendsAndFoesStructurePoolElements.init(event.getServer());
    }
}

