/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.entity.ai.goal.glare;

import com.faboslav.friendsandfoes.entity.GlareEntity;
import com.faboslav.friendsandfoes.util.particle.ParticleSpawner;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.Path;
import org.jetbrains.annotations.Nullable;

public final class GlareFlyToDarkSpotGoal
extends Goal {
    public boolean isRunning = false;
    private final double DARK_SPOT_SEARCH_DISTANCE = 8.0;
    private final GlareEntity glare;
    private BlockPos darkSpot;
    private Path currentPath;
    private int runTicks;
    private int grumpyTicks;

    public GlareFlyToDarkSpotGoal(GlareEntity glareEntity) {
        this.glare = glareEntity;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        Level world = this.glare.m_9236_();
        if (this.glare.getTicksUntilCanFindDarkSpot() > 0 || this.glare.m_217043_().m_188503_(10) != 0 || this.glare.m_21523_() || this.glare.m_21827_() || !this.glare.m_21824_() || this.glare.m_6162_() || world.m_46461_() && world.m_45527_(this.glare.m_20183_())) {
            return false;
        }
        ArrayList<BlockPos> darkSpots = this.findDarkSpots(8.0);
        this.darkSpot = this.getRandomDarkSpot(darkSpots);
        return this.darkSpot != null;
    }

    public boolean m_8045_() {
        if (this.runTicks >= 1200 || this.darkSpot == null || this.grumpyTicks >= 120) {
            return false;
        }
        return this.glare.m_9236_().m_45517_(LightLayer.BLOCK, this.darkSpot) == 0;
    }

    public void m_8056_() {
        this.isRunning = true;
        this.grumpyTicks = 0;
        this.runTicks = 0;
    }

    public void m_8041_() {
        this.glare.playGrumpinessShortSound();
        this.darkSpot = null;
        this.currentPath = null;
        this.glare.setTicksUntilCanFindDarkSpot(this.glare.generateRandomTicksUntilCanFindDarkSpot());
        this.glare.setGrumpy(false);
        this.isRunning = false;
    }

    public void m_8037_() {
        ++this.runTicks;
        PathNavigation navigation = this.glare.m_21573_();
        double distanceToDarkSpot = this.glare.m_20182_().m_82531_((double)this.darkSpot.m_123341_(), (double)this.darkSpot.m_123342_(), (double)this.darkSpot.m_123343_());
        this.currentPath = navigation.m_26524_((double)this.darkSpot.m_123341_(), (double)this.darkSpot.m_123342_(), (double)this.darkSpot.m_123343_(), 0);
        if (this.currentPath != null) {
            this.glare.m_21573_().m_26536_(this.currentPath, (double)this.glare.m_6113_());
        }
        if (distanceToDarkSpot >= 1.0) {
            if (this.glare.isGrumpy()) {
                this.glare.setGrumpy(false);
            }
            return;
        }
        LivingEntity owner = this.glare.m_269323_();
        if (owner == null) {
            return;
        }
        ++this.grumpyTicks;
        if (!this.glare.isGrumpy()) {
            this.glare.setGrumpy(true);
        }
        if (this.grumpyTicks == 10) {
            this.glare.playGrumpinessSound();
        }
        if (this.grumpyTicks % 5 == 0) {
            this.glare.playRustleSound();
        }
        if (this.grumpyTicks % 10 == 0) {
            BlockParticleOption particleEffect = new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_152541_.m_49966_());
            ParticleSpawner.spawnParticles((LivingEntity)this.glare, (ParticleOptions)particleEffect, 7, 0.1);
        }
        this.glare.m_21563_().m_24964_(owner.m_20182_());
    }

    private ArrayList<BlockPos> findDarkSpots(double searchDistance) {
        ServerLevel serverWorld = (ServerLevel)this.glare.m_20193_();
        BlockPos blockPos = this.glare.m_20183_();
        ArrayList<BlockPos> darkSpots = new ArrayList<BlockPos>();
        int i = 0;
        while ((double)i <= searchDistance) {
            int j = 0;
            while ((double)j < searchDistance) {
                int k = 0;
                while (k <= j) {
                    int l;
                    int n = l = k < j && k > -j ? j : 0;
                    while (l <= j) {
                        boolean isBlockAccessible;
                        BlockPos.MutableBlockPos possibleDarkSpotBlockPos = new BlockPos.MutableBlockPos();
                        possibleDarkSpotBlockPos.m_122154_((Vec3i)blockPos, k, i - 1, l);
                        boolean isBlockWithinDistance = blockPos.m_123314_((Vec3i)possibleDarkSpotBlockPos, searchDistance);
                        boolean isSpotDarkEnough = this.glare.m_9236_().m_45517_(LightLayer.BLOCK, (BlockPos)possibleDarkSpotBlockPos) == 0;
                        boolean isBlockSolidSurface = serverWorld.m_8055_(possibleDarkSpotBlockPos.m_7495_()).m_60634_((BlockGetter)serverWorld, (BlockPos)possibleDarkSpotBlockPos, (Entity)this.glare);
                        boolean bl = isBlockAccessible = serverWorld.m_46859_((BlockPos)possibleDarkSpotBlockPos) && serverWorld.m_46859_(possibleDarkSpotBlockPos.m_7494_());
                        if (isBlockWithinDistance && isBlockSolidSurface && isBlockAccessible && isSpotDarkEnough) {
                            darkSpots.add((BlockPos)possibleDarkSpotBlockPos);
                        }
                        l = l > 0 ? -l : 1 - l;
                    }
                    k = k > 0 ? -k : 1 - k;
                }
                ++j;
            }
            i = i > 0 ? -i : 1 - i;
        }
        return darkSpots;
    }

    @Nullable
    private BlockPos getRandomDarkSpot(ArrayList<BlockPos> darkSpots) {
        int darkSpotsCount = darkSpots.size();
        if (darkSpotsCount == 0) {
            return null;
        }
        int randomDarkSpotIndex = this.glare.m_217043_().m_188503_(darkSpotsCount);
        return darkSpots.get(randomDarkSpotIndex);
    }
}

