/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.entity.ai.goal.glare;

import com.faboslav.friendsandfoes.FriendsAndFoes;
import com.faboslav.friendsandfoes.entity.GlareEntity;
import com.faboslav.friendsandfoes.util.particle.ParticleSpawner;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;

public final class GlareEatGlowBerriesGoal
extends Goal {
    public boolean isRunning = false;
    private ItemEntity foodItemToPickUp;
    private int runTicks;
    private static final Predicate<ItemEntity> IS_PICKABLE_FOOD = itemEntity -> {
        Item item = itemEntity.m_32055_().m_41720_();
        return item == Items.f_151079_.m_5456_() && itemEntity.m_6084_() && !itemEntity.m_32063_();
    };
    private final GlareEntity glare;

    public GlareEatGlowBerriesGoal(GlareEntity glare) {
        this.glare = glare;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (!FriendsAndFoes.getConfig().enableGlareGriefing || this.glare.getTicksUntilCanEatGlowBerries() > 0 || this.glare.m_217043_().m_188503_(10) != 0 || this.glare.m_21523_() || this.glare.m_21827_() || !this.hasGlareEmptyHand()) {
            return false;
        }
        this.foodItemToPickUp = this.getFoodItemToPickUp();
        return this.foodItemToPickUp != null;
    }

    public void m_8056_() {
        this.runTicks = 0;
        this.isRunning = true;
        this.glare.m_21573_().m_5624_((Entity)this.foodItemToPickUp, (double)this.glare.m_6113_());
    }

    public boolean m_8045_() {
        return this.runTicks < 300 && this.foodItemToPickUp != null && GlareEntity.PICKABLE_FOOD_FILTER.test(this.foodItemToPickUp) && this.hasGlareEmptyHand();
    }

    public void m_8037_() {
        ++this.runTicks;
        this.glare.m_21573_().m_5624_((Entity)this.foodItemToPickUp, (double)this.glare.m_6113_());
        if (this.glare.m_217043_().m_188501_() < 0.05f) {
            this.glare.m_8032_();
        }
    }

    public void m_8041_() {
        ItemStack itemStack = this.glare.m_6844_(EquipmentSlot.MAINHAND);
        Item itemInHand = this.glare.m_6844_(EquipmentSlot.MAINHAND).m_41720_();
        if (!this.hasGlareEmptyHand() && itemInHand == Items.f_151079_) {
            ItemParticleOption particleEffect = new ItemParticleOption(ParticleTypes.f_123752_, itemStack);
            this.glare.m_5634_(itemStack.m_41720_().m_41473_().m_38744_());
            this.glare.playEatSound(itemStack);
            ParticleSpawner.spawnParticles((LivingEntity)this.glare, (ParticleOptions)particleEffect, 7, 0.1);
            this.glare.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        }
        this.isRunning = false;
        this.foodItemToPickUp = null;
        this.glare.setTicksUntilCanEatGlowBerries(this.glare.generateRandomTicksUntilCanEatGlowBerries());
        this.glare.setGrumpy(false);
    }

    @Nullable
    private ItemEntity getFoodItemToPickUp() {
        List foodItemsToPickUp = this.glare.m_9236_().m_6443_(ItemEntity.class, this.glare.m_20191_().m_82377_(8.0, 8.0, 8.0), IS_PICKABLE_FOOD);
        if (foodItemsToPickUp.isEmpty()) {
            return null;
        }
        return (ItemEntity)foodItemsToPickUp.get(this.glare.m_217043_().m_188503_(foodItemsToPickUp.size()));
    }

    private boolean hasGlareEmptyHand() {
        return this.glare.m_6844_(EquipmentSlot.MAINHAND).m_41619_();
    }
}

