/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.entity;

import com.faboslav.friendsandfoes.FriendsAndFoes;
import com.faboslav.friendsandfoes.entity.ai.brain.WildfireBrain;
import com.faboslav.friendsandfoes.init.FriendsAndFoesSoundEvents;
import com.faboslav.friendsandfoes.tag.FriendsAndFoesTags;
import com.mojang.serialization.Dynamic;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import org.jetbrains.annotations.Nullable;

public final class WildfireEntity
extends Monster {
    private float damageAmountCounter = 0.0f;
    public static final float GENERIC_ATTACK_DAMAGE = 8.0f;
    public static final float GENERIC_FOLLOW_RANGE = 32.0f;
    public static final int DEFAULT_ACTIVE_SHIELDS_COUNT = 4;
    public static final int DEFAULT_TICKS_UNTIL_SHIELD_REGENERATION = 300;
    public static final int DEFAULT_SUMMONED_BLAZES_COUNT = 0;
    public static final int MAXIMUM_SUMMONED_BLAZES_COUNT = 2;
    private static final String ACTIVE_SHIELDS_NBT_NAME = "ActiveShieldsCount";
    private static final String TICKS_UNTIL_SHIELD_REGENERATION_NBT_NAME = "TicksUntilShieldRegeneration";
    private static final String SUMMONED_BLAZES_COUNT_NBT_NAME = "SummonedBlazesCount";
    private static final EntityDataAccessor<Integer> ACTIVE_SHIELDS_COUNT = SynchedEntityData.m_135353_(WildfireEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TICKS_UNTIL_SHIELD_REGENERATION = SynchedEntityData.m_135353_(WildfireEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SUMMONED_BLAZES_COUNT = SynchedEntityData.m_135353_(WildfireEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public WildfireEntity(EntityType<? extends WildfireEntity> entityType, Level world) {
        super(entityType, world);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.LAVA, 8.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.f_21364_ = 10;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        this.setActiveShieldsCount(4);
        this.setSummonedBlazesCount(0);
        return super.m_6518_(world, difficulty, spawnReason, entityData, entityNbt);
    }

    protected Brain<?> m_8075_(Dynamic<?> dynamic) {
        return WildfireBrain.create(dynamic);
    }

    public Brain<WildfireEntity> m_6274_() {
        return super.m_6274_();
    }

    protected void m_8024_() {
        this.m_9236_().m_46473_().m_6180_("wildfireBrain");
        this.m_6274_().m_21865_((ServerLevel)this.m_9236_(), (LivingEntity)this);
        this.m_9236_().m_46473_().m_7238_();
        this.m_9236_().m_46473_().m_6180_("wildfireActivityUpdate");
        WildfireBrain.updateActivities(this);
        this.m_9236_().m_46473_().m_7238_();
        super.m_8024_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 120.0).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22282_, 32.0).m_22268_(Attributes.f_22279_, (double)0.23f).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ACTIVE_SHIELDS_COUNT, (Object)4);
        this.f_19804_.m_135372_(TICKS_UNTIL_SHIELD_REGENERATION, (Object)300);
        this.f_19804_.m_135372_(SUMMONED_BLAZES_COUNT, (Object)0);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_(ACTIVE_SHIELDS_NBT_NAME, this.getActiveShieldsCount());
        nbt.m_128405_(TICKS_UNTIL_SHIELD_REGENERATION_NBT_NAME, this.getTicksUntilShieldRegeneration());
        nbt.m_128405_(SUMMONED_BLAZES_COUNT_NBT_NAME, this.getSummonedBlazesCount());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setActiveShieldsCount(nbt.m_128451_(ACTIVE_SHIELDS_NBT_NAME));
        this.setTicksUntilShieldRegeneration(nbt.m_128451_(TICKS_UNTIL_SHIELD_REGENERATION_NBT_NAME));
        this.setSummonedBlazesCount(nbt.m_128451_(SUMMONED_BLAZES_COUNT_NBT_NAME));
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        if (state.m_278721_()) {
            return;
        }
        BlockState blockState = this.m_9236_().m_8055_(pos.m_7494_());
        SoundType blockSoundGroup = blockState.m_204336_(BlockTags.f_144271_) ? blockState.m_60827_() : state.m_60827_();
        this.m_5496_(FriendsAndFoesSoundEvents.ENTITY_WILDFIRE_STEP.get(), blockSoundGroup.m_56773_() * 0.15f, blockSoundGroup.m_56774_());
    }

    public SoundEvent getShootSound() {
        return FriendsAndFoesSoundEvents.ENTITY_WILDFIRE_SHOOT.get();
    }

    public void playShootSound() {
        this.m_5496_(this.getShootSound(), this.m_6121_(), this.m_6100_());
    }

    public SoundEvent getShockwaveSound() {
        return FriendsAndFoesSoundEvents.ENTITY_WILDFIRE_SHOCKWAVE.get();
    }

    public void playShockwaveSound() {
        this.m_5496_(this.getShockwaveSound(), this.m_6121_(), this.m_6100_());
    }

    public void breakShield() {
        this.setActiveShieldsCount(this.getActiveShieldsCount() - 1);
    }

    public void regenerateShield() {
        if (this.getActiveShieldsCount() >= 4) {
            return;
        }
        this.setActiveShieldsCount(this.getActiveShieldsCount() + 1);
    }

    public int getActiveShieldsCount() {
        return (Integer)this.f_19804_.m_135370_(ACTIVE_SHIELDS_COUNT);
    }

    public void setActiveShieldsCount(int activeShields) {
        this.f_19804_.m_135381_(ACTIVE_SHIELDS_COUNT, (Object)activeShields);
    }

    public boolean hasActiveShields() {
        return this.getActiveShieldsCount() > 0;
    }

    public int getTicksUntilShieldRegeneration() {
        return (Integer)this.f_19804_.m_135370_(TICKS_UNTIL_SHIELD_REGENERATION);
    }

    public void setTicksUntilShieldRegeneration(int ticksUntilShieldRegeneration) {
        this.f_19804_.m_135381_(TICKS_UNTIL_SHIELD_REGENERATION, (Object)ticksUntilShieldRegeneration);
    }

    public void resetTicksUntilShieldRegeneration() {
        this.setTicksUntilShieldRegeneration(300);
    }

    public int getSummonedBlazesCount() {
        return (Integer)this.f_19804_.m_135370_(SUMMONED_BLAZES_COUNT);
    }

    public void setSummonedBlazesCount(int summonedBlazesCount) {
        this.f_19804_.m_135381_(SUMMONED_BLAZES_COUNT, (Object)summonedBlazesCount);
    }

    public boolean areBlazesSummoned() {
        return this.getSummonedBlazesCount() > 0;
    }

    public SoundEvent getShieldBreakSound() {
        return FriendsAndFoesSoundEvents.ENTITY_WILDFIRE_SHIELD_BREAK.get();
    }

    public void playShieldBreakSound() {
        this.m_5496_(this.getShieldBreakSound(), this.m_6121_(), this.m_6100_());
    }

    protected SoundEvent m_7515_() {
        return FriendsAndFoesSoundEvents.ENTITY_WILDFIRE_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return FriendsAndFoesSoundEvents.ENTITY_WILDFIRE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return FriendsAndFoesSoundEvents.ENTITY_WILDFIRE_DEATH.get();
    }

    public SoundEvent getSummonBlazeSound() {
        return FriendsAndFoesSoundEvents.ENTITY_WILDFIRE_SUMMON_BLAZE.get();
    }

    public void playSummonBlazeSound() {
        this.m_5496_(this.getSummonBlazeSound(), this.m_6121_(), this.m_6100_());
    }

    public void m_8119_() {
        if (!FriendsAndFoes.getConfig().enableWildfire) {
            this.m_146870_();
        }
        super.m_8119_();
        this.setTicksUntilShieldRegeneration(this.getTicksUntilShieldRegeneration() - 1);
        if (this.getTicksUntilShieldRegeneration() == 0) {
            this.regenerateShield();
            this.resetTicksUntilShieldRegeneration();
        }
    }

    public void m_8107_() {
        if (!this.m_20096_() && this.m_20184_().f_82480_ < 0.0) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, (double)0.6f, 1.0));
        }
        if (this.m_9236_().m_5776_()) {
            if (this.m_217043_().m_188503_(24) == 0 && !this.m_20067_()) {
                this.m_9236_().m_7785_(this.m_20185_() + 0.5, this.m_20186_() + 0.5, this.m_20189_() + 0.5, SoundEvents.f_11702_, this.m_5720_(), 1.0f + this.m_217043_().m_188501_(), this.m_217043_().m_188501_() * 0.7f + 0.3f, false);
            }
            for (int i = 0; i < 2; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
        }
        super.m_8107_();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity attacker = source.m_7639_();
        if (source == this.m_269291_().m_269387_() || attacker == null || attacker.m_6095_().m_204039_(FriendsAndFoesTags.WILDFIRE_ALLIES)) {
            return false;
        }
        if (this.hasActiveShields()) {
            this.damageAmountCounter += amount;
            float shieldBreakDamageThreshold = (float)this.m_21133_(Attributes.f_22276_) * 0.25f;
            if (this.damageAmountCounter >= shieldBreakDamageThreshold) {
                attacker.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 8.0f);
                this.breakShield();
                this.playShieldBreakSound();
                this.damageAmountCounter = 0.0f;
            }
            amount = 0.0f;
        }
        this.resetTicksUntilShieldRegeneration();
        boolean damageResult = super.m_6469_(source, amount);
        if (damageResult && attacker instanceof LivingEntity) {
            WildfireBrain.onAttacked(this, (LivingEntity)attacker);
        }
        return damageResult;
    }

    public float m_213856_() {
        return 1.0f;
    }

    public boolean m_6126_() {
        return true;
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }
}

