/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.entity;

import com.faboslav.friendsandfoes.FriendsAndFoes;
import com.faboslav.friendsandfoes.api.MoobloomVariant;
import com.faboslav.friendsandfoes.api.MoobloomVariants;
import com.faboslav.friendsandfoes.init.FriendsAndFoesBlocks;
import com.faboslav.friendsandfoes.init.FriendsAndFoesEntityTypes;
import com.faboslav.friendsandfoes.init.FriendsAndFoesSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public final class MoobloomEntity
extends Cow
implements Shearable {
    private static final EntityDataAccessor<String> VARIANT = SynchedEntityData.m_135353_(MoobloomEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);

    public MoobloomEntity(EntityType<? extends Cow> entityType, Level world) {
        super(entityType, world);
    }

    public static boolean canSpawn(EntityType<MoobloomEntity> moobloomEntityType, ServerLevelAccessor serverWorldAccess, MobSpawnType spawnReason, BlockPos blockPos, RandomSource random) {
        return serverWorldAccess.m_8055_(blockPos.m_7495_()).m_60713_(Blocks.f_50440_) && MoobloomEntity.m_186209_((BlockAndTintGetter)serverWorldAccess, (BlockPos)blockPos);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        if (MoobloomVariants.getNumberOfVariants() > 1 && spawnReason != MobSpawnType.COMMAND) {
            this.setVariant(MoobloomVariants.getRandomVariant());
        }
        return super.m_6518_(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public boolean m_6220_() {
        return this.m_6084_() && !this.m_6162_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)"buttercup");
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128359_("Variant", this.getVariant().getName());
        nbt.m_128359_("Flower", this.getVariant().getFlowerName());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        String variantName = "buttercup";
        if (nbt.m_128441_("Variant") && MoobloomVariants.contains(nbt.m_128461_("Variant"))) {
            variantName = nbt.m_128461_("Variant");
        }
        this.setVariant(MoobloomVariants.getByName(variantName));
    }

    public void m_5851_(SoundSource shearedSoundCategory) {
        Level world = this.m_9236_();
        world.m_6269_(null, (Entity)this, SoundEvents.f_12075_, shearedSoundCategory, 1.0f, 1.0f);
        if (world.m_5776_()) {
            return;
        }
        ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20227_(0.5), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
        this.m_146870_();
        Cow cowEntity = (Cow)EntityType.f_20557_.m_20615_(world);
        if (cowEntity == null) {
            return;
        }
        cowEntity.m_21153_(this.m_21223_());
        cowEntity.m_20359_((Entity)this);
        cowEntity.f_20884_ = this.f_20884_;
        cowEntity.f_20883_ = this.f_20883_;
        cowEntity.f_20886_ = this.f_20886_;
        cowEntity.f_20885_ = this.f_20885_;
        if (this.m_8077_()) {
            cowEntity.m_6593_(this.m_7770_());
            cowEntity.m_20340_(this.m_20151_());
        }
        if (this.m_21532_()) {
            cowEntity.m_21530_();
        }
        cowEntity.m_20331_(this.m_20147_());
        world.m_7967_((Entity)cowEntity);
        for (int i = 0; i < 5; ++i) {
            world.m_7967_((Entity)new ItemEntity(world, this.m_20185_(), this.m_20227_(1.0), this.m_20189_(), new ItemStack((ItemLike)this.getVariant().getFlower())));
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        MoobloomVariant moobloomVariant = MoobloomVariants.getByFlowerItem(itemStack.m_41720_());
        if (moobloomVariant != null && moobloomVariant != this.getVariant()) {
            this.setVariant(moobloomVariant);
            this.m_5496_(FriendsAndFoesSoundEvents.ENTITY_MOOBLOOM_CONVERT.get(), 2.0f, 1.0f);
            boolean isClientWorld = this.m_9236_().m_5776_();
            if (!isClientWorld) {
                itemStack.m_41622_(1, (LivingEntity)player, playerx -> playerx.m_21190_(hand));
            }
            return InteractionResult.m_19078_((boolean)isClientWorld);
        }
        if (itemStack.m_41720_() == Items.f_42574_ && this.m_6220_()) {
            this.m_5851_(SoundSource.PLAYERS);
            this.m_146852_(GameEvent.f_157781_, (Entity)player);
            boolean isClientWorld = this.m_9236_().m_5776_();
            if (!isClientWorld) {
                itemStack.m_41622_(1, (LivingEntity)player, playerx -> playerx.m_21190_(hand));
            }
            return InteractionResult.m_19078_((boolean)isClientWorld);
        }
        return super.m_6071_(player, hand);
    }

    public MoobloomEntity createChild(ServerLevel serverWorld, AgeableMob entity) {
        MoobloomVariant moobloomVariant = this.getVariant();
        if (this.m_217043_().m_216332_(0, 1) == 0) {
            moobloomVariant = ((MoobloomEntity)entity).getVariant();
        }
        MoobloomEntity moobloom = (MoobloomEntity)FriendsAndFoesEntityTypes.MOOBLOOM.get().m_20615_((Level)serverWorld);
        moobloom.setVariant(moobloomVariant);
        return moobloom;
    }

    public void m_8107_() {
        Block blockUnderneath;
        super.m_8107_();
        if (this.m_9236_().m_5776_() || this.m_6162_()) {
            return;
        }
        if ((double)this.m_217043_().m_188501_() <= 1.6666666E-4 && (blockUnderneath = this.m_9236_().m_8055_(new BlockPos((int)this.m_20185_(), (int)this.m_20186_() - 1, (int)this.m_20189_())).m_60734_()) == Blocks.f_50440_ && this.m_9236_().m_46859_(this.m_20183_())) {
            BushBlock flower = this.getVariant().getFlower();
            if (MoobloomVariants.getNumberOfVariants() == 1) {
                int flowerChance = this.m_217043_().m_216332_(1, 100);
                if (flowerChance >= 0 && flowerChance < 40) {
                    this.m_9236_().m_46597_(this.m_20183_(), FriendsAndFoesBlocks.BUTTERCUP.get().m_49966_());
                } else if (flowerChance >= 40 && flowerChance < 80) {
                    this.m_9236_().m_46597_(this.m_20183_(), Blocks.f_50111_.m_49966_());
                } else {
                    BlockState sunflowerBlockState = (BlockState)Blocks.f_50355_.m_49966_().m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER);
                    this.m_9236_().m_46597_(this.m_20183_(), (BlockState)sunflowerBlockState.m_61122_((Property)BlockStateProperties.f_61401_));
                    this.m_9236_().m_46597_(this.m_20183_().m_7494_(), sunflowerBlockState);
                }
            } else if (flower instanceof DoublePlantBlock) {
                BlockState upperHalfBlockState = (BlockState)flower.m_49966_().m_61124_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER);
                this.m_9236_().m_46597_(this.m_20183_(), (BlockState)upperHalfBlockState.m_61122_((Property)BlockStateProperties.f_61401_));
                this.m_9236_().m_46597_(this.m_20183_().m_7494_(), upperHalfBlockState);
            } else {
                this.m_9236_().m_46597_(this.m_20183_(), flower.m_49966_());
            }
        }
    }

    public void m_8119_() {
        if (!FriendsAndFoes.getConfig().enableMoobloom) {
            this.m_146870_();
        }
        super.m_8119_();
    }

    private void setVariant(MoobloomVariant variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant.getName());
    }

    public MoobloomVariant getVariant() {
        return MoobloomVariants.getByName((String)this.f_19804_.m_135370_(VARIANT));
    }
}

