/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.client.render.entity.model;

import com.faboslav.friendsandfoes.client.render.entity.animation.animator.ModelPartAnimator;
import com.faboslav.friendsandfoes.client.render.entity.model.AnimatedEntityModel;
import com.faboslav.friendsandfoes.entity.GlareEntity;
import com.faboslav.friendsandfoes.util.animation.AnimationMath;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class GlareEntityModel<T extends GlareEntity>
extends AnimatedEntityModel<T> {
    private static final String MODEL_PART_ROOT = "root";
    private static final String MODEL_PART_HEAD = "head";
    private static final String MODEL_PART_EYES = "eyes";
    private static final String MODEL_TOP_AZALEA = "topAzalea";
    private static final String MODEL_BOTTOM_AZALEA = "bottomAzalea";
    private static final String MODEL_SECOND_LAYER = "secondLayer";
    private static final String MODEL_THIRD_LAYER = "thirdLayer";
    private static final String MODEL_FOURTH_LAYER = "fourthLayer";
    private final ModelPart head;
    private final ModelPart eyes;
    private final ModelPart topAzalea;
    private final ModelPart bottomAzalea;
    private final ModelPart secondLayer;
    private final ModelPart thirdLayer;
    private final ModelPart fourthLayer;
    private final ModelPart[] layers;

    public GlareEntityModel(ModelPart root) {
        super(root);
        this.head = this.root.m_171324_(MODEL_PART_HEAD);
        this.eyes = this.head.m_171324_(MODEL_PART_EYES);
        this.topAzalea = this.head.m_171324_(MODEL_TOP_AZALEA);
        this.bottomAzalea = this.head.m_171324_(MODEL_BOTTOM_AZALEA);
        this.secondLayer = this.bottomAzalea.m_171324_(MODEL_SECOND_LAYER);
        this.thirdLayer = this.secondLayer.m_171324_(MODEL_THIRD_LAYER);
        this.fourthLayer = this.thirdLayer.m_171324_(MODEL_FOURTH_LAYER);
        this.layers = new ModelPart[]{this.secondLayer, this.thirdLayer, this.fourthLayer};
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition root = modelData.m_171576_();
        root.m_171599_(MODEL_PART_HEAD, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-6.0f, 0.0f, -3.0f, 12.0f, 9.0f, 9.0f, new CubeDeformation(-0.02f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition head = root.m_171597_(MODEL_PART_HEAD);
        head.m_171599_(MODEL_PART_EYES, CubeListBuilder.m_171558_().m_171514_(36, 0).m_171488_(2.0f, -1.0f, -0.3f, 2.0f, 2.0f, 1.0f, new CubeDeformation(-0.29f)).m_171514_(36, 0).m_171488_(-4.0f, -1.0f, -0.3f, 2.0f, 2.0f, 1.0f, new CubeDeformation(-0.29f)), PartPose.m_171419_((float)0.0f, (float)5.0f, (float)-3.0f));
        head.m_171599_(MODEL_TOP_AZALEA, CubeListBuilder.m_171558_().m_171514_(72, 0).m_171488_(-7.0f, 0.0f, -7.0f, 14.0f, 8.0f, 14.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        head.m_171599_(MODEL_BOTTOM_AZALEA, CubeListBuilder.m_171558_().m_171514_(0, 114).m_171488_(-7.0f, 0.75f, -7.0f, 14.0f, 0.0f, 14.0f, new CubeDeformation(-0.01f)).m_171514_(72, 22).m_171488_(-7.0f, -4.0f, -7.0f, 14.0f, 10.0f, 14.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        PartDefinition bottomAzalea = head.m_171597_(MODEL_BOTTOM_AZALEA);
        bottomAzalea.m_171599_(MODEL_SECOND_LAYER, CubeListBuilder.m_171558_().m_171514_(80, 46).m_171488_(-6.0f, 0.0f, -6.0f, 12.0f, 7.0f, 12.0f, new CubeDeformation(0.01f)), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition secondLayer = bottomAzalea.m_171597_(MODEL_SECOND_LAYER);
        secondLayer.m_171599_(MODEL_THIRD_LAYER, CubeListBuilder.m_171558_().m_171514_(88, 65).m_171481_(-5.0f, 0.0f, -5.0f, 10.0f, 7.0f, 10.0f), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition thirdLayer = secondLayer.m_171597_(MODEL_THIRD_LAYER);
        thirdLayer.m_171599_(MODEL_FOURTH_LAYER, CubeListBuilder.m_171558_().m_171514_(96, 82).m_171481_(-4.0f, 0.0f, -4.0f, 8.0f, 7.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)128, (int)128);
    }

    public void setAngles(T glare, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.applyModelTransforms(MODEL_PART_ROOT, this.root);
        this.animateEyes(glare);
        this.animateHead(glare, animationProgress);
        this.animateLayers(glare, animationProgress);
    }

    public void animateModel(T glare, float limbAngle, float limbDistance, float tickDelta) {
        float targetLayerRoll;
        float targetLayerPitch;
        if (((GlareEntity)glare).isMoving() && !(glare.m_21524_() instanceof LeashFenceKnotEntity) && !((GlareEntity)glare).isGrumpy()) {
            targetLayerPitch = (float)Math.toRadians(10.0);
            targetLayerRoll = (float)Math.toRadians(1.0);
        } else {
            targetLayerPitch = (float)Math.toRadians(1.0);
            targetLayerRoll = (float)Math.toRadians(1.0);
        }
        tickDelta = (float)Math.abs(Math.sin(tickDelta)) * 0.1f;
        float layerPitch = Mth.m_14179_((float)tickDelta, (float)((GlareEntity)glare).getCurrentLayersPitch(), (float)targetLayerPitch);
        float layerRoll = Mth.m_14179_((float)tickDelta, (float)((GlareEntity)glare).getCurrentLayersRoll(), (float)targetLayerRoll);
        ((GlareEntity)glare).setCurrentLayerPitch(layerPitch);
        ((GlareEntity)glare).setCurrentLayerRoll(layerRoll);
    }

    private void animateHead(T glare, float animationProgress) {
        if (((GlareEntity)glare).isGrumpy()) {
            ModelPartAnimator.setXPosition(this.root, AnimationMath.sin(animationProgress, 0.5f));
            ModelPartAnimator.setYPosition(this.root, AnimationMath.absSin(animationProgress, 0.1f));
            ModelPartAnimator.setYRotation(this.root, AnimationMath.sin(animationProgress, 0.05f));
        } else {
            float targetPivotY = ((GlareEntity)glare).m_21827_() ? 3.0f : 0.0f;
            GlareEntityModel.animateModelPartYPositionBasedOnTicks(glare, this.root, targetPivotY, 10);
        }
    }

    private void animateEyes(T glare) {
        Vec2 targetEyesPositionOffset = ((GlareEntity)glare).getTargetEyesPositionOffset();
        GlareEntityModel.animateModelPartPositionBasedOnTicks(glare, this.eyes, this.eyes.f_104200_ + targetEyesPositionOffset.f_82470_, this.eyes.f_104201_ + targetEyesPositionOffset.f_82471_, this.eyes.f_104202_, 10);
    }

    private void animateLayers(T glare, float animationProgress) {
        float layerAnimationProgress = animationProgress * 0.1f;
        float targetPitchLayerAnimationProgress = (float)Math.sin(layerAnimationProgress);
        float targetRollLayerAnimationProgress = (float)Math.cos(layerAnimationProgress);
        if (((GlareEntity)glare).isMoving()) {
            targetPitchLayerAnimationProgress = Math.abs(targetPitchLayerAnimationProgress);
            targetRollLayerAnimationProgress = Math.abs(targetRollLayerAnimationProgress);
        } else if (((GlareEntity)glare).m_21827_()) {
            targetPitchLayerAnimationProgress = 0.0f;
            targetRollLayerAnimationProgress = 0.0f;
        }
        float currentPitchLayerAnimationProgress = Mth.m_14179_((float)((float)Math.abs(Math.sin(animationProgress)) * 0.1f), (float)((GlareEntity)glare).getCurrentLayerPitchAnimationProgress(), (float)targetPitchLayerAnimationProgress);
        float currentRollLayerAnimationProgress = Mth.m_14179_((float)((float)Math.abs(Math.sin(animationProgress)) * 0.1f), (float)((GlareEntity)glare).getCurrentLayerRollAnimationProgress(), (float)targetRollLayerAnimationProgress);
        for (ModelPart layer : this.layers) {
            layer.f_104203_ = currentPitchLayerAnimationProgress * ((GlareEntity)glare).getCurrentLayersPitch();
            layer.f_104205_ = currentRollLayerAnimationProgress * ((GlareEntity)glare).getCurrentLayersRoll();
        }
        if (((GlareEntity)glare).isMoving()) {
            this.root.f_104203_ = currentPitchLayerAnimationProgress * ((GlareEntity)glare).getCurrentLayersPitch();
        }
        ((GlareEntity)glare).setCurrentLayerPitchAnimationProgress(currentPitchLayerAnimationProgress);
        ((GlareEntity)glare).setCurrentLayerRollAnimationProgress(currentRollLayerAnimationProgress);
    }

    public void m_7695_(PoseStack matrices, VertexConsumer vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        this.m_142109_().m_104306_(matrices, vertices, light, overlay, red, green, blue, alpha);
    }
}

