/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.api;

import com.faboslav.friendsandfoes.api.MoobloomVariant;
import com.faboslav.friendsandfoes.util.RandomGenerator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.FlowerBlock;
import org.jetbrains.annotations.Nullable;

public final class MoobloomVariants {
    public static final String DEFAULT_VARIANT_NAME = "buttercup";
    private static final HashMap<String, MoobloomVariant> MOOBLOOM_VARIANT_MAP = new HashMap();

    public static boolean contains(String name) {
        return MOOBLOOM_VARIANT_MAP.containsKey(name);
    }

    public static int getNumberOfVariants() {
        return MOOBLOOM_VARIANT_MAP.size();
    }

    public static MoobloomVariant getRandomVariant() {
        Object[] values = MOOBLOOM_VARIANT_MAP.values().toArray();
        return (MoobloomVariant)values[RandomGenerator.generateInt(0, values.length - 1)];
    }

    @Nullable
    public static MoobloomVariant getByName(String name) {
        return MOOBLOOM_VARIANT_MAP.get(name);
    }

    @Nullable
    public static MoobloomVariant getByFlowerBlock(FlowerBlock flower) {
        for (MoobloomVariant moobloomVariant : MOOBLOOM_VARIANT_MAP.values()) {
            if (moobloomVariant.getFlower() != flower) continue;
            return moobloomVariant;
        }
        return null;
    }

    @Nullable
    public static MoobloomVariant getByFlowerItem(Item flowerItem) {
        for (MoobloomVariant moobloomVariant : MOOBLOOM_VARIANT_MAP.values()) {
            if (moobloomVariant.getFlowerAsItem() != flowerItem) continue;
            return moobloomVariant;
        }
        return null;
    }

    public static void add(String name, BushBlock flower) {
        if (MoobloomVariants.contains(name)) {
            throw new IllegalArgumentException(String.format("Variant \"%s\" with flower block \"%s\" is already added.", name, flower.toString()));
        }
        MOOBLOOM_VARIANT_MAP.put(name, new MoobloomVariant(name, flower));
    }

    public static void addMultiple(Map<String, FlowerBlock> items) {
        items.forEach(MoobloomVariants::add);
    }
}

