/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds.env.feature;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import team.creative.ambientsounds.env.feature.AmbientBlockGroup;
import team.creative.ambientsounds.env.pocket.BlockDistribution;

public class AmbientFeatureSelection {
    public transient List<AmbientBlockGroup> group = new ArrayList<AmbientBlockGroup>();
    public String[] groups;
    public AmbientFeatureSelection[] and;
    public AmbientFeatureSelection[] or;
    public AmbientFeatureSelection[] not;
    @SerializedName(value="low-weight")
    public Double lowWeight;
    @SerializedName(value="high-weight")
    public Double highWeight;
    @SerializedName(value="low-count")
    public Double lowCount;
    @SerializedName(value="high-count")
    public Double highCount;

    public void collectGroups(HashSet<String> groups) {
        int i;
        if (this.groups != null) {
            groups.addAll(Arrays.asList(this.groups));
        }
        if (this.and != null) {
            for (i = 0; i < this.and.length; ++i) {
                this.and[i].collectGroups(groups);
            }
        }
        if (this.or != null) {
            for (i = 0; i < this.or.length; ++i) {
                this.or[i].collectGroups(groups);
            }
        }
        if (this.not != null) {
            for (i = 0; i < this.not.length; ++i) {
                this.not[i].collectGroups(groups);
            }
        }
    }

    public double volume(HashMap<String, BlockDistribution> distribution) {
        double volume = 1.0;
        if (this.lowWeight != null || this.highWeight != null || this.lowCount != null || this.highCount != null) {
            BlockDistribution collected = new BlockDistribution();
            for (int i = 0; i < this.groups.length; ++i) {
                BlockDistribution result = distribution.get(this.groups[i]);
                if (result == null) continue;
                collected.add(result);
            }
            if (this.lowWeight != null || this.highWeight != null) {
                if (this.lowWeight != null && this.lowWeight > collected.percentage) {
                    return 0.0;
                }
                if (this.highWeight == null || this.highWeight < collected.percentage) {
                    volume *= 1.0;
                } else {
                    double low = this.lowWeight == null ? 0.0 : this.lowWeight;
                    volume *= (collected.percentage - low) / (this.highWeight - low);
                }
            }
            if (this.lowCount != null || this.highCount != null) {
                if (this.lowCount != null && this.lowCount > collected.count) {
                    return 0.0;
                }
                if (this.highCount == null || this.highCount < collected.count) {
                    volume *= 1.0;
                } else {
                    double low = this.lowCount == null ? 0.0 : this.lowCount;
                    volume *= (collected.count - low) / (this.highCount - low);
                }
            }
        }
        if (this.and != null) {
            for (int i = 0; i < this.and.length; ++i) {
                volume *= this.and[i].volume(distribution);
            }
        }
        if (this.or != null) {
            double orVolume = 0.0;
            for (int i = 0; i < this.or.length; ++i) {
                orVolume = Math.max(orVolume, this.or[i].volume(distribution));
            }
            volume *= orVolume;
        }
        if (this.not != null) {
            for (int i = 0; i < this.not.length; ++i) {
                if (!(this.not[i].volume(distribution) > 0.0)) continue;
                return 0.0;
            }
        }
        return volume;
    }
}

