/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.network.play;

import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.common.WanderingTraderEvents;
import com.mrcrayfish.backpacked.common.backpack.Backpack;
import com.mrcrayfish.backpacked.common.backpack.BackpackManager;
import com.mrcrayfish.backpacked.common.backpack.ModelProperty;
import com.mrcrayfish.backpacked.data.tracker.UnlockManager;
import com.mrcrayfish.backpacked.inventory.ExtendedPlayerInventory;
import com.mrcrayfish.backpacked.item.BackpackItem;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageBackpackCosmetics;
import com.mrcrayfish.backpacked.network.message.MessageEntityBackpack;
import com.mrcrayfish.backpacked.network.message.MessageOpenBackpack;
import com.mrcrayfish.backpacked.network.message.MessageOpenCustomisation;
import com.mrcrayfish.backpacked.network.message.MessageRequestCustomisation;
import com.mrcrayfish.backpacked.network.message.MessageUpdateBackpack;
import com.mrcrayfish.backpacked.platform.Services;
import com.mrcrayfish.backpacked.util.PickpocketUtil;
import com.mrcrayfish.framework.network.message.IMessage;
import java.util.HashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ServerPlayHandler {
    public static void handleCustomiseBackpack(MessageBackpackCosmetics message, ServerPlayer player) {
        ItemStack stack = Services.BACKPACK.getBackpackStack((Player)player);
        if (!stack.m_41619_()) {
            ResourceLocation id = message.getBackpackId();
            Backpack backpack = BackpackManager.instance().getBackpack(id);
            if (backpack == null) {
                return;
            }
            if (!backpack.isUnlocked((Player)player) && !((Boolean)Config.SERVER.common.unlockAllBackpacks.get()).booleanValue()) {
                return;
            }
            CompoundTag tag = stack.m_41784_();
            tag.m_128359_("BackpackModel", id.toString());
            tag.m_128379_(ModelProperty.SHOW_GLINT.getTagName(), message.isShowGlint());
            tag.m_128379_(ModelProperty.SHOW_WITH_ELYTRA.getTagName(), message.isShowWithElytra());
            tag.m_128379_(ModelProperty.SHOW_EFFECTS.getTagName(), message.isShowEffects());
            if (Services.BACKPACK.isUsingThirdPartySlot()) {
                return;
            }
            Inventory inventory = player.m_150109_();
            if (inventory instanceof ExtendedPlayerInventory) {
                ExtendedPlayerInventory inventory2 = (ExtendedPlayerInventory)inventory;
                Network.getPlay().sendToTracking(() -> player, (IMessage)new MessageUpdateBackpack(player.m_19879_(), stack));
                Network.getPlay().sendToPlayer(() -> player, (IMessage)new MessageUpdateBackpack(player.m_19879_(), stack, true));
            }
        }
    }

    public static void handleOpenBackpack(MessageOpenBackpack message, ServerPlayer player) {
        BackpackItem.openBackpack(player, player);
    }

    public static void handleEntityBackpack(MessageEntityBackpack message, ServerPlayer player) {
        Entity entity = player.m_9236_().m_6815_(message.getEntityId());
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity otherEntity = (LivingEntity)entity;
        if (otherEntity instanceof ServerPlayer && !((Boolean)Config.SERVER.common.pickpocketBackpacks.get()).booleanValue()) {
            return;
        }
        if (!PickpocketUtil.canSeeBackpack(otherEntity, (Player)player)) {
            return;
        }
        if (otherEntity instanceof ServerPlayer) {
            ServerPlayer otherPlayer = (ServerPlayer)otherEntity;
            if (BackpackItem.openBackpack(otherPlayer, player)) {
                otherPlayer.m_5661_((Component)Component.m_237115_((String)"message.backpacked.player_opened"), true);
                player.m_9236_().m_6263_((Player)player, otherPlayer.m_20185_(), otherPlayer.m_20186_() + 1.0, otherPlayer.m_20189_(), SoundEvents.f_11678_, SoundSource.PLAYERS, 0.75f, 1.0f);
            }
        } else if (otherEntity instanceof WanderingTrader) {
            WanderingTrader trader = (WanderingTrader)otherEntity;
            WanderingTraderEvents.openBackpack(trader, player);
        }
    }

    public static void handleRequestCustomisation(MessageRequestCustomisation message, ServerPlayer player) {
        if (((Boolean)Config.SERVER.common.disableCustomisation.get()).booleanValue()) {
            return;
        }
        if (Services.BACKPACK.getBackpackStack((Player)player).m_41619_()) {
            return;
        }
        UnlockManager.get((Player)player).ifPresent(unlockTracker -> {
            HashMap<ResourceLocation, Component> map = new HashMap<ResourceLocation, Component>();
            for (Backpack backpack : BackpackManager.instance().getRegisteredBackpacks()) {
                if (unlockTracker.isUnlocked(backpack.getId())) continue;
                unlockTracker.getProgressTracker(backpack.getId()).ifPresent(progressTracker -> map.put(backpack.getId(), progressTracker.getDisplayComponent()));
            }
            Network.getPlay().sendToPlayer(() -> player, (IMessage)new MessageOpenCustomisation(map));
        });
    }
}

