/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.backpack;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.common.backpack.Backpack;
import com.mrcrayfish.backpacked.common.backpack.impl.BambooBasketBackpack;
import com.mrcrayfish.backpacked.common.backpack.impl.CardboardBoxBackpack;
import com.mrcrayfish.backpacked.common.backpack.impl.ClassicBackpack;
import com.mrcrayfish.backpacked.common.backpack.impl.CogwheelBackpack;
import com.mrcrayfish.backpacked.common.backpack.impl.EndCrystalBackpack;
import com.mrcrayfish.backpacked.common.backpack.impl.HoneyJarBackpack;
import com.mrcrayfish.backpacked.common.backpack.impl.MiniChestBackpack;
import com.mrcrayfish.backpacked.common.backpack.impl.PiglinPackBackpack;
import com.mrcrayfish.backpacked.common.backpack.impl.RocketBackpack;
import com.mrcrayfish.backpacked.common.backpack.impl.SheepPlushBackpack;
import com.mrcrayfish.backpacked.common.backpack.impl.StandardBackpack;
import com.mrcrayfish.backpacked.common.backpack.impl.TrashCanBackpack;
import com.mrcrayfish.backpacked.common.backpack.impl.TurtleShellBackpack;
import com.mrcrayfish.backpacked.common.backpack.impl.WanderingBagBackpack;
import com.mrcrayfish.backpacked.data.tracker.UnlockManager;
import com.mrcrayfish.backpacked.network.Network;
import com.mrcrayfish.backpacked.network.message.MessageUnlockBackpack;
import com.mrcrayfish.framework.network.message.IMessage;
import com.mrcrayfish.framework.platform.Services;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class BackpackManager {
    private static BackpackManager instance;
    private final Map<ResourceLocation, Backpack> registeredBackpacks = new HashMap<ResourceLocation, Backpack>();

    public static BackpackManager instance() {
        if (instance == null) {
            instance = new BackpackManager();
        }
        return instance;
    }

    private BackpackManager() {
        this.register(new BambooBasketBackpack());
        this.register(new CardboardBoxBackpack());
        this.register(new ClassicBackpack());
        this.register(new EndCrystalBackpack());
        this.register(new HoneyJarBackpack());
        this.register(new MiniChestBackpack());
        this.register(new PiglinPackBackpack());
        this.register(new RocketBackpack());
        this.register(new SheepPlushBackpack());
        this.register(new StandardBackpack());
        this.register(new TrashCanBackpack());
        this.register(new TurtleShellBackpack());
        this.register(new WanderingBagBackpack());
        this.registerDependant("create", new CogwheelBackpack());
    }

    public synchronized void register(Backpack backpack) {
        this.registeredBackpacks.putIfAbsent(backpack.getId(), backpack);
    }

    private synchronized void registerDependant(String mod, Backpack backpack) {
        if (!Services.PLATFORM.isModLoaded(mod)) {
            return;
        }
        this.registeredBackpacks.putIfAbsent(backpack.getId(), backpack);
    }

    public List<Backpack> getRegisteredBackpacks() {
        return ImmutableList.copyOf(this.registeredBackpacks.values());
    }

    public Backpack getBackpack(ResourceLocation id) {
        return this.registeredBackpacks.get(id);
    }

    public void unlockBackpack(ServerPlayer player, ResourceLocation id) {
        if (((Boolean)Config.SERVER.common.unlockAllBackpacks.get()).booleanValue()) {
            return;
        }
        if (this.registeredBackpacks.containsKey(id)) {
            UnlockManager.get((Player)player).ifPresent(impl -> {
                if (impl.unlockBackpack(id)) {
                    Network.getPlay().sendToPlayer(() -> player, (IMessage)new MessageUnlockBackpack(id));
                }
            });
        }
    }
}

