/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.forge;

import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.sleep_tight.SleepTight;
import net.mehvahdjukaar.sleep_tight.SleepTightClient;
import net.mehvahdjukaar.sleep_tight.SleepTightPlatformStuff;
import net.mehvahdjukaar.sleep_tight.common.InvigoratedEffect;
import net.mehvahdjukaar.sleep_tight.core.ModEvents;
import net.mehvahdjukaar.sleep_tight.core.PlayerSleepData;
import net.mehvahdjukaar.sleep_tight.forge.ForgePlayerSleepCapability;
import net.mehvahdjukaar.sleep_tight.forge.SleepTightForgeClient;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.entity.player.SleepingTimeCheckEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.SleepFinishedTimeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="sleep_tight")
public class SleepTightForge {
    public SleepTightForge() {
        SleepTight.commonInit();
        if (PlatHelper.getPhysicalSide().isClient()) {
            SleepTightClient.init();
            SleepTightForgeClient.init();
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(SleepTightForge::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(SleepTightForge::registerCaps);
    }

    public static void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(SleepTight::commonSetup);
    }

    public static void registerCaps(RegisterCapabilitiesEvent event) {
        event.register(ForgePlayerSleepCapability.class);
    }

    @SubscribeEvent
    public void attachPlayerCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(SleepTight.res("player_data"), (ICapabilityProvider)new ForgePlayerSleepCapability());
        }
    }

    @SubscribeEvent
    public void onSleepConditionCheck(PlayerSleepInBedEvent event) {
        if (!ModEvents.checkExtraSleepConditions(event.getEntity(), event.getPos())) {
            event.setResult(Player.BedSleepingProblem.OTHER_PROBLEM);
        }
    }

    @SubscribeEvent
    public void onSleepTimeCheck(SleepingTimeCheckEvent event) {
        Optional p = event.getSleepingLocation();
        if (p.isPresent()) {
            switch (ModEvents.onCheckSleepTime(event.getEntity().m_9236_(), (BlockPos)p.get())) {
                case FAIL: {
                    event.setResult(Event.Result.DENY);
                    break;
                }
                case CONSUME: 
                case SUCCESS: {
                    event.setResult(Event.Result.ALLOW);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerSetSpawn(PlayerSetSpawnEvent evt) {
        if (!ModEvents.canSetSpawn(evt.getEntity(), evt.getNewSpawn())) {
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onSleepFinished(SleepFinishedTimeEvent evt) {
        LevelAccessor levelAccessor = evt.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            long newTime;
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            long oldTime = evt.getNewTime();
            if (oldTime != (newTime = ModEvents.getWakeUpTimeWhenSlept(serverLevel, oldTime))) {
                evt.setTimeAddition(newTime);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerWakeUp(PlayerWakeUpEvent evt) {
        ModEvents.onWokenUp(evt.getEntity(), evt.updateLevel());
    }

    @SubscribeEvent
    public void onSpawnSet(PlayerSetSpawnEvent evt) {
        BlockPos newSpawn;
        if (evt.getSpawnLevel() == evt.getEntity().m_9236_().m_46472_() && (newSpawn = evt.getNewSpawn()) != null && ModEvents.shouldCancelSetSpawn(evt.getEntity(), newSpawn)) {
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onUseBlock(PlayerInteractEvent.RightClickBlock event) {
        InteractionResult ret;
        if (!event.isCanceled() && (ret = ModEvents.onRightClickBlock(event.getEntity(), event.getLevel(), event.getHand(), event.getHitVec())) != InteractionResult.PASS) {
            event.setCanceled(true);
            event.setCancellationResult(ret);
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ModEvents.onPlayerLoggedIn(player2);
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            Player old = event.getOriginal();
            old.reviveCaps();
            PlayerSleepData oldData = SleepTightPlatformStuff.getPlayerSleepData(old);
            PlayerSleepData newData = SleepTightPlatformStuff.getPlayerSleepData(event.getEntity());
            newData.copyFrom(oldData);
            old.invalidateCaps();
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        ModEvents.onEntityKilled(event.getEntity(), event.getSource().m_7639_());
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        int j;
        int i = event.getExpToDrop();
        if (i > 0 && (j = InvigoratedEffect.onBlockBreak(i, event.getPlayer())) != 0) {
            event.setExpToDrop(i + j);
        }
    }
}

