/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.common.network;

import net.mehvahdjukaar.moonlight.api.platform.network.ChannelHandler;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkDir;
import net.mehvahdjukaar.sleep_tight.common.network.NetworkHandler;
import net.mehvahdjukaar.sleep_tight.common.tiles.HammockTile;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class AccelerateHammockMessage
implements Message {
    private final boolean leftPressed;
    private final BlockPos pos;

    public AccelerateHammockMessage(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.leftPressed = buf.readBoolean();
    }

    public AccelerateHammockMessage(BlockPos pos, boolean leftPressed) {
        this.leftPressed = leftPressed;
        this.pos = pos;
    }

    public void writeToBuffer(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeBoolean(this.leftPressed);
    }

    public void handle(ChannelHandler.Context context) {
        if (context.getDirection() == NetworkDir.PLAY_TO_CLIENT) {
            Level level = Minecraft.m_91087_().f_91075_.m_9236_();
            BlockEntity blockEntity = level.m_7702_(this.pos);
            if (blockEntity instanceof HammockTile) {
                HammockTile tile = (HammockTile)blockEntity;
                if (this.leftPressed) {
                    tile.accelerateLeft();
                } else {
                    tile.accelerateRight();
                }
            }
        } else {
            Player p = context.getSender();
            NetworkHandler.CHANNEL.sentToAllClientPlayersTrackingEntity((Entity)p, (Message)this);
        }
    }
}

