/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sleep_tight.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Optional;
import net.mehvahdjukaar.sleep_tight.common.entities.BedEntity;
import net.mehvahdjukaar.sleep_tight.common.tiles.HammockTile;
import net.mehvahdjukaar.sleep_tight.configs.ClientConfigs;
import net.mehvahdjukaar.sleep_tight.configs.CommonConfigs;
import net.mehvahdjukaar.sleep_tight.core.SleepEffectsHelper;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class ClientEvents {
    public static boolean cameraHack;

    public static <T extends LivingEntity> void rotatePlayerInBed(T entity, PoseStack poseStack, float partialTicks, MultiBufferSource bufferSource) {
        Direction dir;
        BlockPos pos = null;
        Optional p = entity.m_21257_();
        BedEntity bedEntity = null;
        if (p.isPresent()) {
            pos = (BlockPos)p.get();
        } else {
            Entity entity2 = entity.m_20202_();
            if (entity2 instanceof BedEntity) {
                BedEntity be = (BedEntity)entity2;
                pos = be.m_20097_();
                bedEntity = be;
            }
        }
        if (pos == null) {
            return;
        }
        Level level = entity.m_9236_();
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof HammockTile) {
            HammockTile tile = (HammockTile)blockEntity;
            float roll = tile.getRoll(partialTicks);
            float o = tile.getPivotOffset();
            o = (float)((double)o + 0.125);
            Vector3f v = tile.getDirection().m_253071_();
            poseStack.m_252880_(0.0f, o, 0.0f);
            poseStack.m_252781_(Axis.m_253057_((Vector3f)v).m_252977_(roll));
            poseStack.m_252880_(0.0f, -o, 0.0f);
            Minecraft mc = Minecraft.m_91087_();
            if (bedEntity != null) {
                float f1 = 90.0f - tile.getDirection().m_122435_();
                poseStack.m_252781_(Axis.f_252436_.m_252977_(f1));
                poseStack.m_85837_(1.51875, 0.125, 0.0);
            } else if (entity == mc.f_91074_) {
                poseStack.m_85837_(0.0, 0.125, 0.0);
            }
        } else if (bedEntity != null && (dir = BedBlock.m_49485_((BlockGetter)level, (BlockPos)pos)) != null) {
            float f1 = 90.0f - dir.m_122435_();
            poseStack.m_252781_(Axis.f_252436_.m_252977_(f1));
            poseStack.m_85837_(1.5, 0.0, 0.0);
        }
    }

    public static void rotateCameraOverHammockAxis(float partialTicks, PoseStack matrixStack, Camera camera) {
        Player p;
        Minecraft mc = Minecraft.m_91087_();
        Entity e = mc.m_91288_();
        if (e == null || !mc.f_91066_.m_92176_().m_90612_()) {
            return;
        }
        double intensity = ClientConfigs.CAMERA_ROLL_INTENSITY.get();
        if (intensity == 0.0) {
            return;
        }
        BlockPos pos = null;
        boolean onBedEntity = false;
        Entity entity = e.m_20202_();
        if (entity instanceof BedEntity) {
            BedEntity bed = (BedEntity)entity;
            onBedEntity = true;
            pos = bed.m_20097_();
        } else if (e instanceof Player) {
            p = (Player)e;
            pos = p.m_21257_().orElse(null);
        }
        if (pos != null && (p = e.m_9236_().m_7702_(pos)) instanceof HammockTile) {
            HammockTile tile = (HammockTile)p;
            Quaternionf q = new Quaternionf((Quaternionfc)camera.m_253121_());
            q.conjugate();
            matrixStack.m_252781_(q);
            float roll = (float)((double)tile.getRoll(partialTicks) * intensity);
            float o = 0.375f - tile.getPivotOffset();
            matrixStack.m_252880_(0.0f, -o, 0.0f);
            matrixStack.m_252781_(Axis.m_253057_((Vector3f)tile.getDirection().m_253071_()).m_252977_(roll));
            matrixStack.m_252880_(0.0f, o, 0.0f);
            matrixStack.m_252781_(camera.m_253121_());
        }
        if (onBedEntity) {
            matrixStack.m_85837_(0.0, -0.3, 0.0);
        }
    }

    public static void onSleepStarted(Entity entity, BlockState state, BlockPos pos) {
        Player player;
        BlockPos partnerPos;
        if (entity instanceof Player && (partnerPos = SleepEffectsHelper.getPartnerPos(player = (Player)entity, state, pos)) != null) {
            entity.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123750_, 0.5 + (double)((float)(pos.m_123341_() + partnerPos.m_123341_()) / 2.0f), 0.6 + (double)((float)(pos.m_123342_() + partnerPos.m_123342_()) / 2.0f), 0.5 + (double)((float)(pos.m_123343_() + partnerPos.m_123343_()) / 2.0f), 0.0, 0.0, 0.0);
        }
    }

    public static void displayRidingMessage(BedEntity bed) {
        Minecraft mc = Minecraft.m_91087_();
        if (!CommonConfigs.SLEEP_IMMEDIATELY.get().booleanValue()) {
            Component component = bed.getRidingMessage(mc.f_91066_.f_92089_.m_90863_(), mc.f_91066_.f_92090_.m_90863_());
            mc.f_91065_.m_93063_(component, false);
            mc.m_240477_().m_168785_(component);
        }
    }
}

