/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.spawner;

import com.mrcrayfish.goblintraders.entity.AbstractGoblinEntity;
import com.mrcrayfish.goblintraders.spawner.IGoblinData;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.saveddata.SavedData;

public class GoblinTraderSpawner
extends SavedData {
    private static final Map<EntityType<?>, SpawnData> SPAWN_DATA = new HashMap();
    private static final int SAFE_POSITION_ATTEMPTS = 50;
    private static final int MIN_SPAWN_DISTANCE = 5;
    private static final int GROUND_SEARCH_DISTANCE = 5;
    private final MinecraftServer server;
    private final ServerLevel level;
    private final EntityType<? extends AbstractGoblinEntity> type;
    private final IGoblinData data;
    private int runDelay;
    private int spawnChance;

    public GoblinTraderSpawner(MinecraftServer server, ServerLevel level, EntityType<? extends AbstractGoblinEntity> type, IGoblinData data) {
        this.server = server;
        this.level = level;
        this.type = type;
        this.data = data;
        this.runDelay = data.getSpawnDelay();
        this.spawnChance = data.getSpawnChance();
    }

    public void serverTick() {
        if (!this.level.m_46469_().m_46207_(GameRules.f_46125_)) {
            return;
        }
        --this.runDelay;
        if (this.runDelay > 0) {
            return;
        }
        this.runDelay = this.data.getSpawnInterval();
        if (!this.level.m_46469_().m_46207_(GameRules.f_46134_)) {
            return;
        }
        double randomChance = this.level.m_213780_().m_188500_();
        if ((double)this.spawnChance / 100.0 < randomChance) {
            this.spawnChance = Math.min(this.spawnChance + this.data.getSpawnChance(), 100);
            return;
        }
        if (this.spawnGoblin()) {
            this.runDelay = this.data.getSpawnDelay();
            this.spawnChance = this.data.getSpawnChance();
        }
    }

    private boolean spawnGoblin() {
        ServerPlayer player = this.level.m_8890_();
        if (player == null) {
            return false;
        }
        BlockPos pos = this.createSpawnPosition(player.m_20183_(), 16);
        if (pos == null) {
            return false;
        }
        if (this.level.m_204166_(pos).m_203565_(Biomes.f_48173_)) {
            return false;
        }
        if (pos.m_123342_() < this.data.getMinSpawnYLevel() || pos.m_123342_() >= this.data.getMaxSpawnYLevel()) {
            return false;
        }
        AbstractGoblinEntity goblin = (AbstractGoblinEntity)this.type.m_262496_(this.level, pos, MobSpawnType.EVENT);
        if (goblin == null) {
            return false;
        }
        this.runDelay = this.data.getSpawnDelay();
        goblin.setDespawnDelay(this.data.getDespawnDelay());
        goblin.m_21446_(pos, 16);
        return true;
    }

    @Nullable
    private BlockPos createSpawnPosition(BlockPos center, int range) {
        for (int i = 0; i < 50; ++i) {
            int posZ;
            int posY;
            int posX = center.m_123341_() + this.createRandomSpawnableDistance(range);
            BlockPos pos = this.findGround(new BlockPos(posX, posY = center.m_123342_() + this.createRandomSpawnableDistance(range), posZ = center.m_123343_() + this.createRandomSpawnableDistance(range)));
            if (pos == null || pos.m_123314_((Vec3i)center, 5.0) || !NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (LevelReader)this.level, (BlockPos)pos, this.type)) continue;
            return pos;
        }
        return null;
    }

    private int createRandomSpawnableDistance(int maxSpawnDistance) {
        RandomSource random = this.level.m_213780_();
        int direction = random.m_188503_(2) == 0 ? 1 : -1;
        int spawnableRange = Math.max(maxSpawnDistance - 5, 0);
        return (5 + random.m_216332_(0, spawnableRange)) * direction;
    }

    @Nullable
    private BlockPos findGround(BlockPos pos) {
        int i;
        boolean colliding = this.canCollide(pos);
        BlockPos testPos = pos.m_7495_();
        for (i = 0; i < 5 && Level.m_46741_((BlockPos)testPos); ++i) {
            if (!this.canCollide(testPos)) {
                colliding = false;
                testPos = testPos.m_7495_();
                continue;
            }
            if (colliding) continue;
            return testPos.m_7494_();
        }
        colliding = this.canCollide(pos);
        testPos = pos.m_7494_();
        for (i = 0; i < 5 && Level.m_46741_((BlockPos)testPos); ++i) {
            if (this.canCollide(testPos)) {
                colliding = true;
                testPos = testPos.m_7494_();
                continue;
            }
            if (!colliding) continue;
            return testPos;
        }
        return null;
    }

    private boolean canCollide(BlockPos pos) {
        return !this.level.m_8055_(pos).m_60812_((BlockGetter)this.level, pos).m_83281_();
    }

    public GoblinTraderSpawner load(CompoundTag tag) {
        if (tag.m_128425_("RunDelay", 3)) {
            this.runDelay = tag.m_128451_("RunDelay");
        }
        if (tag.m_128425_("SpawnChance", 3)) {
            this.spawnChance = tag.m_128451_("SpawnChance");
        }
        return this;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        tag.m_128405_("RunDelay", this.runDelay);
        tag.m_128405_("SpawnChance", this.spawnChance);
        return tag;
    }

    public static Optional<GoblinTraderSpawner> get(MinecraftServer server, EntityType<? extends AbstractGoblinEntity> type) {
        ServerLevel level;
        SpawnData data = SPAWN_DATA.get(type);
        if (data != null && (level = server.m_129880_(data.levelKey())) != null) {
            String storageKey = BuiltInRegistries.f_256780_.m_7981_(type) + "_spawner";
            return Optional.of((GoblinTraderSpawner)level.m_8895_().m_164861_(tag -> new GoblinTraderSpawner(server, level, type, data.goblinData().get()).load((CompoundTag)tag), () -> new GoblinTraderSpawner(server, level, type, data.goblinData().get()), storageKey));
        }
        return Optional.empty();
    }

    public static void register(EntityType<? extends AbstractGoblinEntity> type, ResourceKey<Level> levelKey, Supplier<IGoblinData> goblinData) {
        SPAWN_DATA.putIfAbsent(type, new SpawnData(levelKey, goblinData));
    }

    private record SpawnData(ResourceKey<Level> levelKey, Supplier<IGoblinData> goblinData) {
    }
}

