/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.nbt.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.zip.InflaterInputStream;
import org.popcraft.chunky.nbt.CompoundTag;
import org.popcraft.chunky.nbt.IntTag;
import org.popcraft.chunky.nbt.Tag;
import org.popcraft.chunky.nbt.util.Chunk;
import org.popcraft.chunky.nbt.util.ChunkPos;

public final class RegionFile {
    private static final int ENTRIES = 1024;
    private static final int SECTOR_SIZE = 4096;
    private final Set<Chunk> chunks = new HashSet<Chunk>();
    private final Map<ChunkPos, Chunk> chunkMap = new HashMap<ChunkPos, Chunk>();

    public RegionFile(File file) {
        try (RandomAccessFile region = new RandomAccessFile(file, "r");){
            int i;
            int[] offsetTable = new int[1024];
            int[] sizeTable = new int[1024];
            for (int i2 = 0; i2 < 1024; ++i2) {
                int location = region.readInt();
                offsetTable[i2] = location >> 8 & 0xFFFFFF;
                sizeTable[i2] = location & 0xFF;
            }
            int[] timestampTable = new int[1024];
            for (i = 0; i < 1024; ++i) {
                timestampTable[i] = region.readInt();
            }
            for (i = 0; i < 1024; ++i) {
                int offset = offsetTable[i] * 4096;
                int size = sizeTable[i] * 4096;
                if (offset == 0 && size == 0) continue;
                region.seek(offset);
                int length = region.readInt();
                byte compressionType = region.readByte();
                if (compressionType != 2) {
                    throw new UnsupportedOperationException("Not in zlib format");
                }
                byte[] compressed = new byte[length - 1];
                region.readFully(compressed);
                DataInputStream input = new DataInputStream(new InflaterInputStream(new ByteArrayInputStream(compressed)));
                Tag tag = Tag.load(input);
                if (!(tag instanceof CompoundTag)) continue;
                CompoundTag data = (CompoundTag)tag;
                this.chunks.add(new Chunk(data, timestampTable[i]));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (Chunk chunk : this.chunks) {
            CompoundTag data = chunk.getData();
            Optional<IntTag> xPos = data.getInt("xPos");
            Optional<IntTag> zPos = data.getInt("zPos");
            if (!xPos.isPresent() || !zPos.isPresent()) continue;
            int x = xPos.get().value();
            int z = zPos.get().value();
            this.chunkMap.put(ChunkPos.of(x, z), chunk);
        }
    }

    public Collection<Chunk> getChunks() {
        return this.chunks;
    }

    public Optional<Chunk> getChunk(int x, int z) {
        return Optional.ofNullable(this.chunkMap.get(ChunkPos.of(x, z)));
    }
}

