/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.iterator;

import org.popcraft.chunky.Selection;
import org.popcraft.chunky.iterator.ChunkIterator;
import org.popcraft.chunky.iterator.ConcentricChunkIterator;
import org.popcraft.chunky.iterator.CsvChunkIterator;
import org.popcraft.chunky.iterator.Loop2ChunkIterator;
import org.popcraft.chunky.iterator.RegionChunkIterator;
import org.popcraft.chunky.iterator.SpiralChunkIterator;

public final class ChunkIteratorFactory {
    private ChunkIteratorFactory() {
    }

    public static ChunkIterator getChunkIterator(Selection selection, long count) {
        String shape = selection.shape();
        if ("rectangle".equals(shape) || "ellipse".equals(shape) || "oval".equals(shape)) {
            return new Loop2ChunkIterator(selection, count);
        }
        return switch (selection.pattern().getType()) {
            case "loop" -> new Loop2ChunkIterator(selection, count);
            case "spiral" -> new SpiralChunkIterator(selection, count);
            case "csv" -> new CsvChunkIterator(selection, count);
            case "concentric" -> new ConcentricChunkIterator(selection, count);
            default -> new RegionChunkIterator(selection, count);
        };
    }

    public static ChunkIterator getChunkIterator(Selection selection) {
        return ChunkIteratorFactory.getChunkIterator(selection, 0L);
    }
}

