/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.natives.event.entity.living;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.event.ForgeEventCancellationCarrier;
import com.blamejared.crafttweaker.api.event.ZenEvent;
import com.blamejared.crafttweaker.api.event.bus.ForgeEventBusWire;
import com.blamejared.crafttweaker.api.event.bus.IEventBus;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenEvent
@Document(value="forge/api/event/entity/living/LivingDropsEvent")
@NativeTypeRegistration(value=LivingDropsEvent.class, zenCodeName="crafttweaker.forge.api.event.entity.living.LivingDropsEvent")
public class ExpandLivingDropsEvent {
    @ZenEvent.Bus
    public static final IEventBus<LivingDropsEvent> BUS = IEventBus.cancelable(LivingDropsEvent.class, ForgeEventBusWire.of(), ForgeEventCancellationCarrier.of());

    @ZenCodeType.Getter(value="source")
    public static DamageSource getSource(LivingDropsEvent internal) {
        return internal.getSource();
    }

    @ZenCodeType.Getter(value="drops")
    public static List<IItemStack> getDrops(LivingDropsEvent internal) {
        return internal.getDrops().stream().map(ItemEntity::m_32055_).map(IItemStack::of).collect(Collectors.toList());
    }

    @ZenCodeType.Setter(value="drops")
    public static void setDrops(LivingDropsEvent internal, List<IItemStack> drops) {
        internal.getDrops().clear();
        drops.forEach(drop -> ExpandLivingDropsEvent.addDrop(internal, drop));
    }

    @ZenCodeType.Getter(value="lootingLevel")
    public static int getLootingLevel(LivingDropsEvent internal) {
        return internal.getLootingLevel();
    }

    @ZenCodeType.Getter(value="isRecentlyHit")
    public static boolean isRecentlyHit(LivingDropsEvent internal) {
        return internal.isRecentlyHit();
    }

    @ZenCodeType.Method
    public static void addDrop(LivingDropsEvent internal, IItemStack stack) {
        LivingEntity entity = internal.getEntity();
        internal.getDrops().add(new ItemEntity(entity.f_19853_, entity.m_20185_() + 0.5, entity.m_20186_() + 0.5, entity.m_20189_() + 0.5, stack.getImmutableInternal()));
    }

    @ZenCodeType.Method
    public static void removeDrop(LivingDropsEvent internal, IIngredient ingredient) {
        internal.getDrops().removeIf(itemEntity -> ingredient.matches(IItemStack.ofMutable(itemEntity.m_32055_())));
    }
}

