/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.recipe.handler.type.vanilla;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.component.BuiltinRecipeComponents;
import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import com.blamejared.crafttweaker.api.util.StringUtil;
import com.blamejared.crafttweaker.platform.Services;
import com.mojang.datafixers.util.Pair;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;

@IRecipeHandler.For(value=ShapedRecipe.class)
public final class ShapedRecipeHandler
implements IRecipeHandler<ShapedRecipe> {
    @Override
    public String dumpToCommandString(IRecipeManager<? super ShapedRecipe> manager, ShapedRecipe recipe) {
        NonNullList ingredients = recipe.m_7527_();
        return String.format("craftingTable.addShaped(%s, %s, %s);", StringUtil.quoteAndEscape(recipe.m_6423_()), ItemStackUtil.getCommandString(recipe.m_8043_()), IntStream.range(0, recipe.m_44221_()).mapToObj(y -> IntStream.range(0, recipe.m_44220_()).mapToObj(x -> (Ingredient)ingredients.get(y * recipe.m_44220_() + x)).map(IIngredient::fromIngredient).map(IIngredient::getCommandString).collect(Collectors.joining(", ", "[", "]"))).collect(Collectors.joining(", ", "[", "]")));
    }

    @Override
    public <U extends Recipe<?>> boolean doesConflict(IRecipeManager<? super ShapedRecipe> manager, ShapedRecipe firstRecipe, U secondRecipe) {
        return Services.PLATFORM.doCraftingTableRecipesConflict(manager, (Recipe<?>)firstRecipe, secondRecipe);
    }

    @Override
    public Optional<IDecomposedRecipe> decompose(IRecipeManager<? super ShapedRecipe> manager, ShapedRecipe recipe) {
        List<IIngredient> ingredients = recipe.m_7527_().stream().map(IIngredient::fromIngredient).toList();
        IDecomposedRecipe decomposedRecipe = IDecomposedRecipe.builder().with(BuiltinRecipeComponents.Metadata.GROUP, recipe.m_6076_()).with(BuiltinRecipeComponents.Metadata.CRAFTING_BOOK_CATEGORY, recipe.m_245232_()).with(BuiltinRecipeComponents.Metadata.SHAPE_SIZE_2D, Pair.of((Object)recipe.m_44220_(), (Object)recipe.m_44221_())).with(BuiltinRecipeComponents.Input.INGREDIENTS, ingredients).with(BuiltinRecipeComponents.Output.ITEMS, IItemStack.of(recipe.m_8043_())).build();
        return Optional.of(decomposedRecipe);
    }

    @Override
    public Optional<ShapedRecipe> recompose(IRecipeManager<? super ShapedRecipe> manager, ResourceLocation name, IDecomposedRecipe recipe) {
        String group = recipe.getOrThrowSingle(BuiltinRecipeComponents.Metadata.GROUP);
        CraftingBookCategory category = recipe.getOrThrowSingle(BuiltinRecipeComponents.Metadata.CRAFTING_BOOK_CATEGORY);
        Pair<Integer, Integer> size = recipe.getOrThrowSingle(BuiltinRecipeComponents.Metadata.SHAPE_SIZE_2D);
        List<IIngredient> ingredients = recipe.getOrThrow(BuiltinRecipeComponents.Input.INGREDIENTS);
        IItemStack output = recipe.getOrThrowSingle(BuiltinRecipeComponents.Output.ITEMS);
        int width = (Integer)size.getFirst();
        int height = (Integer)size.getSecond();
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Invalid shape size: bounds must be positive but got " + size);
        }
        if (width * height != ingredients.size()) {
            throw new IllegalArgumentException("Invalid shape size: incompatible with ingredients, got " + size + " with " + ingredients.size());
        }
        if (output.isEmpty()) {
            throw new IllegalArgumentException("Invalid output: empty item");
        }
        NonNullList recipeIngredients = ingredients.stream().map(IIngredient::asVanillaIngredient).collect(NonNullList::m_122779_, AbstractList::add, AbstractCollection::addAll);
        return Optional.of(new ShapedRecipe(name, group, category, width, height, recipeIngredients, output.getInternal()));
    }
}

