/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.loot;

import com.blamejared.crafttweaker.impl.loot.CraftTweakerPrivilegedLootModifierEntrySet;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.loot.IGlobalLootModifier;

public final class CraftTweakerPrivilegedLootModifierMap
extends AbstractMap<ResourceLocation, IGlobalLootModifier> {
    private final Map<ResourceLocation, IGlobalLootModifier> defaultMap;
    private final Map<ResourceLocation, IGlobalLootModifier> ctMap;

    private CraftTweakerPrivilegedLootModifierMap(Map<ResourceLocation, IGlobalLootModifier> clone) {
        if (clone instanceof CraftTweakerPrivilegedLootModifierMap) {
            CraftTweakerPrivilegedLootModifierMap other = (CraftTweakerPrivilegedLootModifierMap)clone;
            this.defaultMap = new HashMap<ResourceLocation, IGlobalLootModifier>(other.defaultMap);
            this.ctMap = new LinkedHashMap<ResourceLocation, IGlobalLootModifier>(other.ctMap);
        } else {
            this.defaultMap = new HashMap<ResourceLocation, IGlobalLootModifier>();
            this.ctMap = new LinkedHashMap<ResourceLocation, IGlobalLootModifier>();
            this.putAll(clone);
        }
    }

    public static Map<ResourceLocation, IGlobalLootModifier> of(Map<ResourceLocation, IGlobalLootModifier> clone) {
        return new CraftTweakerPrivilegedLootModifierMap(clone);
    }

    private static boolean isCtModifier(ResourceLocation key) {
        return "crafttweaker".equals(key.m_135827_());
    }

    @Override
    public int size() {
        return this.defaultMap.size() + this.ctMap.size();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.defaultMap.containsValue(value) || this.ctMap.containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.defaultMap.containsKey(key) || this.ctMap.containsKey(key);
    }

    @Override
    public IGlobalLootModifier get(Object key) {
        IGlobalLootModifier v = this.defaultMap.get(key);
        return v == null ? this.ctMap.get(key) : v;
    }

    @Override
    public IGlobalLootModifier put(ResourceLocation key, IGlobalLootModifier value) {
        if (CraftTweakerPrivilegedLootModifierMap.isCtModifier(key)) {
            return this.ctMap.put(key, value);
        }
        return this.defaultMap.put(key, value);
    }

    @Override
    public IGlobalLootModifier remove(Object key) {
        IGlobalLootModifier v = this.defaultMap.remove(key);
        return v == null ? this.ctMap.remove(key) : v;
    }

    @Override
    public void clear() {
        this.defaultMap.clear();
        this.ctMap.clear();
    }

    @Override
    public Set<Map.Entry<ResourceLocation, IGlobalLootModifier>> entrySet() {
        return CraftTweakerPrivilegedLootModifierEntrySet.wrap(this.defaultMap.entrySet(), this.ctMap.entrySet(), CraftTweakerPrivilegedLootModifierMap::isCtModifier);
    }
}

