/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.util;

import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.converter.tag.TagToDataConverter;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public final class ItemStackUtil {
    public static String getCommandString(ItemStack stack) {
        return ItemStackUtil.getCommandString(stack, false);
    }

    public static String getCommandString(ItemStack stack, boolean mutable) {
        StringBuilder sb = new StringBuilder("<item:").append(BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_())).append('>');
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            IData data = Objects.requireNonNull(TagToDataConverter.convert((Tag)tag)).copyInternal();
            if (stack.m_41720_().m_41465_()) {
                data.remove("Damage");
            }
            if (!data.isEmpty()) {
                sb.append(".withTag(").append(data.asString()).append(')');
            }
        }
        if (stack.m_41773_() > 0) {
            sb.append(".withDamage(").append(stack.m_41773_()).append(')');
        }
        if (!stack.m_41619_() && stack.m_41613_() != 1) {
            sb.append(" * ").append(stack.m_41613_());
        }
        if (mutable) {
            sb.insert(0, '(').append(").mutable()");
        }
        return sb.toString();
    }

    public static boolean areStacksTheSame(ItemStack first, ItemStack second) {
        return ItemStackUtil.areStacksTheSame(first, second, false);
    }

    public static boolean areStacksTheSame(ItemStack first, ItemStack second, boolean ignoreDamage) {
        return ItemStackUtil.areStacksTheSame(first, second, ignoreDamage, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean areStacksTheSame(ItemStack first, ItemStack second, boolean ignoreDamage, boolean partial) {
        if (first.m_41619_() != second.m_41619_()) {
            return false;
        }
        if (first.m_41720_() != second.m_41720_()) {
            return false;
        }
        if (first.m_41613_() > second.m_41613_()) {
            return false;
        }
        if (!ignoreDamage && first.m_41773_() != second.m_41773_()) {
            return false;
        }
        CompoundTag firstTag = first.m_41783_();
        CompoundTag secondTag = second.m_41783_();
        if (firstTag == null) {
            return true;
        }
        if (secondTag == null) {
            return false;
        }
        Tag firstDamage = firstTag.m_128423_("Damage");
        Tag secondDamage = secondTag.m_128423_("Damage");
        try {
            if (ignoreDamage) {
                firstTag.m_128473_("Damage");
                secondTag.m_128473_("Damage");
            }
            if (!partial) {
                boolean bl = firstTag.equals((Object)secondTag);
                return bl;
            }
            boolean bl = ItemStackUtil.areStackTagsPartiallyEqual(firstTag, secondTag);
            return bl;
        }
        finally {
            if (firstDamage != null) {
                firstTag.m_128365_("Damage", firstDamage);
            }
            if (secondDamage != null) {
                secondTag.m_128365_("Damage", secondDamage);
            }
        }
    }

    private static boolean areStackTagsPartiallyEqual(CompoundTag partial, CompoundTag actual) {
        if (partial == actual) {
            return true;
        }
        if (partial == null || actual == null) {
            return false;
        }
        IData partialData = TagToDataConverter.convert((Tag)partial);
        IData actualData = TagToDataConverter.convert((Tag)actual);
        assert (partialData != null && actualData != null);
        return actualData.contains(partialData);
    }
}

